/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.tornado;

import com.corosus.coroutil.util.CoroUtilBlock;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.entity.ParticleTexFX;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import weather2.weathersystem.tornado.CubicBezierCurve;

public class TornadoFunnel {
    public Vector3d pos = new Vector3d(0.0, 0.0, 0.0);
    public LinkedList<FunnelPiece> listFunnel = new LinkedList();
    public int amountPerLayer = 30;
    public int particleCount = this.amountPerLayer * 50;
    public int funnelPieces = 2;
    CubicBezierCurve bezierCurve;

    public void tickGame() {
        this.amountPerLayer = 30;
        this.particleCount = this.amountPerLayer * 50;
        this.funnelPieces = 10;
        this.tickGameTestCreate();
        this.tickUpdateFunnel();
    }

    private void tickGameTestCreate() {
        LocalPlayer entP = Minecraft.getInstance().player;
        Random rand = new Random();
        while (this.listFunnel.size() < this.funnelPieces) {
            this.addPieceToEnd(new FunnelPiece());
        }
        for (int i = 0; i < this.listFunnel.size(); ++i) {
            int ii;
            Vector3f[] vecs;
            FunnelPiece piece = this.listFunnel.get(i);
            if (piece.needInit) {
                piece.needInit = false;
                int height = 10;
                if (i == 0) {
                    piece.posStart = new Vector3d(entP.getX(), entP.getY(), entP.getZ());
                    piece.posEnd = new Vector3d(entP.getX(), entP.getY() + (double)height, entP.getZ());
                } else {
                    Vector3d prev = this.listFunnel.get((int)(i - 1)).posEnd;
                    piece.posStart = new Vector3d(prev.x, prev.y, prev.z);
                    piece.posEnd = new Vector3d(piece.posStart.x, piece.posStart.y + (double)height, piece.posStart.z);
                }
                if (i == this.funnelPieces - 1) {
                    piece.posEnd = new Vector3d(piece.posStart.x, piece.posStart.y + (double)height, piece.posStart.z);
                }
                piece.vecDirX = rand.nextBoolean() ? 1.0f : -1.0f;
                piece.vecDirZ = rand.nextBoolean() ? 1.0f : -1.0f;
            }
            double dist = this.distanceTo(piece.posStart, piece.posEnd);
            double sizeXYParticle = 1.0;
            double funnelRadius = 3.0;
            double circumference = funnelRadius * 2.0 * Math.PI;
            this.amountPerLayer = (int)(circumference / sizeXYParticle);
            int layers = (int)(dist / sizeXYParticle);
            this.particleCount = layers * this.amountPerLayer;
            if (piece.bezierCurve == null || entP.level().getGameTime() % 40L == 0L) {
                vecs = new Vector3f[4];
                for (ii = 0; ii < vecs.length; ++ii) {
                    vecs[ii] = new Vector3f(entP.level().random.nextFloat(), entP.level().random.nextFloat(), entP.level().random.nextFloat());
                }
                piece.bezierCurve = new CubicBezierCurve(vecs);
            }
            if (this.bezierCurve == null || entP.level().getGameTime() % 40L == 0L) {
                vecs = new Vector3f[4];
                for (ii = 0; ii < vecs.length; ++ii) {
                    vecs[ii] = new Vector3f(entP.level().random.nextFloat(), entP.level().random.nextFloat(), entP.level().random.nextFloat());
                }
                this.bezierCurve = new CubicBezierCurve(vecs);
            }
            while (piece.listParticles.size() < this.particleCount) {
                BlockPos pos = CoroUtilBlock.blockPos((double)piece.posEnd.x, (double)piece.posEnd.y, (double)piece.posEnd.z);
                ClientLevel world = (ClientLevel)entP.level();
                ParticleTexFX particleTest = new ParticleTexFX(world, (float)pos.getX() + rand.nextFloat(), pos.getY(), (float)pos.getZ() + rand.nextFloat(), 0.0, 0.0, 0.0, ParticleRegistry.square16);
                particleTest.setMaxAge(250);
                particleTest.setParticleSpeed(0.0, 0.0, 0.0);
                particleTest.setScale(0.1f);
                particleTest.setColor(world.random.nextFloat(), world.random.nextFloat(), world.random.nextFloat());
                particleTest.setGravity(0.0f);
                Minecraft.getInstance().particleEngine.add((Particle)particleTest);
                piece.listParticles.add(particleTest);
            }
        }
    }

    private void tickUpdateFunnel() {
        ClientLevel world = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        for (int ii = 0; ii < this.listFunnel.size(); ++ii) {
            FunnelPiece piece = this.listFunnel.get(ii);
            double rate = 0.2f;
            double distMax = 5 + (this.listFunnel.size() - ii);
            Random rand = new Random();
            piece.posEnd.add((Vector3dc)new Vector3d(rate * (double)piece.vecDirX, 0.0, rate * (double)piece.vecDirZ * 0.7));
            int offset = 360 / this.listFunnel.size();
            long timeC = (world.getGameTime() * (long)(ii + 1) + (long)(offset * ii)) * 1L;
            float range = 35.0f;
            float speedAmp = 0.3f;
            double xx1 = piece.posEnd.x - piece.posStart.x;
            double zz1 = piece.posEnd.z - piece.posStart.z;
            double xzDist2 = Mth.sqrt((float)((float)(xx1 * xx1 + zz1 * zz1)));
            if (xzDist2 > distMax) {
                if (piece.posEnd.x - piece.posStart.x > 0.0) {
                    piece.vecDirX = -1.0f;
                    piece.vecDirX *= 0.5f + rand.nextFloat() + (float)ii * speedAmp;
                }
                if (piece.posEnd.x - piece.posStart.x < 0.0) {
                    piece.vecDirX = 1.0f;
                    piece.vecDirX *= 0.5f + rand.nextFloat() + (float)ii * speedAmp;
                }
                if (piece.posEnd.z - piece.posStart.z > 0.0) {
                    piece.vecDirZ = -1.0f;
                    piece.vecDirZ *= 0.5f + rand.nextFloat() + (float)ii * speedAmp;
                }
                if (piece.posEnd.z - piece.posStart.z < 0.0) {
                    piece.vecDirZ = 1.0f;
                    piece.vecDirZ *= 0.5f + rand.nextFloat() + (float)ii * speedAmp;
                }
            }
            if (ii > 0) {
                Vector3d prev = this.listFunnel.get((int)(ii - 1)).posEnd;
                piece.posStart = new Vector3d(prev.x, prev.y, prev.z);
            }
            double dist = this.distanceTo(piece.posStart, piece.posEnd);
            double x1 = piece.posEnd.x - piece.posStart.x;
            double y1 = piece.posEnd.y - piece.posStart.y;
            double z1 = piece.posEnd.z - piece.posStart.z;
            Vector3d vec = new Vector3d(x1 / dist, y1 / dist, z1 / dist);
            double sizeXYParticle = 1.0;
            double funnelRadius = 3.0;
            double circumference = funnelRadius * 2.0 * Math.PI;
            this.amountPerLayer = (int)(circumference / sizeXYParticle);
            int layers = (int)(dist / sizeXYParticle);
            this.particleCount = layers * this.amountPerLayer;
            Iterator<ParticleTexFX> it = piece.listParticles.iterator();
            int index = 0;
            while (it.hasNext()) {
                ParticleTexFX part = it.next();
                if (!part.isAlive()) {
                    it.remove();
                } else {
                    int particleCountCircle = 20;
                    int particleCountLayers = 40;
                    int yIndex = index / this.amountPerLayer;
                    int rotIndex = index % this.amountPerLayer;
                    int yCount = this.particleCount / this.amountPerLayer;
                    float x = 0.0f;
                    float y = index % particleCountCircle * (360 / particleCountCircle);
                    float y2 = world.getGameTime() * 3L % 360L + (long)(index % particleCountCircle * (360 / particleCountCircle));
                    float z = 0.0f;
                    int testY = 100;
                    float dist2 = (float)Math.sqrt(this.distanceTo(piece.posStart, piece.posEnd));
                    Vector3f vecDiff = new Vector3f((float)(piece.posStart.x - piece.posEnd.x) / dist2, (float)(piece.posStart.y - piece.posEnd.y) / dist2, (float)(piece.posStart.z - piece.posEnd.z) / dist2);
                    Vector3f vecAngles = new Vector3f((float)Math.atan2(vecDiff.y(), vecDiff.z()), (float)Math.atan2(vecDiff.z(), vecDiff.x()), (float)Math.atan2(vecDiff.x(), vecDiff.y()));
                    vecAngles = new Vector3f((float)Math.toDegrees(vecAngles.x()), (float)Math.toDegrees(vecAngles.y()), (float)Math.toDegrees(vecAngles.z()));
                    double xx = piece.posStart.x - piece.posEnd.x;
                    double zz = piece.posStart.z - piece.posEnd.z;
                    double xzDist = Math.sqrt(xx * xx + zz * zz);
                    float pitchAngle = (float)Math.toDegrees(Math.atan2(vecDiff.y(), xzDist / (double)dist2));
                    pitchAngle += 90.0f;
                    y = vecAngles.y() - 90.0f;
                    double curvePoint = Math.min(1.0f, (float)(index / particleCountCircle) / (float)particleCountLayers);
                    double curvePoint2 = index / particleCountCircle;
                    double yDiff = curvePoint2 * (dist / (double)particleCountLayers);
                    float yDiffDist = 2.0f;
                    float curveAmp = 1.0f;
                    Quaternionf quaternionY = new Quaternionf(0.0, 1.0, 0.0, Math.toRadians(-y));
                    Quaternionf quaternionYCircle = new Quaternionf(0.0, 1.0, 0.0, Math.toRadians(-y2));
                    Quaternionf quatPitch = new Quaternionf(1.0, 0.0, 0.0, Math.toRadians(-pitchAngle));
                    Vector3f vecCurve = piece.bezierCurve.getValue((float)curvePoint);
                    Vector3f vecNew = new Vector3f(vecCurve.x() * curveAmp, 1.0f + (float)yDiff * yDiffDist, vecCurve.z() * curveAmp);
                    float rotAroundPosX = 0.0f;
                    float rotAroundPosY = 0.0f;
                    float rotAroundPosZ = 0.0f;
                    Matrix3f matrix = new Matrix3f();
                    matrix.rotation((Quaternionfc)quaternionY);
                    matrix.rotation((Quaternionfc)quatPitch);
                    matrix.rotation((Quaternionfc)quaternionYCircle);
                    vecNew.mulTranspose((Matrix3fc)matrix);
                    rotAroundPosX = vecNew.x();
                    rotAroundPosY = vecNew.y();
                    rotAroundPosZ = vecNew.z();
                    part.setPosition(piece.posStart.x + (double)rotAroundPosX, piece.posStart.y + (double)rotAroundPosY, piece.posStart.z + (double)rotAroundPosZ);
                }
                ++index;
            }
        }
    }

    public void addPieceToEnd(FunnelPiece piece) {
        this.listFunnel.addLast(piece);
    }

    public double distanceTo(Vector3d vec1, Vector3d p_82555_) {
        double d0 = p_82555_.x - vec1.x;
        double d1 = p_82555_.y - vec1.y;
        double d2 = p_82555_.z - vec1.z;
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    static class FunnelPiece {
        public List<ParticleTexFX> listParticles = new ArrayList<ParticleTexFX>();
        public Vector3d posStart = new Vector3d(0.0, 0.0, 0.0);
        public Vector3d posEnd = new Vector3d(0.0, 20.0, 0.0);
        public float vecDirX = 0.0f;
        public float vecDirZ = 0.0f;
        public boolean needInit = true;
        CubicBezierCurve bezierCurve;

        FunnelPiece() {
        }
    }
}

