/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.tornado;

import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CubicBezierCurve {
    private static final long serialVersionUID = -5219859720055898005L;
    public Vector3f[] P;

    public CubicBezierCurve(Vector3f[] pointsVector) {
        this.P = pointsVector;
    }

    public Vector3f getValue(float t) {
        if ((double)t > 1.0 || (double)t < 0.0) {
            throw new IllegalArgumentException("The value of t is out of range: " + t + " .");
        }
        float one_minus_t = 1.0f - t;
        Vector3f retValue = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f[] terms = new Vector3f[]{this.calcNewVector(one_minus_t * one_minus_t * one_minus_t, this.P[0]), this.calcNewVector(3.0f * one_minus_t * one_minus_t * t, this.P[1]), this.calcNewVector(3.0f * one_minus_t * t * t, this.P[2]), this.calcNewVector(t * t * t, this.P[3])};
        for (int i = 0; i < 4; ++i) {
            retValue.add((Vector3fc)terms[i]);
        }
        return retValue;
    }

    public Vector3f getValueTest(float t) {
        if ((double)t > 1.0 || (double)t < 0.0) {
            throw new IllegalArgumentException("The value of t is out of range: " + t + " .");
        }
        float one_minus_t = 1.0f - t;
        Vector3f retValue = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f[] terms = new Vector3f[6];
        float magicnumber = 5.0f;
        terms[0] = this.calcNewVector(one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t, this.P[0]);
        terms[1] = this.calcNewVector(magicnumber * one_minus_t * one_minus_t * one_minus_t * one_minus_t * t, this.P[1]);
        terms[2] = this.calcNewVector(magicnumber * one_minus_t * one_minus_t * one_minus_t * t * t, this.P[2]);
        terms[3] = this.calcNewVector(magicnumber * one_minus_t * one_minus_t * t * t * t, this.P[3]);
        terms[4] = this.calcNewVector(magicnumber * one_minus_t * t * t * t * t, this.P[4]);
        terms[5] = this.calcNewVector(t * t * t * t * t, this.P[5]);
        for (int i = 0; i < 6; ++i) {
            retValue.add((Vector3fc)terms[i]);
        }
        return retValue;
    }

    public Vector3f getValueTest10(float t) {
        if ((double)t > 1.0 || (double)t < 0.0) {
            throw new IllegalArgumentException("The value of t is out of range: " + t + " .");
        }
        float one_minus_t = 1.0f - t;
        Vector3f retValue = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f[] terms = new Vector3f[10];
        float mn = 9.0f;
        terms[0] = this.calcNewVector(one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t, this.P[0]);
        terms[1] = this.calcNewVector(mn * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * t, this.P[1]);
        terms[2] = this.calcNewVector(mn * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * t * t, this.P[2]);
        terms[3] = this.calcNewVector(mn * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * t * t * t, this.P[3]);
        terms[4] = this.calcNewVector(mn * one_minus_t * one_minus_t * one_minus_t * one_minus_t * one_minus_t * t * t * t * t, this.P[4]);
        terms[5] = this.calcNewVector(mn * one_minus_t * one_minus_t * one_minus_t * one_minus_t * t * t * t * t * t, this.P[5]);
        terms[6] = this.calcNewVector(mn * one_minus_t * one_minus_t * one_minus_t * t * t * t * t * t * t, this.P[6]);
        terms[7] = this.calcNewVector(mn * one_minus_t * one_minus_t * t * t * t * t * t * t * t, this.P[7]);
        terms[8] = this.calcNewVector(mn * one_minus_t * t * t * t * t * t * t * t * t, this.P[8]);
        terms[9] = this.calcNewVector(t * t * t * t * t * t * t * t * t, this.P[9]);
        if (t > 0.8f) {
            boolean bl = false;
        }
        for (int i = 0; i < 10; ++i) {
            retValue.add((Vector3fc)terms[i]);
        }
        return retValue;
    }

    private Vector3f calcNewVector(float scaler, Vector3f base) {
        Vector3f retValue = new Vector3f(base.x(), base.y(), base.z());
        retValue.mul(scaler);
        return retValue;
    }
}

