/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import weather2.WeatherBlocks;
import weather2.config.ConfigSand;
import weather2.config.ConfigSnow;
import weather2.util.CachedNBTTagCompound;
import weather2.util.WeatherUtilBlock;
import weather2.weathersystem.WeatherManager;
import weather2.weathersystem.storm.EnumWeatherObjectType;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.wind.WindManager;

public class WeatherObjectParticleStorm
extends WeatherObject {
    public int age = 0;
    public int maxAge = 400;
    public Random rand = new Random();
    public StormType type;

    public WeatherObjectParticleStorm(WeatherManager parManager) {
        super(parManager);
        this.weatherObjectType = EnumWeatherObjectType.SAND;
    }

    public void initStormSpawn(Vec3 pos) {
        this.pos = pos;
        this.maxAge = 6000;
    }

    public static boolean canSpawnHere(Level world, BlockPos pos, StormType type, boolean forSpawn) {
        Holder biomeIn = world.getBiome(pos);
        if (type == StormType.SANDSTORM) {
            return WeatherObjectParticleStorm.isDesert((Holder<Biome>)biomeIn, forSpawn);
        }
        if (type == StormType.SNOWSTORM) {
            return WeatherObjectParticleStorm.isColdForStorm(world, (Holder<Biome>)biomeIn, forSpawn, pos);
        }
        return false;
    }

    public static boolean isColdForStorm(Level world, Holder<Biome> biome, boolean forSpawn, BlockPos pos) {
        boolean canPrecip = ((Biome)biome.value()).getPrecipitationAt(pos) == Biome.Precipitation.RAIN || ((Biome)biome.value()).getPrecipitationAt(pos) == Biome.Precipitation.SNOW;
        return canPrecip && CoroUtilCompatibility.coldEnoughToSnow((Biome)((Biome)biome.value()), (BlockPos)pos, (Level)world);
    }

    public static boolean isDesert(Holder<Biome> biome, boolean forSpawn) {
        return ((Biome)biome.value()).equals(Biomes.DESERT) || !forSpawn && ((Biome)biome.value()).equals(Biomes.RIVER) || biome.unwrap().left().toString().toLowerCase().contains("desert");
    }

    @Override
    public int getSize() {
        return 250;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.manager.getWorld().isClientSide()) {
            ++this.age;
            if (this.age > this.maxAge) {
                this.remove();
            }
            if ((double)this.getIntensity() > 0.2) {
                this.tickBlockSandBuildup();
            }
            if (this.manager != null && this.manager.getWindManager() != null && !this.manager.getWindManager().isHighWindEventActive()) {
                this.manager.getWindManager().stopLowWindEvent();
                this.manager.getWindManager().startHighWindEvent();
            }
        }
        this.posGround = this.pos;
    }

    public float getIntensity() {
        float age = this.age;
        float maxAge = this.maxAge;
        if (age / maxAge <= 0.5f) {
            return age / (maxAge / 2.0f);
        }
        return 1.0f - (age / (maxAge / 2.0f) - 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
    }

    public Block getBlockForBuildup() {
        if (this.type == StormType.SANDSTORM) {
            return WeatherBlocks.BLOCK_SAND_LAYER.get();
        }
        if (this.type == StormType.SNOWSTORM) {
            return Blocks.SNOW;
        }
        return null;
    }

    public void tickBlockSandBuildup() {
        Level world = this.manager.getWorld();
        WindManager windMan = this.manager.getWindManager();
        float angle = windMan.getWindAngleForClouds();
        int delay = ConfigSand.Sandstorm_Sand_Buildup_TickRate;
        int loop = (int)((float)ConfigSand.Sandstorm_Sand_Buildup_LoopAmountBase * this.getIntensity());
        boolean buildupOutsideArea = ConfigSand.Sandstorm_Sand_Buildup_AllowOutsideDesert;
        int maxBlockStackingAllowed = ConfigSand.Sandstorm_Sand_Block_Max_Height;
        if (this.getType() == StormType.SNOWSTORM) {
            delay = ConfigSnow.Snowstorm_Snow_Buildup_TickRate;
            loop = (int)((float)ConfigSnow.Snowstorm_Snow_Buildup_LoopAmountBase * this.getIntensity());
            buildupOutsideArea = ConfigSnow.Snowstorm_Snow_Buildup_AllowOutsideColdBiomes;
            maxBlockStackingAllowed = ConfigSnow.Snowstorm_Snow_Block_Max_Height;
        }
        if (!world.isClientSide && this.getBlockForBuildup() != null && world.getGameTime() % (long)delay == 0L) {
            for (int i = 0; i < loop; ++i) {
                if (this.rand.nextDouble() >= (double)this.getIntensity()) continue;
                Vec3 vecPos = this.getRandomPosInStorm();
                BlockPos blockPos = WeatherUtilBlock.getPrecipitationHeightSafe(world, CoroUtilBlock.blockPos((double)vecPos.x, (double)0.0, (double)vecPos.z));
                if (!world.hasChunkAt(blockPos) || !buildupOutsideArea && !WeatherObjectParticleStorm.canSpawnHere(world, blockPos, this.getType(), false)) continue;
                WeatherUtilBlock.fillAgainstWallSmoothly(world, new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), angle, 15.0f, 2.0f, this.getBlockForBuildup(), maxBlockStackingAllowed);
            }
        }
    }

    public Vec3 getRandomPosInStorm() {
        Random rand = new Random();
        int x = (int)Math.floor(this.posGround.x + (double)rand.nextInt(this.getSize()) - (double)rand.nextInt(this.getSize()));
        int z = (int)Math.floor(this.posGround.z + (double)rand.nextInt(this.getSize()) - (double)rand.nextInt(this.getSize()));
        int y = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), new BlockPos(x, 128, z)).getY();
        Vec3 vec = new Vec3((double)x, (double)y, (double)z);
        return vec;
    }

    @Override
    public int getUpdateRateForNetwork() {
        return 1;
    }

    @Override
    public void nbtSyncForClient() {
        super.nbtSyncForClient();
        CachedNBTTagCompound data = this.getNbtCache();
        data.putInt("age", this.age);
        data.putInt("maxAge", this.maxAge);
        data.putString("type", this.type.key);
        data.putString("test", "WHAT");
    }

    @Override
    public void nbtSyncFromServer() {
        super.nbtSyncFromServer();
        CachedNBTTagCompound parNBT = this.getNbtCache();
        this.age = parNBT.getInt("age");
        this.maxAge = parNBT.getInt("maxAge");
        if (parNBT.contains("type")) {
            this.type = StormType.valueOf(parNBT.getString("type").toUpperCase());
        }
    }

    @Override
    public void read() {
        super.read();
        this.nbtSyncFromServer();
        CachedNBTTagCompound var1 = this.getNbtCache();
        this.motion = new Vec3(var1.getDouble("vecX"), var1.getDouble("vecY"), var1.getDouble("vecZ"));
    }

    @Override
    public void write() {
        super.write();
        this.nbtSyncForClient();
        CachedNBTTagCompound nbt = this.getNbtCache();
        nbt.putDouble("vecX", this.motion.x);
        nbt.putDouble("vecY", this.motion.y);
        nbt.putDouble("vecZ", this.motion.z);
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void cleanupClient() {
        super.cleanupClient();
    }

    public StormType getType() {
        return this.type;
    }

    public void setType(StormType type) {
        this.type = type;
    }

    public static enum StormType {
        SANDSTORM("SANDSTORM"),
        SNOWSTORM("SNOWSTORM");

        private final String key;
        public static final StormType[] VALUES;

        private StormType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        static {
            VALUES = StormType.values();
        }
    }
}

