/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;
import weather2.util.CachedNBTTagCompound;
import weather2.weathersystem.WeatherManager;
import weather2.weathersystem.storm.EnumWeatherObjectType;

public class WeatherObject {
    public static long lastUsedStormID = 0L;
    public long ID;
    public boolean isDead = false;
    public int ticksSinceNoNearPlayer = 0;
    public WeatherManager manager;
    public Vec3 pos = Vec3.ZERO;
    public Vec3 posGround = Vec3.ZERO;
    public Vec3 motion = Vec3.ZERO;
    public int size = 50;
    public int maxSize = 0;
    public EnumWeatherObjectType weatherObjectType = EnumWeatherObjectType.CLOUD;
    private CachedNBTTagCompound nbtCache;

    public WeatherObject(WeatherManager parManager) {
        this.manager = parManager;
        this.nbtCache = new CachedNBTTagCompound();
    }

    public void initFirstTime() {
        this.ID = lastUsedStormID++;
    }

    public void tick() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickRender(float partialTick) {
    }

    public void reset() {
        this.remove();
    }

    public void remove() {
        this.isDead = true;
        if (EffectiveSide.get().equals((Object)LogicalSide.CLIENT)) {
            this.cleanupClient();
        }
        this.cleanup();
    }

    public void cleanup() {
        this.manager = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void cleanupClient() {
    }

    public int getUpdateRateForNetwork() {
        return 40;
    }

    public void read() {
    }

    public void write() {
    }

    public void nbtSyncFromServer() {
        CachedNBTTagCompound parNBT = this.getNbtCache();
        this.ID = parNBT.getLong("ID");
        this.pos = new Vec3(parNBT.getDouble("posX"), parNBT.getDouble("posY"), parNBT.getDouble("posZ"));
        this.motion = new Vec3(parNBT.getDouble("vecX"), parNBT.getDouble("vecY"), parNBT.getDouble("vecZ"));
        this.size = parNBT.getInt("size");
        this.maxSize = parNBT.getInt("maxSize");
        this.weatherObjectType = EnumWeatherObjectType.get(parNBT.getInt("weatherObjectType"));
    }

    public void nbtSyncForClient() {
        CachedNBTTagCompound nbt = this.getNbtCache();
        nbt.putDouble("posX", this.pos.x);
        nbt.putDouble("posY", this.pos.y);
        nbt.putDouble("posZ", this.pos.z);
        nbt.putDouble("vecX", this.motion.x);
        nbt.putDouble("vecY", this.motion.y);
        nbt.putDouble("vecZ", this.motion.z);
        nbt.putLong("ID", this.ID);
        nbt.getNewNBT().putLong("ID", this.ID);
        nbt.putInt("size", this.size);
        nbt.putInt("maxSize", this.maxSize);
        nbt.putInt("weatherObjectType", this.weatherObjectType.ordinal());
    }

    public CachedNBTTagCompound getNbtCache() {
        return this.nbtCache;
    }

    public void setNbtCache(CachedNBTTagCompound nbtCache) {
        this.nbtCache = nbtCache;
    }

    public int getSize() {
        return this.size;
    }
}

