/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import com.corosus.coroutil.util.CoroUtilEntOrParticle;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorFog;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.particle.entity.ParticleCube;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;
import weather2.EntityRegistry;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.config.ConfigParticle;
import weather2.config.ConfigStorm;
import weather2.config.ConfigTornado;
import weather2.config.WeatherUtilConfig;
import weather2.util.CachedNBTTagCompound;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.WeatherManager;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.LightningBoltWeatherNew;
import weather2.weathersystem.storm.TornadoHelper;
import weather2.weathersystem.storm.WeatherEntityConfig;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherTypes;
import weather2.weathersystem.tornado.ActiveTornadoConfig;
import weather2.weathersystem.tornado.simple.Layer;
import weather2.weathersystem.tornado.simple.TornadoFunnelSimple;

public class StormObject
extends WeatherObject {
    public String spawnerUUID = "";
    @OnlyIn(value=Dist.CLIENT)
    public HashMap<Integer, EntityRotFX> lookupParticlesCloud;
    @OnlyIn(value=Dist.CLIENT)
    public HashMap<Integer, EntityRotFX> lookupParticlesCloudLower;
    @OnlyIn(value=Dist.CLIENT)
    public HashMap<Integer, EntityRotFX> lookupParticlesFunnel;
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRotFX> listParticlesCloud;
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRotFX> listParticlesGround;
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRotFX> listParticlesFunnel;
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRotFX> listParticlesDebris;
    @OnlyIn(value=Dist.CLIENT)
    public ParticleBehaviorFog particleBehaviorFog;
    public int sizeMaxFunnelParticles = 600;
    public static int static_YPos_layer0 = ConfigMisc.Cloud_Layer0_Height;
    public static int static_YPos_layer1 = ConfigMisc.Cloud_Layer1_Height;
    public static int static_YPos_layer2 = ConfigMisc.Cloud_Layer2_Height;
    public static List<Integer> layers = new ArrayList<Integer>(Arrays.asList(static_YPos_layer0, static_YPos_layer1, static_YPos_layer2));
    public int layer = 0;
    public boolean angleIsOverridden = false;
    public float angleMovementTornadoOverride = 0.0f;
    public float tempAngleFormingTornado = 0.0f;
    public boolean isGrowing = true;
    public int levelWater = 0;
    public float levelWindMomentum = 0.0f;
    public float levelTemperature = 0.0f;
    public int levelWaterStartRaining = 100;
    public int levelStormIntensityMax = 0;
    public int levelCurIntensityStage = 0;
    public float levelCurStagesIntensity = 0.0f;
    public boolean hasStormPeaked = false;
    public int maxIntensityStage = STATE_STAGE5;
    public int stormType = TYPE_LAND;
    public static int TYPE_LAND = 0;
    public static int TYPE_WATER = 1;
    public static int STATE_NORMAL = 0;
    public static int STATE_THUNDER = 1;
    public static int STATE_HIGHWIND = 2;
    public static int STATE_HAIL = 3;
    public static int STATE_FORMING = 4;
    public static int STATE_STAGE1 = 5;
    public static int STATE_STAGE2 = 6;
    public static int STATE_STAGE3 = 7;
    public static int STATE_STAGE4 = 8;
    public static int STATE_STAGE5 = 9;
    public static float levelStormIntensityFormingStartVal = STATE_FORMING;
    public double spinSpeed = 0.02;
    public boolean attrib_precipitation = false;
    public boolean attrib_waterSpout = false;
    public float scale = 1.0f;
    public float strength = 100.0f;
    public int maxHeight = 60;
    public int currentTopYBlock = -1;
    public TornadoHelper tornadoHelper = new TornadoHelper(this);
    private TornadoFunnelSimple tornadoFunnelSimple;
    public int updateLCG = new Random().nextInt();
    public float formingStrength = 0.0f;
    public Vec3 posBaseFormationPos;
    public boolean naturallySpawned;
    public boolean weatherMachineControlled;
    public boolean canSnowFromCloudTemperature;
    public boolean alwaysProgresses;
    public long ticksSinceLastPacketReceived;
    public boolean canBeDeadly;
    public boolean cloudlessStorm;
    public float cachedAngleAvoidance;
    public boolean isFirenado;
    public List<LivingEntity> listEntitiesUnderClouds;
    private boolean playerControlled;
    private int playerControlledTimeLeft;
    private boolean baby;
    private boolean pet;
    private boolean petGrabsItems;
    private boolean sharknado;
    private boolean configNeedsSync;
    private int age;
    private int ageSinceTornadoTouchdown;
    private boolean isBeingDeflectedCached;
    private boolean debugCloudTemperature;

    public StormObject(WeatherManager parManager) {
        super(parManager);
        this.posBaseFormationPos = new Vec3(this.pos.x, this.pos.y, this.pos.z);
        this.naturallySpawned = true;
        this.weatherMachineControlled = false;
        this.canSnowFromCloudTemperature = false;
        this.alwaysProgresses = false;
        this.ticksSinceLastPacketReceived = 0L;
        this.canBeDeadly = true;
        this.cloudlessStorm = false;
        this.cachedAngleAvoidance = 0.0f;
        this.isFirenado = false;
        this.listEntitiesUnderClouds = new ArrayList<LivingEntity>();
        this.playerControlled = false;
        this.playerControlledTimeLeft = 20;
        this.baby = false;
        this.pet = false;
        this.petGrabsItems = false;
        this.sharknado = false;
        this.configNeedsSync = true;
        this.isBeingDeflectedCached = true;
        this.debugCloudTemperature = false;
        this.pos = new Vec3(0.0, (double)static_YPos_layer0, 0.0);
        this.maxSize = ConfigStorm.Storm_MaxRadius;
        if (parManager.getWorld().isClientSide()) {
            this.listParticlesCloud = new ArrayList<EntityRotFX>();
            this.listParticlesFunnel = new ArrayList<EntityRotFX>();
            this.listParticlesDebris = new ArrayList<EntityRotFX>();
            this.listParticlesGround = new ArrayList<EntityRotFX>();
            this.lookupParticlesCloud = new HashMap();
            this.lookupParticlesCloudLower = new HashMap();
            this.lookupParticlesFunnel = new HashMap();
        }
    }

    @Override
    public void initFirstTime() {
        super.initFirstTime();
        Biome bgb = (Biome)this.manager.getWorld().getBiome(WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), new BlockPos(Mth.floor((double)this.pos.x), 0, Mth.floor((double)this.pos.z)))).value();
        float temp = 1.0f;
        if (bgb != null) {
            temp = CoroUtilCompatibility.getAdjustedTemperature((Level)this.manager.getWorld(), (Biome)bgb, (BlockPos)new BlockPos(Mth.floor((double)this.pos.x), Mth.floor((double)this.pos.y), Mth.floor((double)this.pos.z)));
        }
        if (this.naturallySpawned) {
            this.levelTemperature = StormObject.getTemperatureMCToWeatherSys(temp);
            CULog.dbg((String)("init levelTemperature: " + this.levelTemperature));
        }
        this.levelWindMomentum = 0.0f;
    }

    public boolean isCloudlessStorm() {
        return this.cloudlessStorm;
    }

    public void setCloudlessStorm(boolean cloudlessStorm) {
        this.cloudlessStorm = cloudlessStorm;
    }

    public boolean isPrecipitating() {
        return this.attrib_precipitation;
    }

    public void setPrecipitating(boolean parVal) {
        this.attrib_precipitation = parVal;
    }

    public boolean isRealStorm() {
        return this.levelCurIntensityStage > STATE_NORMAL;
    }

    public boolean isTornadoFormingOrGreater() {
        return this.stormType == TYPE_LAND && this.levelCurIntensityStage >= STATE_FORMING || this.isPet();
    }

    public boolean isCycloneFormingOrGreater() {
        return this.stormType == TYPE_WATER && this.levelCurIntensityStage >= STATE_FORMING;
    }

    public boolean isSpinning() {
        return this.levelCurIntensityStage >= STATE_HIGHWIND;
    }

    public boolean isTropicalCyclone() {
        return this.levelCurIntensityStage >= STATE_STAGE1;
    }

    public boolean isHurricane() {
        return this.levelCurIntensityStage >= STATE_STAGE5;
    }

    @Override
    public void read() {
        super.read();
        this.nbtSyncFromServer();
        CachedNBTTagCompound var1 = this.getNbtCache();
        this.angleIsOverridden = var1.getBoolean("angleIsOverridden");
        this.angleMovementTornadoOverride = var1.getFloat("angleMovementTornadoOverride");
        this.spawnerUUID = var1.getString("spawnerUUID");
    }

    @Override
    public void write() {
        super.write();
        this.nbtSyncForClient();
        CachedNBTTagCompound nbt = this.getNbtCache();
        nbt.putBoolean("angleIsOverridden", this.angleIsOverridden);
        nbt.putFloat("angleMovementTornadoOverride", this.angleMovementTornadoOverride);
        nbt.putString("spawnerUUID", this.spawnerUUID);
    }

    @Override
    public void nbtSyncFromServer() {
        CachedNBTTagCompound parNBT = this.getNbtCache();
        boolean testNetworkData = false;
        if (testNetworkData) {
            System.out.println("Received payload from server; length=" + parNBT.getNewNBT().getAllKeys().size());
            Iterator iterator = parNBT.getNewNBT().getAllKeys().iterator();
            String keys = "";
            while (iterator.hasNext()) {
                keys = keys.concat((String)iterator.next() + "; ");
            }
            System.out.println("Received    " + keys);
        }
        super.nbtSyncFromServer();
        this.attrib_precipitation = parNBT.getBoolean("attrib_rain");
        this.attrib_waterSpout = parNBT.getBoolean("attrib_waterSpout");
        this.currentTopYBlock = parNBT.getInt("currentTopYBlock");
        this.levelTemperature = parNBT.getFloat("levelTemperature");
        this.levelWater = parNBT.getInt("levelWater");
        this.layer = parNBT.getInt("layer");
        this.levelCurIntensityStage = parNBT.getInt("levelCurIntensityStage");
        this.levelStormIntensityMax = parNBT.getInt("levelStormIntensityMax");
        this.levelCurStagesIntensity = parNBT.getFloat("levelCurStagesIntensity");
        this.stormType = parNBT.getInt("stormType");
        this.hasStormPeaked = parNBT.getBoolean("hasStormPeaked");
        this.isDead = parNBT.getBoolean("isDead");
        this.cloudlessStorm = parNBT.getBoolean("cloudlessStorm");
        this.isFirenado = parNBT.getBoolean("isFirenado");
        this.ticksSinceLastPacketReceived = 0L;
        this.weatherMachineControlled = parNBT.getBoolean("weatherMachineControlled");
        String prefix = "tornadoFunnelData_layer_";
        if (parNBT.contains(prefix + "count") && this.tornadoFunnelSimple != null) {
            int count = parNBT.getInt(prefix + "count");
            for (int i = 0; i < this.tornadoFunnelSimple.listLayers.size(); ++i) {
                Layer layer = this.tornadoFunnelSimple.listLayers.get(i);
                Vec3 newPos = new Vec3(parNBT.getDouble(prefix + i + "_posX"), parNBT.getDouble(prefix + i + "_posY"), parNBT.getDouble(prefix + i + "_posZ"));
                layer.setPos(newPos);
            }
        }
        this.playerControlled = parNBT.getBoolean("playerControlled");
        this.spawnerUUID = parNBT.getString("spawnerUUID");
        if (this.tornadoFunnelSimple != null && parNBT.contains("config")) {
            this.tornadoFunnelSimple.setConfig(ActiveTornadoConfig.deserialize(parNBT.get("config")));
        }
        this.baby = parNBT.getBoolean("baby");
        this.pet = parNBT.getBoolean("pet");
        this.petGrabsItems = parNBT.getBoolean("petGrabsItems");
        this.sharknado = parNBT.getBoolean("sharknado");
        if (this.posBaseFormationPos == Vec3.ZERO) {
            this.posBaseFormationPos = new Vec3(parNBT.getDouble("posBaseFormationPosX"), parNBT.getDouble("posBaseFormationPosX"), parNBT.getDouble("posBaseFormationPosX"));
        }
        this.isBeingDeflectedCached = parNBT.getBoolean("isBeingDeflectedCached");
    }

    @Override
    public void nbtSyncForClient() {
        super.nbtSyncForClient();
        CachedNBTTagCompound data = this.getNbtCache();
        if (this.attrib_precipitation) {
            // empty if block
        }
        data.putBoolean("attrib_rain", this.attrib_precipitation);
        data.putBoolean("attrib_waterSpout", this.attrib_waterSpout);
        data.putInt("currentTopYBlock", this.currentTopYBlock);
        data.putFloat("levelTemperature", this.levelTemperature);
        data.putInt("levelWater", this.levelWater);
        data.putInt("layer", this.layer);
        data.putInt("levelCurIntensityStage", this.levelCurIntensityStage);
        data.putFloat("levelCurStagesIntensity", this.levelCurStagesIntensity);
        data.putFloat("levelStormIntensityMax", this.levelStormIntensityMax);
        data.putInt("stormType", this.stormType);
        data.putBoolean("hasStormPeaked", this.hasStormPeaked);
        data.putBoolean("isDead", this.isDead);
        data.putBoolean("cloudlessStorm", this.cloudlessStorm);
        data.putBoolean("isFirenado", this.isFirenado);
        data.putBoolean("weatherMachineControlled", this.weatherMachineControlled);
        if (this.manager != null && this.tornadoFunnelSimple != null && (this.manager.getWorld().getGameTime() % 100L == 0L || this.configNeedsSync)) {
            String prefix = "tornadoFunnelData_layer_";
            data.putInt(prefix + "count", this.tornadoFunnelSimple.listLayers.size());
            for (int i = 0; i < this.tornadoFunnelSimple.listLayers.size(); ++i) {
                Vec3 layerPos = this.tornadoFunnelSimple.listLayers.get(i).getPos();
                data.putDouble(prefix + i + "_posX", layerPos.x);
                data.putDouble(prefix + i + "_posY", layerPos.y);
                data.putDouble(prefix + i + "_posZ", layerPos.z);
            }
        }
        data.putBoolean("playerControlled", this.playerControlled);
        data.putString("spawnerUUID", this.spawnerUUID);
        if (this.configNeedsSync && this.tornadoFunnelSimple != null) {
            data.put("config", this.tornadoFunnelSimple.getConfig().serialize());
            this.configNeedsSync = false;
        }
        data.putBoolean("baby", this.baby);
        data.putBoolean("pet", this.pet);
        data.putBoolean("petGrabsItems", this.petGrabsItems);
        data.putBoolean("sharknado", this.sharknado);
        if (this.manager != null && this.manager.getWorld().getGameTime() % 600L == 0L) {
            data.setUpdateForced(true);
        } else {
            data.setUpdateForced(false);
        }
        data.putDouble("posBaseFormationPosX", this.posBaseFormationPos.x);
        data.putDouble("posBaseFormationPosY", this.posBaseFormationPos.y);
        data.putDouble("posBaseFormationPosZ", this.posBaseFormationPos.z);
        data.putBoolean("isBeingDeflectedCached", this.isBeingDeflectedCached);
    }

    public CompoundTag nbtForIMC() {
        this.nbtSyncForClient();
        return this.getNbtCache().getNewNBT();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickRender(float partialTick) {
        super.tickRender(partialTick);
        if (!WeatherUtil.isPaused()) {
            Vec3 tryPos;
            int i;
            EntityRotFX ent;
            Map.Entry<Integer, EntityRotFX> entry;
            int count = 9;
            Iterator<Map.Entry<Integer, EntityRotFX>> it = this.lookupParticlesCloud.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                ent = entry.getValue();
                if (!ent.isAlive()) {
                    it.remove();
                    continue;
                }
                i = entry.getKey();
                tryPos = null;
                double spawnRad = 120.0;
                double speed = 2.0 / spawnRad;
                if (this.isSpinning()) {
                    speed = 50.0 / spawnRad;
                }
                ent.rotationSpeedAroundCenter = (float)speed;
                if (i == 0) {
                    tryPos = new Vec3(this.pos.x, (double)layers.get(this.layer).intValue(), this.pos.z);
                    ent.rotationYaw = ent.rotationAroundCenter;
                } else {
                    double rad = Math.toRadians(ent.rotationAroundCenter - ent.rotationSpeedAroundCenter + ent.rotationSpeedAroundCenter * partialTick);
                    double x = -Math.sin(rad) * spawnRad;
                    double z = Math.cos(rad) * spawnRad;
                    tryPos = new Vec3(this.pos.x + x, (double)layers.get(this.layer).intValue(), this.pos.z + z);
                    double var16 = this.pos.x - ent.getPosX();
                    double var18 = this.pos.z - ent.getPosZ();
                    ent.rotationYaw = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                }
                ent.setPosition(tryPos.x, tryPos.y, tryPos.z);
            }
            count = 32;
            it = this.lookupParticlesCloudLower.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                ent = entry.getValue();
                if (!ent.isAlive()) {
                    it.remove();
                    continue;
                }
                i = entry.getKey();
                tryPos = null;
                ent.setScale(120.00001f);
                double countPerLayer = 16.0;
                double rotPos = i % 16;
                int layerRot = i / 16;
                double spawnRad = 80.0;
                if (layerRot == 1) {
                    spawnRad = 60.0;
                    ent.setScale(90.0f);
                }
                double speed = 50.0 / (spawnRad * 2.0);
                ent.rotationSpeedAroundCenter = (float)speed;
                double rad = Math.toRadians(ent.rotationAroundCenter - ent.rotationSpeedAroundCenter + ent.rotationSpeedAroundCenter * partialTick);
                double x = -Math.sin(rad) * spawnRad;
                double z = Math.cos(rad) * spawnRad;
                tryPos = new Vec3(this.pos.x + x, (double)(layers.get(this.layer) - 20), this.pos.z + z);
                ent.setPosition(tryPos.x, tryPos.y, tryPos.z);
                double var16 = this.pos.x - ent.getPosX();
                double var18 = this.pos.z - ent.getPosZ();
                ent.rotationYaw = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                ent.rotationPitch = -20.0f;
            }
        }
    }

    public void setupTornado() {
        ActiveTornadoConfig activeTornadoConfig = this.isPet() ? new ActiveTornadoConfig().setHeight(1.7f).setRadiusOfBase(0.5f).setSpinSpeed(18.0f).setRadiusIncreasePerLayer(0.02f).setEntityPullDistXZ(2.0f).setEntityPullDistXZForY(2.0f) : (this.isBaby() ? new ActiveTornadoConfig().setHeight(20.0f).setRadiusOfBase(5.0f).setSpinSpeed(18.0f).setRadiusIncreasePerLayer(0.2f).setEntityPullDistXZ(20.0f).setEntityPullDistXZForY(5.0f) : new ActiveTornadoConfig().setHeight(150.0f).setRadiusOfBase(10.0f).setSpinSpeed(18.0f).setRadiusIncreasePerLayer(0.2f).setEntityPullDistXZ(120.0f).setEntityPullDistXZForY(90.0f));
        this.tornadoFunnelSimple = new TornadoFunnelSimple(activeTornadoConfig, this);
    }

    @Override
    public void tick() {
        super.tick();
        ++this.age;
        if (this.levelCurIntensityStage >= STATE_STAGE1) {
            ++this.ageSinceTornadoTouchdown;
        }
        this.posGround = !this.playerControlled ? new Vec3(this.pos.x, (double)this.currentTopYBlock, this.pos.z) : new Vec3(this.pos.x, this.pos.y, this.pos.z);
        LogicalSide side = EffectiveSide.get();
        if (side == LogicalSide.CLIENT) {
            if (!WeatherUtil.isPaused()) {
                if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                    this.setAndUpdateTornado();
                    this.tornadoFunnelSimple.tick();
                } else if (this.tornadoFunnelSimple != null && this.tornadoFunnelSimple.listLayers.size() > 0) {
                    this.tornadoFunnelSimple.fadeOut();
                }
                ++this.ticksSinceLastPacketReceived;
                this.tickClient();
                if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                    this.setAndUpdateTornado();
                    if (!this.isBeingDeflectedCached()) {
                        this.tornadoHelper.tick(this.manager.getWorld());
                    }
                    this.tornadoFunnelSimple.tickClient();
                }
                if (this.levelCurIntensityStage >= STATE_HIGHWIND && this.manager.getWorld().isClientSide()) {
                    this.tornadoHelper.soundUpdates(true, this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater());
                }
                this.tickMovementClient();
                if (this.layer == 0) {
                    this.posBaseFormationPos = this.calculateBaseFormationPos();
                }
            }
        } else {
            if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                this.setAndUpdateTornado();
                this.tornadoFunnelSimple.tick();
            }
            if (this.isCloudlessStorm() && ConfigMisc.overcastMode && this.manager.getWorld().isRaining()) {
                this.setCloudlessStorm(false);
            }
            if ((this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) && !this.isBeingDeflectedCached()) {
                this.tornadoHelper.tick(this.manager.getWorld());
            }
            if (this.levelCurIntensityStage >= STATE_HIGHWIND && this.manager.getWorld().isClientSide()) {
                this.tornadoHelper.soundUpdates(true, this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater());
            }
            this.tickMovement();
            if (this.layer == 0) {
                if (!this.isCloudlessStorm()) {
                    this.tickWeatherEvents();
                    this.tickProgression();
                }
            } else {
                this.size = this.maxSize;
            }
            if (this.layer == 0) {
                this.posBaseFormationPos = this.calculateBaseFormationPos();
            }
        }
    }

    public Vec3 calculateBaseFormationPos() {
        Vec3 calculatedPos = new Vec3(this.pos.x, this.pos.y, this.pos.z);
        if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
            if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal + 1.0f) {
                this.formingStrength = 1.0f;
                calculatedPos = new Vec3(calculatedPos.x, this.posGround.y, calculatedPos.z);
            } else {
                float val;
                float intensityAdj = Math.min(1.0f, this.levelCurStagesIntensity * 2.0f);
                this.formingStrength = val = (float)this.levelCurIntensityStage + intensityAdj - levelStormIntensityFormingStartVal;
                double yDiff = this.pos.y - this.posGround.y;
                calculatedPos = new Vec3(calculatedPos.x, this.pos.y - yDiff * (double)this.formingStrength, calculatedPos.z);
            }
        } else if (this.levelCurIntensityStage == STATE_HIGHWIND) {
            this.formingStrength = 1.0f;
            calculatedPos = new Vec3(calculatedPos.x, this.posGround.y, calculatedPos.z);
        } else {
            this.formingStrength = 0.0f;
            calculatedPos = new Vec3(calculatedPos.x, this.pos.y, calculatedPos.z);
        }
        return calculatedPos;
    }

    public void tickMovement() {
        boolean testing;
        Player entP;
        double distToTarget = 1.0;
        if (this.playerControlled && (entP = this.getPlayer()) != null) {
            if (!this.isPet()) {
                this.pos = new Vec3(entP.position().x, entP.position().y, entP.position().z);
                this.posGround = new Vec3(entP.position().x, entP.position().y, entP.position().z);
            } else {
                distToTarget = entP.position().distanceTo(this.posGround);
                if (distToTarget > 5.0) {
                    this.aimStormAtClosestOrProvidedPlayer(entP);
                }
            }
        }
        float angle = this.getAdjustedAngle();
        Random rand = new Random();
        if (this.angleIsOverridden) {
            angle = this.angleMovementTornadoOverride;
        }
        if (this.levelCurIntensityStage == STATE_FORMING) {
            angle = this.tempAngleFormingTornado;
            angle += (rand.nextFloat() - rand.nextFloat()) * 30.0f;
        }
        double scanDist = 50.0;
        double scanX = this.pos.x + -Math.sin(Math.toRadians(angle += (rand.nextFloat() - rand.nextFloat()) * 0.15f)) * scanDist;
        double scanZ = this.pos.z + Math.cos(Math.toRadians(angle)) * scanDist;
        int height = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), CoroUtilBlock.blockPos((double)scanX, (double)0.0, (double)scanZ)).getY();
        if (this.pos.y < (double)height) {
            float angleAdj = 45.0f;
            if (this.ID % 2L == 0L) {
                angleAdj = -45.0f;
            }
            angle += angleAdj;
        }
        this.tempAngleFormingTornado = angle;
        double vecX = -Math.sin(Math.toRadians(angle));
        double vecZ = Math.cos(Math.toRadians(angle));
        float cloudSpeedAmp = 0.2f;
        boolean love_tropics_tweaks = Weather.isLoveTropicsInstalled();
        if (love_tropics_tweaks) {
            cloudSpeedAmp = 3.0f;
        }
        float finalSpeed = this.getAdjustedSpeed() * cloudSpeedAmp;
        if (this.levelCurIntensityStage == STATE_FORMING) {
            finalSpeed = 0.2f;
        } else if (this.levelCurIntensityStage >= STATE_THUNDER) {
            finalSpeed = 0.15f;
        }
        if (!love_tropics_tweaks && (float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
            finalSpeed /= (float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f;
        }
        if (finalSpeed < 0.03f) {
            finalSpeed = 0.03f;
        }
        if (!love_tropics_tweaks && finalSpeed > 0.3f) {
            finalSpeed = 0.3f;
        }
        if (this.levelCurIntensityStage == STATE_FORMING) {
            finalSpeed = 0.3f;
        }
        if (love_tropics_tweaks) {
            finalSpeed = 0.1f;
        }
        if (this.playerControlled) {
            finalSpeed = 0.5f;
            Player player = this.getPlayer();
            if (player != null && this.posGround.distanceTo(player.position()) > 30.0) {
                this.pos = new Vec3(player.position().x, player.position().y, player.position().z);
            }
        }
        if (this.isPet()) {
            finalSpeed = 0.05f;
            if (distToTarget > 5.5) {
                finalSpeed = 0.5f;
            }
        }
        if (this.isSharknado()) {
            finalSpeed = 0.1f;
        }
        if (this.manager.getWorld().getGameTime() % 100L != 0L || this.levelCurIntensityStage >= STATE_FORMING) {
            // empty if block
        }
        if (this.isBeingDeflectedCached()) {
            finalSpeed *= 5.0f;
        }
        if (testing = false) {
            finalSpeed = 0.5f;
        }
        if (!this.weatherMachineControlled) {
            this.motion = new Vec3(vecX * (double)finalSpeed, 0.0, vecZ * (double)finalSpeed);
            double max = 0.2;
            this.pos = this.pos.add(this.motion);
        }
        if (this.levelCurIntensityStage >= STATE_FORMING) {
            Optional<BlockPos> optional = ((WeatherManagerServer)this.manager).findWeatherDeflector(CoroUtilBlock.blockPos((Vec3)this.posGround), 128);
            if (optional.isPresent()) {
                this.isBeingDeflectedCached = true;
                this.aimAwayFromCoords(new Vec3((double)optional.get().getX(), (double)optional.get().getY(), (double)optional.get().getZ()));
                ((ServerLevel)this.manager.getWorld()).sendParticles((ParticleOptions)DustParticleOptions.REDSTONE, (double)optional.get().getX() + 0.5, (double)optional.get().getY() + 0.5, (double)optional.get().getZ() + 0.5, 1, 0.3, 0.0, 0.3, 1.0);
            } else {
                this.isBeingDeflectedCached = false;
            }
        } else {
            this.isBeingDeflectedCached = false;
        }
    }

    public void tickMovementClient() {
        if (!this.weatherMachineControlled) {
            this.pos = this.pos.add(this.motion);
        }
    }

    public void tickWeatherEvents() {
        int z;
        int x;
        Random rand = new Random();
        Level world = this.manager.getWorld();
        this.currentTopYBlock = this.calculateTopYBlock();
        if (this.levelCurIntensityStage >= STATE_THUNDER && !this.isBaby() && !this.isPet() && rand.nextInt(Math.max(1, ConfigStorm.Storm_LightningStrikeBaseValueOddsTo1 - this.levelCurIntensityStage * 10)) == 0 && world.isLoaded(new BlockPos(x = (int)Math.floor(this.pos.x + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)), 0, z = (int)Math.floor(this.pos.z + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size))))) {
            Optional optional;
            int y = world.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
            if (world instanceof ServerLevel && (optional = ((ServerLevel)world).findLightningRod(new BlockPos(x, y, z))).isPresent()) {
                x = ((BlockPos)optional.get()).getX();
                y = ((BlockPos)optional.get()).getY();
                z = ((BlockPos)optional.get()).getZ();
            }
            LightningBoltWeatherNew ent = new LightningBoltWeatherNew((EntityType<? extends LightningBoltWeatherNew>)((EntityType)EntityRegistry.LIGHTNING_BOLT.get()), world);
            ent.setPos((double)x + 0.5, y, (double)z + 0.5);
            this.addWeatherEffectLightning(ent, false);
        }
        if (this.isPrecipitating() && this.levelCurIntensityStage == STATE_HAIL && this.stormType == TYPE_LAND) {
            for (int i = 0; i < Math.max(1, ConfigStorm.Storm_HailPerTick * (this.size / this.maxSize)); ++i) {
                int z2;
                int x2 = (int)Math.floor(this.pos.x + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size));
                if (world.isLoaded(new BlockPos(x2, static_YPos_layer0, z2 = (int)Math.floor(this.pos.z + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)))) && world.getNearestPlayer((double)x2, 50.0, (double)z2, 80.0, false) == null) continue;
            }
        }
        this.trackAndExtinguishEntities();
    }

    public void trackAndExtinguishEntities() {
        if (ConfigStorm.Storm_Rain_TrackAndExtinguishEntitiesRate <= 0) {
            return;
        }
        if (this.isPrecipitating()) {
            if ((this.manager.getWorld().getGameTime() + this.ID * 20L) % (long)ConfigStorm.Storm_Rain_TrackAndExtinguishEntitiesRate == 0L) {
                this.listEntitiesUnderClouds.clear();
                BlockPos posBP = CoroUtilBlock.blockPos((double)this.posGround.x, (double)this.posGround.y, (double)this.posGround.z);
                List listEnts = this.manager.getWorld().getEntitiesOfClass(LivingEntity.class, new AABB(posBP).inflate((double)this.size));
                for (LivingEntity ent : listEnts) {
                    if (!ent.level().canSeeSky(ent.blockPosition())) continue;
                    this.listEntitiesUnderClouds.add(ent);
                }
            }
            for (LivingEntity ent : this.listEntitiesUnderClouds) {
                if (this.isFirenado) continue;
                ent.clearFire();
            }
        }
    }

    public void tickProgression() {
        Level world = this.manager.getWorld();
        if (world.getGameTime() % 3L == 0L && this.isGrowing && this.size < this.maxSize) {
            ++this.size;
        }
        float tempAdjustRate = (float)ConfigStorm.Storm_TemperatureAdjustRate;
        int levelWaterBuildRate = ConfigStorm.Storm_Rain_WaterBuildUpRate;
        int levelWaterSpendRate = ConfigStorm.Storm_Rain_WaterSpendRate;
        int randomChanceOfWaterBuildFromWater = ConfigStorm.Storm_Rain_WaterBuildUpOddsTo1FromSource;
        int randomChanceOfWaterBuildFromNothing = ConfigStorm.Storm_Rain_WaterBuildUpOddsTo1FromNothing;
        int randomChanceOfWaterBuildFromOvercastRaining = ConfigStorm.Storm_Rain_WaterBuildUpOddsTo1FromOvercastRaining;
        randomChanceOfWaterBuildFromOvercastRaining = 10;
        boolean isInOcean = false;
        boolean isOverWater = false;
        boolean tryFormStorm = false;
        float levelStormIntensityRate = 0.02f;
        float minIntensityToProgress = 0.6f;
        if (world.getGameTime() % (long)ConfigStorm.Storm_AllTypes_TickRateDelay == 0L) {
            BlockState state;
            BlockPos tryPos;
            Holder bgb;
            Player player = this.getPlayer();
            CompoundTag playerNBT = null;
            playerNBT = player != null ? player.getPersistentData() : new CompoundTag();
            long lastStormDeadlyTime = playerNBT.getLong("lastStormDeadlyTime");
            if (lastStormDeadlyTime == 0L) {
                lastStormDeadlyTime = world.getGameTime();
            }
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)world.dimension());
            if (wm.lastStormFormed == 0L) {
                wm.lastStormFormed = world.getGameTime();
            }
            if ((bgb = world.getBiome(WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(Mth.floor((double)this.pos.x), 0, Mth.floor((double)this.pos.z))))).value() != null) {
                isInOcean = bgb.unwrap().left().toString().toLowerCase().contains("ocean");
                float biomeTempAdj = StormObject.getTemperatureMCToWeatherSys(CoroUtilCompatibility.getAdjustedTemperature((Level)this.manager.getWorld(), (Biome)((Biome)bgb.value()), (BlockPos)new BlockPos(Mth.floor((double)this.pos.x), Mth.floor((double)this.pos.y), Mth.floor((double)this.pos.z))));
                this.levelTemperature = this.levelTemperature > biomeTempAdj ? (this.levelTemperature -= tempAdjustRate) : (this.levelTemperature += tempAdjustRate);
            }
            boolean performBuildup = false;
            Random rand = new Random();
            if (!this.isPrecipitating() && rand.nextInt(randomChanceOfWaterBuildFromNothing) == 0) {
                performBuildup = true;
            }
            if (!this.isPrecipitating() && ConfigMisc.overcastMode && this.manager.getWorld().isRaining() && rand.nextInt(randomChanceOfWaterBuildFromOvercastRaining) == 0) {
                performBuildup = true;
            }
            if (world.isLoaded(tryPos = new BlockPos(Mth.floor((double)this.pos.x), this.currentTopYBlock - 1, Mth.floor((double)this.pos.z))) && !CoroUtilBlock.isAir((Block)(state = world.getBlockState(tryPos)).getBlock()) && state.liquid()) {
                isOverWater = true;
            }
            if (!performBuildup && !this.isPrecipitating() && rand.nextInt(randomChanceOfWaterBuildFromWater) == 0) {
                if (isOverWater) {
                    performBuildup = true;
                }
                if (bgb.value() != null) {
                    String biomecat = bgb.unwrap().left().toString().toLowerCase();
                    if (!performBuildup && (isInOcean || biomecat.contains("swamp") || biomecat.contains("jungle") || biomecat.contains("river"))) {
                        performBuildup = true;
                    }
                }
            }
            if (performBuildup) {
                this.levelWater += levelWaterBuildRate;
                Weather.dbg(this.ID + ": building rain: " + this.levelWater);
            }
            if (this.isPrecipitating()) {
                this.levelWater -= levelWaterSpendRate;
                if (this.levelWater < 0) {
                    this.levelWater = 0;
                }
                if (this.levelWater <= 0) {
                    this.setPrecipitating(false);
                    Weather.dbg("ending raining for: " + this.ID);
                }
            } else if (this.levelWater >= this.levelWaterStartRaining) {
                if (ConfigMisc.overcastMode) {
                    if (this.manager.getWorld().isRaining() && ConfigStorm.Storm_Rain_Overcast_OddsTo1 != -1 && rand.nextInt(ConfigStorm.Storm_Rain_Overcast_OddsTo1) == 0) {
                        this.setPrecipitating(true);
                        Weather.dbg("starting raining for: " + this.ID);
                    }
                } else if (ConfigStorm.Storm_Rain_OddsTo1 != -1 && rand.nextInt(ConfigStorm.Storm_Rain_OddsTo1) == 0) {
                    this.setPrecipitating(true);
                    Weather.dbg("starting raining for: " + this.ID);
                }
            }
            boolean tempAlwaysFormStorm = false;
            if (this.canBeDeadly && this.levelCurIntensityStage == STATE_NORMAL) {
                if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                    if (ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks != -1) {
                        if (wm.lastStormFormed == 0L || wm.lastStormFormed + (long)ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks < world.getGameTime()) {
                            tryFormStorm = true;
                        } else if (ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks_Land_Based != -1 && wm.lastStormFormed + (long)ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks_Land_Based < world.getGameTime()) {
                            tryFormStorm = true;
                        }
                    }
                } else if (tempAlwaysFormStorm || ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks != -1) {
                    if (tempAlwaysFormStorm || lastStormDeadlyTime == 0L || lastStormDeadlyTime + (long)ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks < world.getGameTime()) {
                        tryFormStorm = true;
                    } else if (ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks_Land_Based != -1 && lastStormDeadlyTime + (long)ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks_Land_Based < world.getGameTime()) {
                        tryFormStorm = true;
                    }
                }
            }
            if (this.weatherMachineControlled) {
                return;
            }
            if ((ConfigMisc.overcastMode && this.manager.getWorld().isRaining() || !ConfigMisc.overcastMode) && WeatherUtilConfig.listDimensionsStorms.contains(this.manager.getWorld().dimension().location().toString()) && tryFormStorm) {
                int stormFrontCollideDist = ConfigStorm.Storm_Deadly_CollideDistance;
                int randomChanceOfCollide = ConfigStorm.Player_Storm_Deadly_OddsTo1;
                int randomChanceOfCollideLand = ConfigStorm.Player_Storm_Deadly_OddsTo1_Land_Based;
                if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                    randomChanceOfCollide = ConfigStorm.Server_Storm_Deadly_OddsTo1;
                    randomChanceOfCollideLand = ConfigStorm.Server_Storm_Deadly_OddsTo1_Land_Based;
                }
                if (isInOcean && ConfigStorm.Storm_OddsTo1OfOceanBasedStorm > 0 && rand.nextInt(ConfigStorm.Storm_OddsTo1OfOceanBasedStorm) == 0) {
                    Player entP = this.getPlayer();
                    if (entP != null) {
                        this.initRealStorm(entP, null);
                    } else {
                        this.initRealStorm(null, null);
                    }
                    if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                        wm.lastStormFormed = world.getGameTime();
                    } else {
                        playerNBT.putLong("lastStormDeadlyTime", world.getGameTime());
                    }
                } else if (!isInOcean && randomChanceOfCollideLand > 0 && rand.nextInt(randomChanceOfCollideLand) == 0) {
                    Player entP = this.getPlayer();
                    if (entP != null) {
                        this.initRealStorm(entP, null);
                    } else {
                        this.initRealStorm(null, null);
                    }
                    if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                        wm.lastStormFormed = world.getGameTime();
                    } else {
                        playerNBT.putLong("lastStormDeadlyTime", world.getGameTime());
                    }
                } else if (rand.nextInt(randomChanceOfCollide) == 0) {
                    for (int i = 0; i < this.manager.getStormObjects().size(); ++i) {
                        WeatherObject wo = this.manager.getStormObjects().get(i);
                        if (!(wo instanceof StormObject)) continue;
                        StormObject so = (StormObject)wo;
                        boolean startStorm = false;
                        if (so.ID != this.ID && so.levelCurIntensityStage <= 0 && !so.isCloudlessStorm() && !so.weatherMachineControlled && so.pos.distanceTo(this.pos) < (double)stormFrontCollideDist) {
                            if (this.levelTemperature < 0.0f) {
                                if (so.levelTemperature > 0.0f) {
                                    startStorm = true;
                                }
                            } else if (this.levelTemperature > 0.0f && so.levelTemperature < 0.0f) {
                                startStorm = true;
                            }
                        }
                        if (!startStorm) continue;
                        playerNBT.putLong("lastStormDeadlyTime", world.getGameTime());
                        Player entP = this.getPlayer();
                        if (entP != null) {
                            this.initRealStorm(entP, so);
                            break;
                        }
                        this.initRealStorm(null, so);
                        break;
                    }
                }
            }
            if (this.isRealStorm()) {
                if (ConfigMisc.overcastMode && !this.manager.getWorld().isRaining()) {
                    this.hasStormPeaked = true;
                }
                if (!this.hasStormPeaked) {
                    this.levelWater = this.levelWaterStartRaining;
                    this.setPrecipitating(true);
                }
                if ((this.levelCurIntensityStage == STATE_HIGHWIND || this.levelCurIntensityStage == STATE_HAIL) && isOverWater) {
                    if (ConfigStorm.Storm_OddsTo1OfHighWindWaterSpout != 0 && rand.nextInt(ConfigStorm.Storm_OddsTo1OfHighWindWaterSpout) == 0) {
                        this.attrib_waterSpout = true;
                    }
                } else {
                    this.attrib_waterSpout = false;
                }
                if (!this.hasStormPeaked) {
                    if (!(this.levelCurIntensityStage >= this.maxIntensityStage || ConfigTornado.Storm_NoTornadosOrCyclones && this.levelCurIntensityStage >= STATE_FORMING - 1)) {
                        if (this.levelCurStagesIntensity >= minIntensityToProgress && (this.alwaysProgresses || this.levelCurIntensityStage < this.levelStormIntensityMax)) {
                            this.stageNext();
                            Weather.dbg("storm ID: " + this.ID + " - growing, stage: " + this.levelCurIntensityStage + " pos: " + String.valueOf(this.pos));
                            if (isInOcean) {
                                // empty if block
                            }
                        }
                        if (this.levelCurIntensityStage == STATE_FORMING && (double)this.levelCurStagesIntensity >= 0.5 && (double)this.levelCurStagesIntensity < 0.9) {
                            this.levelCurStagesIntensity = 0.9f;
                        }
                    }
                    Weather.dbg("storm ID: " + this.ID + " - growing, stage " + this.levelCurIntensityStage + " of max " + this.levelStormIntensityMax + ", at intensity: " + this.levelCurStagesIntensity + " pos: " + String.valueOf(this.pos));
                    if (this.levelCurStagesIntensity >= 1.0f) {
                        Weather.dbg("storm peaked at: " + this.levelCurIntensityStage);
                        this.hasStormPeaked = true;
                    }
                } else {
                    if (ConfigMisc.overcastMode && this.manager.getWorld().isRaining()) {
                        this.levelCurStagesIntensity -= levelStormIntensityRate * 0.9f;
                    } else {
                        this.levelCurStagesIntensity -= levelStormIntensityRate * 0.3f;
                        if (this.levelCurIntensityStage >= STATE_FORMING) {
                            Weather.dbg("storm ID: " + this.ID + " - active info, stage: " + this.levelCurIntensityStage + " levelCurStagesIntensity: " + this.levelCurStagesIntensity + " pos: " + String.valueOf(this.pos));
                        }
                    }
                    if (this.levelCurIntensityStage == STATE_FORMING) {
                        if ((double)this.levelCurStagesIntensity > 0.5) {
                            this.levelCurStagesIntensity = 0.5f;
                        }
                        this.levelCurStagesIntensity -= levelStormIntensityRate * 0.9f;
                    }
                    if (this.levelCurStagesIntensity <= 0.0f) {
                        this.stagePrev();
                        Weather.dbg("storm ID: " + this.ID + " - dying, stage: " + this.levelCurIntensityStage + " pos: " + String.valueOf(this.pos));
                        if (this.levelCurIntensityStage <= 0) {
                            this.setNoStorm();
                        }
                    }
                }
            } else if (ConfigMisc.overcastMode && !this.manager.getWorld().isRaining() && this.attrib_precipitation) {
                this.setPrecipitating(false);
            }
        }
        if (world.getGameTime() % 2L == 0L && (ConfigMisc.overcastMode && this.manager.getWorld().isRaining() || !ConfigMisc.overcastMode) && WeatherUtilConfig.listDimensionsStorms.contains(this.manager.getWorld().dimension().location().toString()) && this.isRealStorm() && !this.hasStormPeaked) {
            if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
                levelStormIntensityRate *= 3.0f;
            }
            this.levelCurStagesIntensity += levelStormIntensityRate / 30.0f;
        }
        if (this.playerControlled && this.playerControlledTimeLeft > 0) {
            --this.playerControlledTimeLeft;
            if (this.playerControlledTimeLeft <= 0) {
                this.featherFallAllNearbyPlayers();
                this.remove();
            }
        }
    }

    public void featherFallAllNearbyPlayers() {
        this.tornadoHelper.forceRotate(this.manager.getWorld(), true);
    }

    public WeatherEntityConfig getWeatherEntityConfigForStorm() {
        WeatherEntityConfig weatherConfig = WeatherTypes.weatherEntTypes.get(0);
        if (this.levelCurIntensityStage >= STATE_STAGE5) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(5);
        } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(4);
        } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(3);
        } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(2);
        } else if (this.levelCurIntensityStage >= STATE_STAGE1) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(1);
        } else if (this.levelCurIntensityStage >= STATE_FORMING) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(0);
        }
        return weatherConfig;
    }

    public void stageNext() {
        ++this.levelCurIntensityStage;
        this.levelCurStagesIntensity = 0.0f;
        if (ConfigTornado.Storm_Tornado_aimAtPlayerOnSpawn && !this.hasStormPeaked && this.levelCurIntensityStage == STATE_FORMING && !Weather.isLoveTropicsInstalled()) {
            this.aimStormAtClosestOrProvidedPlayer(null);
        }
    }

    public void stagePrev() {
        --this.levelCurIntensityStage;
        this.levelCurStagesIntensity = 1.0f;
    }

    public void initRealStorm(Player entP, StormObject stormToAbsorb) {
        this.levelCurIntensityStage = STATE_THUNDER;
        float diff = 4.0f;
        if (stormToAbsorb != null) {
            diff = this.levelTemperature - stormToAbsorb.levelTemperature;
        }
        if (this.naturallySpawned) {
            this.levelWater = this.levelWaterStartRaining * 2;
        }
        this.levelStormIntensityMax = this.rollDiceOnMaxIntensity();
        Weather.dbg("rolled odds for storm, unless it becomes ocean storm, max stage will be: " + this.levelStormIntensityMax);
        this.attrib_precipitation = true;
        if (stormToAbsorb != null) {
            Weather.dbg("stormfront collision happened between ID " + this.ID + " and " + stormToAbsorb.ID);
            this.manager.removeStormObject(stormToAbsorb.ID);
            ((WeatherManagerServer)this.manager).syncStormRemove(stormToAbsorb);
        } else {
            Weather.dbg("ocean storm happened, ID " + this.ID);
        }
        if (ConfigTornado.Storm_Tornado_aimAtPlayerOnSpawn && !Weather.isLoveTropicsInstalled()) {
            this.aimStormAtClosestOrProvidedPlayer(entP);
        }
    }

    public int rollDiceOnMaxIntensity() {
        Random rand = new Random();
        int randVal = rand.nextInt(100);
        if (this.stormType == TYPE_LAND) {
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F5_Tornado) {
                return STATE_STAGE5;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F4_Tornado) {
                return STATE_STAGE4;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F3_Tornado) {
                return STATE_STAGE3;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F2_Tornado) {
                return STATE_STAGE2;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F1_Tornado) {
                return STATE_STAGE1;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F0_Tornado) {
                return STATE_FORMING;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_Hail) {
                return STATE_HAIL;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_HighWind) {
                return STATE_HIGHWIND;
            }
        } else if (this.stormType == TYPE_WATER) {
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C5_Cyclone) {
                return STATE_STAGE5;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C4_Cyclone) {
                return STATE_STAGE4;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C3_Cyclone) {
                return STATE_STAGE3;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C2_Cyclone) {
                return STATE_STAGE2;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C1_Cyclone) {
                return STATE_STAGE1;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C0_Cyclone) {
                return STATE_FORMING;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_Hail) {
                return STATE_HAIL;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_HighWind) {
                return STATE_HIGHWIND;
            }
        }
        return STATE_THUNDER;
    }

    public void aimStormAtClosestOrProvidedPlayer(Player entP) {
        if (entP == null) {
            entP = this.manager.getWorld().getNearestPlayer(this.pos.x, this.pos.y, this.pos.z, -1.0, false);
        }
        if (entP != null) {
            this.aimAtCoords(entP.position());
        }
    }

    public void aimAtCoords(Vec3 vec) {
        Random rand = new Random();
        double var11 = vec.x() - this.pos.x;
        double var15 = vec.z() - this.pos.z;
        float yaw = -((float)(Math.atan2(var11, var15) * 180.0 / Math.PI));
        int size = ConfigTornado.Storm_Tornado_aimAtPlayerAngleVariance;
        if (size > 0 && !Weather.isLoveTropicsInstalled()) {
            yaw += (float)(rand.nextInt(size) - size / 2);
        }
        this.angleIsOverridden = true;
        this.angleMovementTornadoOverride = yaw;
    }

    public void aimAwayFromCoords(Vec3 vec) {
        Random rand = new Random();
        double var11 = vec.x() - this.pos.x;
        double var15 = vec.z() - this.pos.z;
        float yaw = -((float)(Math.atan2(var11, var15) * 180.0 / Math.PI));
        this.angleIsOverridden = true;
        this.angleMovementTornadoOverride = yaw += 180.0f;
    }

    public void setNoStorm() {
        Weather.dbg("storm ID: " + this.ID + " - ended storm event");
        this.levelCurIntensityStage = STATE_NORMAL;
        this.levelCurStagesIntensity = 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
        int i;
        EntityRotFX particle;
        Vec3 tryPos;
        double spawnRad;
        int i2;
        if (this.isCloudlessStorm()) {
            return;
        }
        if (this.particleBehaviorFog == null) {
            this.particleBehaviorFog = new ParticleBehaviorFog(new Vec3(this.pos.x, this.pos.y, this.pos.z));
        } else if (!Minecraft.getInstance().isPaused()) {
            this.particleBehaviorFog.tickUpdateList();
        }
        LocalPlayer entP = Minecraft.getInstance().player;
        this.spinSpeed = 0.02;
        double spinSpeedMax = 0.4;
        this.spinSpeed = this.isCycloneFormingOrGreater() ? spinSpeedMax * 0.0 + (double)((float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f) * spinSpeedMax * 0.2 : (this.isTornadoFormingOrGreater() ? spinSpeedMax * 0.2 : (this.levelCurIntensityStage >= STATE_HIGHWIND ? spinSpeedMax * 0.05 : spinSpeedMax * 0.02));
        if (this.isHurricane()) {
            this.spinSpeed += 0.1;
        }
        if (this.size == 0) {
            this.size = 1;
        }
        int delay = Math.max(1, (int)(100.0f / (float)this.size * 1.0f));
        int loopSize = 1;
        int extraSpawning = 0;
        if (this.isSpinning()) {
            loopSize += 4;
            extraSpawning = 300;
        }
        if (this.stormType == TYPE_WATER) {
            if (this.levelCurIntensityStage >= STATE_STAGE5) {
                loopSize = 10;
                extraSpawning = 800;
            } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
                loopSize = 8;
                extraSpawning = 700;
            } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
                loopSize = 6;
                extraSpawning = 500;
            } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
                loopSize = 4;
                extraSpawning = 400;
            } else {
                extraSpawning = 300;
            }
        }
        Random rand = new Random();
        Vec3 playerAdjPos = new Vec3(entP.getX(), this.pos.y, entP.getZ());
        double maxSpawnDistFromPlayer = 512.0;
        if (!this.pet && !this.baby && this.manager.getWorld().getGameTime() % (long)(delay + (this.isSpinning() ? ConfigStorm.Storm_ParticleSpawnDelay : ConfigMisc.Cloud_ParticleSpawnDelay)) == 0L) {
            for (i2 = 0; i2 < loopSize; ++i2) {
                EntityRotFX particle2;
                if (!((float)this.listParticlesCloud.size() < (float)(this.size + extraSpawning) / 1.0f)) continue;
                spawnRad = this.size;
                tryPos = new Vec3(this.pos.x + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, this.getPosTop().y + 30.0, this.pos.z + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad);
                if (!(tryPos.distanceTo(playerAdjPos) < maxSpawnDistFromPlayer) || this.getAvoidAngleIfTerrainAtOrAheadOfPosition(this.getAdjustedAngle(), tryPos) != 0.0f) continue;
                if (WeatherUtil.isAprilFoolsDay() && !Weather.isLoveTropicsInstalled()) {
                    particle2 = this.spawnFogParticle(tryPos.x, tryPos.y, tryPos.z, 0, ParticleRegistry.chicken);
                } else {
                    particle2 = this.spawnFogParticle(tryPos.x, tryPos.y, tryPos.z, 0);
                    if (this.isFirenado && this.isSpinning()) {
                        particle2.setSprite(ParticleRegistry.cloud256_fire);
                        particle2.setColor(1.0f, 1.0f, 1.0f);
                    }
                }
                this.listParticlesCloud.add(particle2);
            }
        }
        if (this.levelCurIntensityStage >= STATE_HIGHWIND && !this.baby && !this.pet) {
            for (i2 = 0; i2 < (this.stormType == TYPE_WATER ? 50 : 3); ++i2) {
                if (this.listParticlesGround.size() >= (this.stormType == TYPE_WATER ? 600 : 150)) continue;
                spawnRad = this.size / 4 * 3;
                if (this.stormType == TYPE_WATER) {
                    spawnRad = this.size * 3;
                }
                if (!((tryPos = new Vec3(this.pos.x + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, this.posGround.y, this.pos.z + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad)).distanceTo(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                int groundY = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), new BlockPos((int)tryPos.x, 0, (int)tryPos.z)).getY();
                particle = WeatherUtil.isAprilFoolsDay() && !Weather.isLoveTropicsInstalled() ? this.spawnFogParticle(tryPos.x, groundY + 3, tryPos.z, 0, ParticleRegistry.potato) : this.spawnFogParticle(tryPos.x, groundY + 3, tryPos.z, 0);
                particle.setScale(30.000002f);
                particle.rotationYaw = rand.nextInt(360);
                particle.rotationPitch = rand.nextInt(360);
                this.listParticlesGround.add(particle);
            }
        }
        delay = 1;
        loopSize = 2;
        double spawnRad2 = this.size / 48;
        if (this.levelCurIntensityStage >= STATE_STAGE5) {
            spawnRad2 = 200.0;
            loopSize = 10;
            this.sizeMaxFunnelParticles = 1200;
        } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
            spawnRad2 = 150.0;
            loopSize = 8;
            this.sizeMaxFunnelParticles = 1000;
        } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
            spawnRad2 = 100.0;
            loopSize = 6;
            this.sizeMaxFunnelParticles = 800;
        } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
            spawnRad2 = 50.0;
            loopSize = 4;
            this.sizeMaxFunnelParticles = 600;
        } else {
            this.sizeMaxFunnelParticles = 600;
        }
        boolean tornadoV2 = true;
        if (!tornadoV2) {
            if ((this.isTornadoFormingOrGreater() || this.attrib_waterSpout) && this.manager.getWorld().getGameTime() % (long)(delay + ConfigStorm.Storm_ParticleSpawnDelay) == 0L) {
                for (int i3 = 0; i3 < loopSize; ++i3) {
                    Vec3 tryPos2;
                    if (this.listParticlesFunnel.size() >= this.sizeMaxFunnelParticles) {
                        this.listParticlesFunnel.get(0).remove();
                        this.listParticlesFunnel.remove(0);
                    }
                    if (this.listParticlesFunnel.size() >= this.sizeMaxFunnelParticles || !((tryPos2 = new Vec3(this.pos.x + rand.nextDouble() * spawnRad2 - rand.nextDouble() * spawnRad2, this.pos.y, this.pos.z + rand.nextDouble() * spawnRad2 - rand.nextDouble() * spawnRad2)).distanceTo(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                    particle = !this.isFirenado ? (WeatherUtil.isAprilFoolsDay() && !Weather.isLoveTropicsInstalled() ? this.spawnFogParticle(tryPos2.x, this.posBaseFormationPos.y, tryPos2.z, 1, ParticleRegistry.potato) : this.spawnFogParticle(tryPos2.x, this.posBaseFormationPos.y, tryPos2.z, 1)) : this.spawnFogParticle(tryPos2.x, this.posBaseFormationPos.y, tryPos2.z, 1, ParticleRegistry.cloud256_fire);
                    particle.setMaxAge(150 + (this.levelCurIntensityStage - 1) * 100 + rand.nextInt(100));
                    float baseBright = 0.3f;
                    float randFloat = rand.nextFloat() * 0.6f;
                    particle.rotationYaw = rand.nextInt(360);
                    float finalBright = Math.min(1.0f, baseBright + randFloat);
                    if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                        particle.setScale(22.5f);
                        particle.setColor(finalBright - 0.2f, finalBright - 0.2f, finalBright);
                    } else {
                        particle.setScale(37.5f);
                        particle.setColor(finalBright, finalBright, finalBright);
                    }
                    if (this.isFirenado) {
                        particle.setColor(1.0f, 1.0f, 1.0f);
                        particle.setScale(particle.getScale() * 0.7f);
                    }
                    this.listParticlesFunnel.add(particle);
                }
            }
            for (int i4 = 0; i4 < this.listParticlesFunnel.size(); ++i4) {
                EntityRotFX ent = this.listParticlesFunnel.get(i4);
                if (!ent.isAlive()) {
                    this.listParticlesFunnel.remove(ent);
                    continue;
                }
                if (ent.getPosY() > this.pos.y) {
                    ent.remove();
                    this.listParticlesFunnel.remove(ent);
                    continue;
                }
                double var16 = this.pos.x - ent.getPosX();
                double var18 = this.pos.z - ent.getPosZ();
                ent.rotationYaw = -((float)(Math.atan2(var18, var16) * 180.0 / Math.PI)) - 90.0f;
                ent.rotationYaw -= (float)(ent.getEntityId() % 90);
                ent.rotationPitch = 30.0f;
                if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                    int fadingDistStart = 30;
                    if (ent.getPosY() > this.posGround.y + (double)fadingDistStart) {
                        float maxVal = ent.bCol;
                        float fadeRate = 0.002f;
                        ent.setColor(Math.min(maxVal, ent.rCol + fadeRate), Math.min(maxVal, ent.gCol + fadeRate), maxVal);
                    }
                }
                this.spinEntity(ent);
            }
        }
        if (this.isTornadoFormingOrGreater() || this.attrib_waterSpout) {
            if (this.manager.getWorld().getGameTime() % 5L == 0L) {
                // empty if block
            }
            for (int i5 = 0; i5 < this.listParticlesDebris.size(); ++i5) {
                EntityRotFX ent = this.listParticlesDebris.get(i5);
                if (!ent.isAlive()) {
                    this.listParticlesDebris.remove(ent);
                    continue;
                }
                double speedXZ = Math.sqrt(ent.getMotionX() * ent.getMotionX() + ent.getMotionY() * ent.getMotionY() + ent.getMotionZ() * ent.getMotionZ());
                if (!(speedXZ < 30.0)) continue;
                Vec3 motion = this.spinObject(ent.getPos(), new Vec3(ent.getMotionX(), ent.getMotionY(), ent.getMotionZ()), false, 0.91f, 1.0f, ent instanceof ParticleCube, 0.0f);
                float damp = 1.0f;
                damp = ent.getWindWeight() / 5.0f;
                motion = motion.multiply((double)damp, 1.0, (double)damp);
                ent.setMotionX(motion.x);
                ent.setMotionY(motion.y);
                ent.setMotionZ(motion.z);
            }
        }
        for (i = 0; i < this.listParticlesCloud.size(); ++i) {
            EntityRotFX ent = this.listParticlesCloud.get(i);
            if (!ent.isAlive()) {
                this.listParticlesCloud.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.getMotionX() * ent.getMotionX() + ent.getMotionY() * ent.getMotionY() + ent.getMotionZ() * ent.getMotionZ());
            double curDist = ent.getDistance(this.getPosTop().x, ent.getPosY(), this.getPosTop().z);
            float dropDownRange = 15.0f;
            float extraDropCalc = 0.0f;
            if (curDist < 200.0 && ent.getEntityId() % 20 < 5) {
                extraDropCalc = (float)(ent.getEntityId() % 20) * dropDownRange;
                if (this.isCycloneFormingOrGreater()) {
                    extraDropCalc = (float)(ent.getEntityId() % 20) * dropDownRange * 5.0f;
                }
            }
            if (this.isSpinning()) {
                double speed = this.spinSpeed + rand.nextDouble() * 0.01;
                double distt = this.size;
                double vecX = ent.getPosX() - this.getPosTop().x;
                double vecZ = ent.getPosZ() - this.getPosTop().z;
                float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
                angle = (float)((double)angle + speed * 50.0);
                angle = (float)((double)angle - (double)(ent.getEntityId() % 10) * 3.0);
                angle += (float)(rand.nextInt(10) - rand.nextInt(10));
                if (curDist > distt) {
                    angle += 40.0f;
                }
                if (ent.getEntityId() % 20 < 5) {
                    if (this.levelCurIntensityStage >= STATE_FORMING) {
                        if (this.stormType == TYPE_WATER) {
                            angle += (float)(40 + ent.getEntityId() % 5 * 4);
                            if (curDist > (double)(150.0f + ((float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f) * 30.0f)) {
                                angle += 10.0f;
                            }
                        } else {
                            angle += (float)(30 + ent.getEntityId() % 5 * 4);
                        }
                    } else if (curDist > 150.0) {
                        angle += (float)(50 + ent.getEntityId() % 5 * 4);
                    }
                    double diffX = this.getPosTop().x - ent.getPosX();
                    double diffZ = this.getPosTop().z - ent.getPosZ();
                    ent.rotationYaw = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - 90.0f;
                    ent.rotationYaw = -((float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI)) - 90.0f;
                    ent.rotationPitch = 20.0f - (float)(ent.getEntityId() % 10);
                }
                if (curSpeed < speed * 20.0) {
                    ent.setMotionX(ent.getMotionX() + -Math.sin(Math.toRadians(angle)) * speed);
                    ent.setMotionZ(ent.getMotionZ() + Math.cos(Math.toRadians(angle)) * speed);
                }
            } else {
                float cloudMoveAmp = 0.2f * (float)(1 + this.layer);
                float speed = this.getAdjustedSpeed() * cloudMoveAmp;
                float angle = this.getAdjustedAngle();
                if ((this.manager.getWorld().getGameTime() + this.ID) % 40L == 0L) {
                    ent.avoidTerrainAngle = this.getAvoidAngleIfTerrainAtOrAheadOfPosition(angle, ent.getPos());
                }
                angle += ent.avoidTerrainAngle;
                if (ent.avoidTerrainAngle != 0.0f) {
                    speed = (float)((double)speed * 0.5);
                }
                dropDownRange = 5.0f;
                if (ent.getEntityId() % 20 < 5) {
                    extraDropCalc = (float)(ent.getEntityId() % 20) * dropDownRange;
                }
                if (curSpeed < (double)speed * 1.0) {
                    ent.setMotionX(ent.getMotionX() + -Math.sin(Math.toRadians(angle)) * (double)speed);
                    ent.setMotionZ(ent.getMotionZ() + Math.cos(Math.toRadians(angle)) * (double)speed);
                }
            }
            if (Math.abs(ent.getPosY() - (this.getPosTop().y - (double)extraDropCalc)) > 2.0) {
                if (ent.getPosY() < this.getPosTop().y - (double)extraDropCalc) {
                    ent.setMotionY(ent.getMotionY() + 0.1);
                } else {
                    ent.setMotionY(ent.getMotionY() - 0.1);
                }
            }
            float dropDownSpeedMax = 0.15f;
            if (this.isCycloneFormingOrGreater()) {
                dropDownSpeedMax = 0.9f;
            }
            if (ent.getMotionY() < (double)(-dropDownSpeedMax)) {
                ent.setMotionY(-dropDownSpeedMax);
            }
            if (!(ent.getMotionY() > (double)dropDownSpeedMax)) continue;
            ent.setMotionY(dropDownSpeedMax);
        }
        for (i = 0; i < this.listParticlesGround.size(); ++i) {
            EntityRotFX ent = this.listParticlesGround.get(i);
            double curDist = ent.getDistance(this.pos.x, ent.getPosY(), this.pos.z);
            if (!ent.isAlive()) {
                this.listParticlesGround.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.getMotionX() * ent.getMotionX() + ent.getMotionY() * ent.getMotionY() + ent.getMotionZ() * ent.getMotionZ());
            double speed = Math.max((double)0.2f, 5.0 * this.spinSpeed) + rand.nextDouble() * 0.01;
            double distt = this.size;
            double vecX = ent.getPosX() - this.pos.x;
            double vecZ = ent.getPosZ() - this.pos.z;
            float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
            angle += 85.0f;
            int maxParticleSize = 60;
            if (this.stormType == TYPE_WATER) {
                maxParticleSize = 150;
                speed /= 5.0;
            }
            ent.setScale((float)Math.min((double)((float)maxParticleSize * 0.15f), curDist * 2.0 * (double)0.15f));
            if (curDist < 20.0) {
                ent.remove();
            }
            double var16 = this.pos.x - ent.getPosX();
            double var18 = this.pos.z - ent.getPosZ();
            if (!(curSpeed < speed * 20.0)) continue;
            ent.setMotionX(ent.getMotionX() + -Math.sin(Math.toRadians(angle)) * speed);
            ent.setMotionZ(ent.getMotionZ() + Math.cos(Math.toRadians(angle)) * speed);
        }
    }

    public float getAdjustedSpeed() {
        return this.manager.getWindManager().getWindSpeedForClouds();
    }

    public float getAdjustedAngle() {
        float angle = this.manager.getWindManager().getWindAngleForClouds();
        float angleAdjust = 45.0f;
        float targetYaw = 0.0f;
        targetYaw = this.levelTemperature > 0.0f ? 180.0f : 0.0f;
        float bestMove = Mth.wrapDegrees((float)(targetYaw - angle));
        if (Math.abs(bestMove) < 180.0f) {
            if (bestMove > 0.0f) {
                angle -= angleAdjust;
            }
            if (bestMove < 0.0f) {
                angle += angleAdjust;
            }
        }
        if (this.manager.getWorld().getGameTime() % 40L == 0L) {
            // empty if block
        }
        return angle;
    }

    public float getAvoidAngleIfTerrainAtOrAheadOfPosition(float angle, Vec3 pos) {
        double scanDistMax = 120.0;
        for (int scanAngle = -20; scanAngle < 20; scanAngle += 10) {
            for (double scanDistRange = 20.0; scanDistRange < scanDistMax; scanDistRange += 10.0) {
                double scanX = pos.x + -Math.sin(Math.toRadians(angle + (float)scanAngle)) * scanDistRange;
                double scanZ = pos.z + Math.cos(Math.toRadians(angle + (float)scanAngle)) * scanDistRange;
                int height = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), CoroUtilBlock.blockPos((double)scanX, (double)0.0, (double)scanZ)).getY();
                if (!(pos.y < (double)height)) continue;
                if (scanAngle <= 0) {
                    return 90.0f;
                }
                return -90.0f;
            }
        }
        return 0.0f;
    }

    public Player getRandomNearPlayer(Entity entityLineOfSightSource) {
        List players = this.manager.getWorld().players();
        ArrayList<Player> playersNear = new ArrayList<Player>();
        for (Player player : players) {
            if (player.isSpectator() || !(player.position().distanceTo(this.posGround) < 196.0) || !player.hasLineOfSight(entityLineOfSightSource)) continue;
            playersNear.add(player);
        }
        if (!playersNear.isEmpty()) {
            Collections.shuffle(playersNear);
            return (Player)playersNear.get(0);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void spinEntityv2(Entity entity) {
        if (entity.getPersistentData().getBoolean("tornado_shoot")) {
            if (!entity.getPersistentData().contains("tornado_shoot_target")) {
                Player player = this.getRandomNearPlayer(entity);
                if (player == null) return;
                entity.getPersistentData().putString("tornado_shoot_target", player.getUUID().toString());
                return;
            }
            UUID uuid = UUID.fromString(entity.getPersistentData().getString("tornado_shoot_target"));
            Player player = this.manager.getWorld().getPlayerByUUID(uuid);
            if (player == null) return;
            double vecx = player.position().x - entity.position().x;
            double vecy = player.position().y - entity.position().y;
            double vecz = player.position().z - entity.position().z;
            Vec3 vec = new Vec3(vecx, vecy, vecz);
            double speed = 2.0;
            vec = vec.normalize().multiply(speed, speed, speed);
            entity.setDeltaMovement(vec.x, vec.y, vec.z);
            float rotationYaw = (float)(Mth.atan2((double)vecz, (double)vecx) * 180.0 / Math.PI) - 90.0f;
            entity.setYRot(rotationYaw);
            if (player.position().distanceTo(entity.position()) < 3.0 && entity.isAlive()) {
                player.hurt(this.manager.getWorld().damageSources().cactus(), 1.5f);
                entity.kill();
            }
            if (!entity.isInWater()) return;
            return;
        } else {
            float dampenY = 1.0f;
            float dampenXZ = 1.0f;
            float grabAdj = 0.0f;
            double entHeightFromBase = Math.max((double)0.1f, entity.getY() - this.posBaseFormationPos.y);
            if (entity instanceof Player) {
                if (((Player)entity).getMainHandItem().getItem().toString().contains("acid_repellent_umbrella") || ((Player)entity).getOffhandItem().getItem().toString().contains("acid_repellent_umbrella")) {
                    if (entHeightFromBase > 80.0) {
                        dampenY = 0.7f;
                    }
                    dampenXZ = 1.4f;
                    grabAdj -= 20.0f;
                }
                float weightAdj = WeatherUtilEntity.getWeightAdjFromEquipment(1.0f, (Player)entity);
                dampenY /= weightAdj;
                dampenXZ /= weightAdj;
            }
            entity.setDeltaMovement(this.spinObject(entity.position(), entity.getDeltaMovement(), entity instanceof Player, dampenXZ, dampenY, false, grabAdj));
            if (!ConfigTornado.Storm_Tornado_fallDamage || CoroUtilEntOrParticle.getMotionY((Object)entity) > -0.8) {
                entity.fallDistance = 0.0f;
            }
            if (this.isFirenado) {
                Vec3 posEnt = entity.position();
                Vec3 posFunnel = this.getFunnelCenter(posEnt);
                double distXZ = entity.position().distanceTo(new Vec3(posFunnel.x, posEnt.y, posFunnel.z));
                if (entHeightFromBase > 5.0 && entHeightFromBase < 70.0 && distXZ < entHeightFromBase * 1.3) {
                    entity.igniteForTicks(6);
                }
            }
            if (!(entHeightFromBase > 90.0)) return;
            if (Weather.isLoveTropicsInstalled()) {
                if (!this.isSharknado()) return;
                if (!(entity instanceof Dolphin)) return;
                entity.getPersistentData().putBoolean("tornado_shoot", true);
                return;
            }
            if (!this.isSharknado()) return;
            if (!(entity instanceof Dolphin)) return;
            entity.getPersistentData().putBoolean("tornado_shoot", true);
        }
    }

    public Vec3 getFunnelCenter(Vec3 position) {
        Vec3 posCenter = this.getPosTop();
        for (Layer layer : this.tornadoFunnelSimple.listLayers) {
            if (!(position.y - 1.5 < layer.getPos().y)) continue;
            posCenter = layer.getPos();
            break;
        }
        return posCenter;
    }

    public Vec3 spinObject(Vec3 position, Vec3 motion, boolean forPlayer, float dampenXZ, float dampenY, boolean forCube, float grabAdj) {
        Vec3 posCenter = this.getFunnelCenter(position);
        double vecx = posCenter.x - position.x;
        double vecz = posCenter.z - position.z;
        Vec3 vecXZ = new Vec3(posCenter.x, position.y, posCenter.z);
        double distXZMax = this.tornadoFunnelSimple.getConfig().getEntityPullDistXZ();
        double distXZMaxForYGrab = this.tornadoFunnelSimple.getConfig().getEntityPullDistXZForY();
        double distXZ = Math.min(position.distanceTo(vecXZ), distXZMax);
        double distXZForYGrab = Math.min(position.distanceTo(vecXZ), distXZMaxForYGrab);
        double grabAmp = (float)(this.levelCurIntensityStage - STATE_FORMING) / (float)(STATE_STAGE5 - STATE_FORMING);
        float angle = (float)(Mth.atan2((double)vecz, (double)vecx) * 180.0 / Math.PI + 180.0);
        angle += (float)ConfigTornado.Storm_Tornado_extraGrabAngle;
        if (this.pet) {
            angle += 50.0f;
        }
        if (forCube) {
            angle += 20.0f;
        }
        angle += grabAdj;
        double entHeightFromBase = Math.max((double)0.1f, position.y - this.posBaseFormationPos.y);
        double heightMathMax = 125.0;
        heightMathMax = 175.0;
        if (this.baby) {
            heightMathMax = 15.0;
        }
        if (this.pet) {
            heightMathMax = 4.0;
        }
        if (this.playerControlled) {
            heightMathMax = 40.0;
        }
        double heightAmp = (heightMathMax - entHeightFromBase) / heightMathMax;
        if (!this.pet) {
            angle = (float)((double)angle + 40.0 * heightAmp);
        }
        angle = (float)((double)angle - 40.0 * grabAmp);
        angle = (float)Math.toRadians(angle);
        double pullStrength = 0.2;
        double pullStrengthY = 0.2;
        pullStrengthY += 0.2 * grabAmp;
        double pullYAmp = 1.0;
        if (this.levelCurIntensityStage == STATE_FORMING) {
            pullYAmp = this.levelCurStagesIntensity;
        }
        pullStrengthY *= pullYAmp;
        pullStrength *= pullYAmp;
        if (this.pet) {
            pullStrength = 0.05;
        }
        if (this.pet) {
            pullStrengthY = 0.05;
        }
        if (this.sharknado && forPlayer) {
            pullStrength = 0.05;
        }
        if (this.sharknado && forPlayer) {
            pullStrengthY = 0.1;
        }
        double pullY = pullStrengthY * (distXZMaxForYGrab - distXZForYGrab) / distXZMaxForYGrab;
        double pullXZ = pullStrength * (distXZMax - distXZ) / distXZMax;
        double xx = -Math.sin(angle) * pullXZ;
        double zz = Math.cos(angle) * pullXZ;
        double yy = pullY;
        if (!this.baby && motion.y > 0.5) {
            yy = 0.0;
        }
        if (this.pet && motion.y > (double)0.15f) {
            yy = 0.0;
        }
        return new Vec3(motion.x + xx * (double)dampenXZ, motion.y + yy * (double)dampenY, motion.z + zz * (double)dampenXZ);
    }

    public void spinEntity(Object entity1) {
        float f;
        float f1;
        StormObject entT = this;
        StormObject entity = this;
        WeatherEntityConfig conf = this.getWeatherEntityConfigForStorm();
        Random rand = new Random();
        boolean forTornado = true;
        Level world = CoroUtilEntOrParticle.getWorld((Object)entity1);
        long worldTime = world.getGameTime();
        Entity ent = null;
        if (entity1 instanceof Entity) {
            ent = (Entity)entity1;
        }
        double radius = 10.0;
        double scale = conf.tornadoWidthScale;
        double d1 = entity.pos.x - CoroUtilEntOrParticle.getPosX((Object)entity1);
        double d2 = entity.pos.z - CoroUtilEntOrParticle.getPosZ((Object)entity1);
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT) {
            float range = 30.0f * (float)Math.sin(Math.toRadians(((float)worldTime * 0.5f + (float)(this.ID * 50L)) % 360.0f));
            float heightPercent = (float)(1.0 - (CoroUtilEntOrParticle.getPosY((Object)entity1) - this.posGround.y) / (this.pos.y - this.posGround.y));
            float posOffsetX = (float)Math.sin(Math.toRadians(heightPercent * 360.0f));
            float posOffsetZ = (float)(-Math.cos(Math.toRadians(heightPercent * 360.0f)));
            d1 += (double)(range * posOffsetX);
            d2 += (double)(range * posOffsetZ);
        }
        for (f1 = f = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f; f1 < -180.0f; f1 += 360.0f) {
        }
        while (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        double distY = entity.pos.y - CoroUtilEntOrParticle.getPosY((Object)entity1);
        double distXZ = Math.sqrt(Math.abs(d1)) + Math.sqrt(Math.abs(d2));
        distY = CoroUtilEntOrParticle.getPosY((Object)entity1) - entity.pos.y < 0.0 ? 1.0 : CoroUtilEntOrParticle.getPosY((Object)entity1) - entity.pos.y;
        if (distY > (double)this.maxHeight) {
            distY = this.maxHeight;
        }
        float weight = WeatherUtilEntity.getWeight(entity1);
        double grab = 10.0 / (double)weight * (Math.abs((double)this.maxHeight - distY) / (double)this.maxHeight);
        float pullY = 0.0f;
        if (rand.nextInt(5) != 0) {
            // empty if block
        }
        if (distXZ > 5.0) {
            grab *= radius / distXZ;
        }
        pullY += conf.tornadoLiftRate / (weight / 2.0f);
        if (entity1 instanceof Player) {
            adjPull = 0.2 / ((double)weight * ((distXZ + 1.0) / radius));
            pullY = (float)((double)pullY + adjPull);
            double adjGrab = 0.024999999441206455;
            if (adjGrab > 50.0) {
                adjGrab = 50.0;
            }
            if (adjGrab < -50.0) {
                adjGrab = -50.0;
            }
            grab -= adjGrab;
            if (CoroUtilEntOrParticle.getMotionY((Object)entity1) > -0.8) {
                ent.fallDistance = 0.0f;
            }
        } else if (entity1 instanceof LivingEntity) {
            adjPull = 0.005 / ((double)weight * ((distXZ + 1.0) / radius));
            pullY = (float)((double)pullY + adjPull);
            int airTime = ent.getPersistentData().getInt("timeInAir");
            double adjGrab = 10.0 * (double)((float)(((double)airTime + 1.0) / 400.0));
            if (adjGrab > 50.0) {
                adjGrab = 50.0;
            }
            if (adjGrab < -50.0) {
                adjGrab = -50.0;
            }
            grab -= adjGrab;
            if (ent.getDeltaMovement().y > -1.5) {
                ent.fallDistance = 0.0f;
            }
            if (ent.getDeltaMovement().y > (double)0.3f) {
                ent.setDeltaMovement(ent.getDeltaMovement().x, (double)0.3f, ent.getDeltaMovement().z);
            }
            if (forTornado) {
                ent.setOnGround(false);
            }
            if (!this.isFirenado) {
                ent.clearFire();
            }
        }
        double profileAngle = Math.max(1.0, 75.0 + (grab += (double)conf.relTornadoSize) - 10.0 * scale);
        f1 = (float)((double)f1 + profileAngle);
        if (entT != null && entT.scale != 1.0f) {
            f1 += 20.0f - 20.0f * entT.scale;
        }
        float f3 = (float)Math.cos(-f1 * 0.01745329f - (float)Math.PI);
        float f4 = (float)Math.sin(-f1 * 0.01745329f - (float)Math.PI);
        float f5 = conf.tornadoPullRate * 1.0f;
        if (entT != null && entT.scale != 1.0f) {
            f5 *= entT.scale * 1.2f;
        }
        if (entity1 instanceof LivingEntity) {
            f5 = (float)((double)f5 / ((double)WeatherUtilEntity.getWeight(entity1) * ((distXZ + 1.0) / radius)));
        }
        if (entity1 instanceof Player && conf.type != 0) {
            f5 = ent.onGround() ? (f5 *= 10.5f) : (f5 *= 5.0f);
        } else if (entity1 instanceof LivingEntity && conf.type != 0) {
            f5 *= 1.5f;
        }
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT && entity1 instanceof LivingEntity) {
            f5 *= 0.3f;
        }
        float moveX = f3 * f5;
        float moveZ = f4 * f5;
        float str = 1.0f;
        str = this.strength;
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT && entity1 instanceof LivingEntity) {
            str *= 0.3f;
        }
        pullY *= str / 100.0f;
        if (entT != null && entT.scale != 1.0f) {
            pullY *= entT.scale * 1.0f;
            pullY += 0.002f;
        }
        if (entity1 instanceof Entity) {
            long lastPullTime = ent.getPersistentData().getLong("lastPullTime");
            if (lastPullTime == worldTime) {
                pullY = 0.0f;
            }
            ent.getPersistentData().putLong("lastPullTime", worldTime);
        }
        this.setVel(entity1, -moveX, pullY, moveZ);
    }

    public void setVel(Object entity, float f, float f1, float f2) {
        CoroUtilEntOrParticle.setMotionX((Object)entity, (double)(CoroUtilEntOrParticle.getMotionX((Object)entity) + (double)f));
        CoroUtilEntOrParticle.setMotionY((Object)entity, (double)(CoroUtilEntOrParticle.getMotionY((Object)entity) + (double)f1));
        CoroUtilEntOrParticle.setMotionZ((Object)entity, (double)(CoroUtilEntOrParticle.getMotionZ((Object)entity) + (double)f2));
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityRotFX spawnFogParticle(double x, double y, double z, int parRenderOrder) {
        return this.spawnFogParticle(x, y, z, parRenderOrder, ParticleRegistry.cloud256);
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityRotFX spawnFogParticle(double x, double y, double z, int parRenderOrder, TextureAtlasSprite tex) {
        double speed = 0.0;
        Random rand = new Random();
        EntityRotFX entityfx = this.particleBehaviorFog.spawnNewParticleIconFX((Level)Minecraft.getInstance().level, tex, x, y, z, (rand.nextDouble() - rand.nextDouble()) * speed, 0.0, (rand.nextDouble() - rand.nextDouble()) * speed, parRenderOrder);
        this.particleBehaviorFog.initParticle(entityfx);
        entityfx.setCanCollide(false);
        entityfx.callUpdatePB = false;
        boolean debug = this.debugCloudTemperature = false;
        if (debug) {
            // empty if block
        }
        if (this.levelCurIntensityStage == STATE_NORMAL) {
            entityfx.setMaxAge(300 + rand.nextInt(100));
        } else {
            entityfx.setMaxAge(this.size / 2 + rand.nextInt(100));
        }
        if (entityfx.getEntityId() % 20 < 5 && this.isSpinning()) {
            entityfx.renderOrder = 1;
            entityfx.setMaxAge(this.size + rand.nextInt(100));
        }
        float randFloat = rand.nextFloat() * 0.6f;
        float baseBright = 0.7f;
        if (this.levelCurIntensityStage > STATE_NORMAL) {
            baseBright = 0.2f;
        } else if (this.attrib_precipitation) {
            baseBright = 0.2f;
        } else if (this.manager.isVanillaRainActiveOnServer) {
            baseBright = 0.2f;
        } else {
            float adj = Math.min(1.0f, (float)(this.levelWater / this.levelWaterStartRaining)) * 0.6f;
            baseBright -= adj;
        }
        float finalBright = Math.min(1.0f, baseBright + randFloat);
        entityfx.setColor(finalBright, finalBright, finalBright);
        if (debug) {
            if (this.levelTemperature < 0.0f) {
                entityfx.setColor(0.0f, 0.0f, finalBright);
            } else if (this.levelTemperature > 0.0f) {
                entityfx.setColor(finalBright, 0.0f, 0.0f);
            }
        }
        entityfx.setTicksFadeInMax(20.0f);
        entityfx.setTicksFadeOutMax(20.0f);
        entityfx.setTicksFadeOutMaxOnDeath(20.0f);
        entityfx.setUseDynamicWindSpeed(false);
        if (ConfigParticle.Particle_effect_rate != 0.0) {
            entityfx.spawnAsWeatherEffect();
            this.particleBehaviorFog.particles.add(entityfx);
        }
        return entityfx;
    }

    @Override
    public void cleanup() {
        if (this.tornadoHelper != null) {
            if (this.levelCurIntensityStage >= STATE_FORMING) {
                this.featherFallAllNearbyPlayers();
            }
            this.tornadoHelper.cleanup();
        }
        super.cleanup();
        this.tornadoHelper = null;
        if (this.tornadoFunnelSimple != null) {
            this.tornadoFunnelSimple.cleanup();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void cleanupClient() {
        super.cleanupClient();
        this.listParticlesCloud.clear();
        this.listParticlesFunnel.clear();
        if (this.particleBehaviorFog != null && this.particleBehaviorFog.particles != null) {
            this.particleBehaviorFog.particles.clear();
        }
        this.particleBehaviorFog = null;
        this.tornadoHelper = null;
        if (this.tornadoFunnelSimple != null) {
            this.tornadoFunnelSimple.cleanupClient();
        }
    }

    public static float getTemperatureMCToWeatherSys(float parOrigVal) {
        if (parOrigVal > 0.0f) {
            return 1.0f;
        }
        return -1.0f;
    }

    public void addWeatherEffectLightning(LightningBoltWeatherNew parEnt, boolean custom) {
        this.manager.getWorld().addFreshEntity((Entity)parEnt);
        ((WeatherManagerServer)this.manager).syncLightningNew(parEnt, custom);
    }

    @Override
    public int getUpdateRateForNetwork() {
        if (this.levelCurIntensityStage >= STATE_HIGHWIND) {
            return 2;
        }
        return super.getUpdateRateForNetwork();
    }

    public Vec3 getPosTop() {
        if (this.isTornadoFormingOrGreater()) {
            return this.tornadoFunnelSimple.getPosTop();
        }
        return this.pos;
    }

    public void setupStorm(Entity entity) {
        if (entity != null) {
            this.spawnerUUID = entity.getUUID().toString();
            this.initPositions(entity.position());
        }
        this.layer = 0;
        this.naturallySpawned = false;
        this.levelTemperature = 0.1f;
        this.levelWater = this.levelWaterStartRaining * 2;
        this.attrib_precipitation = true;
        this.levelCurIntensityStage = STATE_STAGE1;
        this.alwaysProgresses = false;
        this.initFirstTime();
        this.levelStormIntensityMax = this.levelCurIntensityStage;
    }

    public void initPositions(Vec3 pos) {
        this.pos = pos;
        this.currentTopYBlock = this.calculateTopYBlock();
        this.posGround = new Vec3(pos.x, (double)this.currentTopYBlock, pos.z);
        this.posBaseFormationPos = this.calculateBaseFormationPos();
    }

    public int calculateTopYBlock() {
        Player entP;
        Player player;
        Level world = this.manager.getWorld();
        int calculatedYPos = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(Mth.floor((double)this.pos.x), 0, Mth.floor((double)this.pos.z)), Heightmap.Types.WORLD_SURFACE_WG).getY();
        boolean filterOutLogs = true;
        if (filterOutLogs && world.hasChunkAt(CoroUtilBlock.blockPos((Vec3)this.pos))) {
            int y = calculatedYPos - 1;
            BlockState state = world.getBlockState(CoroUtilBlock.blockPos((double)this.pos.x, (double)y, (double)this.pos.z));
            int iter = 0;
            while ((state.is(BlockTags.LOGS) || state.is(BlockTags.LEAVES) || state.is(BlockTags.CAVE_VINES) || state.is(BlockTags.REPLACEABLE_BY_TREES) || state.is(Blocks.COCOA) || state.is(Blocks.BAMBOO) || state.isAir()) && y > world.getMinBuildHeight()) {
                state = world.getBlockState(CoroUtilBlock.blockPos((double)this.pos.x, (double)(--y), (double)this.pos.z));
                ++iter;
            }
            if (y > world.getMinBuildHeight()) {
                calculatedYPos = y;
            }
        }
        if (Weather.isLoveTropicsInstalled()) {
            while (world.getBlockState(CoroUtilBlock.blockPos((double)this.pos.x, (double)calculatedYPos, (double)this.pos.z)).getBlock() instanceof LiquidBlock && calculatedYPos < world.getMaxBuildHeight()) {
                ++calculatedYPos;
            }
        }
        if (this.isBaby() && (player = this.getPlayer()) != null) {
            calculatedYPos = (int)player.position().y;
        }
        if (this.isPet() && (entP = this.getPlayer()) != null && entP.position().distanceTo(this.posGround) < 10.0 && (double)(calculatedYPos + 4) > entP.position().y) {
            int y = (int)(entP.position().y + 2.0);
            while ((double)y > entP.position().y - 3.0) {
                BlockPos blockPos = CoroUtilBlock.blockPos((double)this.pos.x, (double)y, (double)this.pos.z);
                BlockPos blockPosUp = CoroUtilBlock.blockPos((double)this.pos.x, (double)(y + 1), (double)this.pos.z);
                BlockState state = world.getBlockState(blockPos);
                BlockState stateUp = world.getBlockState(blockPosUp);
                if (!state.isAir() && state.getCollisionShape((BlockGetter)world, blockPosUp) != Shapes.empty() && (stateUp.isAir() || stateUp.getCollisionShape((BlockGetter)world, blockPosUp) == Shapes.empty())) {
                    calculatedYPos = y + 1;
                    break;
                }
                --y;
            }
        }
        return calculatedYPos;
    }

    public void setupTornadoAwayFromPlayersAimAtPlayers() {
        List players = this.manager.getWorld().players();
        ArrayList playersNear = new ArrayList();
        double xAdd = 0.0;
        double yAdd = 0.0;
        double zAdd = 0.0;
        Vec3 vecAdd = new Vec3(0.0, 0.0, 0.0);
        for (Player player : players) {
            vecAdd = vecAdd.add(player.position());
        }
        vecAdd = new Vec3(vecAdd.x / (double)players.size(), vecAdd.y / (double)players.size(), vecAdd.z / (double)players.size());
        this.initPositions(vecAdd.add(150.0, 0.0, 150.0));
        this.aimAtCoords(vecAdd);
    }

    public void setupPlayerControlledTornado(Entity entity) {
        this.playerControlled = true;
    }

    public Player getPlayer() {
        if (this.spawnerUUID.equals("")) {
            return null;
        }
        return this.manager.getWorld().getPlayerByUUID(UUID.fromString(this.spawnerUUID));
    }

    public boolean isPlayerControlled() {
        return this.playerControlled;
    }

    public void setPlayerControlled(boolean playerControlled) {
        this.playerControlled = playerControlled;
    }

    public int getPlayerControlledTimeLeft() {
        return this.playerControlledTimeLeft;
    }

    public void setPlayerControlledTimeLeft(int playerControlledTimeLeft) {
        this.playerControlledTimeLeft = playerControlledTimeLeft;
    }

    public boolean isBaby() {
        return this.baby;
    }

    public void setBaby(boolean baby) {
        this.baby = baby;
    }

    public boolean isPet() {
        return this.pet;
    }

    public void setPet(boolean pet) {
        this.pet = pet;
    }

    public boolean isPetGrabsItems() {
        return this.petGrabsItems;
    }

    public void setPetGrabsItems(boolean petGrabsItems) {
        this.petGrabsItems = petGrabsItems;
    }

    public boolean isSharknado() {
        return this.sharknado;
    }

    public void setSharknado(boolean sharknado) {
        this.sharknado = sharknado;
    }

    public void setAndUpdateTornado() {
        if (this.tornadoFunnelSimple == null) {
            this.setupTornado();
        }
        this.tornadoFunnelSimple.pos = new Vec3(this.posGround.x, this.posBaseFormationPos.y, this.posGround.z);
    }

    public TornadoFunnelSimple getTornadoFunnelSimple() {
        return this.tornadoFunnelSimple;
    }

    public void setTornadoFunnelSimple(TornadoFunnelSimple tornadoFunnelSimple) {
        this.tornadoFunnelSimple = tornadoFunnelSimple;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getAgeSinceTornadoTouchdown() {
        return this.ageSinceTornadoTouchdown;
    }

    public void setAgeSinceTornadoTouchdown(int ageSinceTornadoTouchdown) {
        this.ageSinceTornadoTouchdown = ageSinceTornadoTouchdown;
    }

    public boolean isBeingDeflectedCached() {
        return this.isBeingDeflectedCached;
    }

    public void setBeingDeflectedCached(boolean beingDeflectedCached) {
        this.isBeingDeflectedCached = beingDeflectedCached;
    }
}

