/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilMisc;
import extendedrenderer.particle.entity.ParticleCube;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import weather2.ClientTickHandler;
import weather2.Weather;
import weather2.client.SceneEnhancer;
import weather2.config.ConfigParticle;
import weather2.weathersystem.WeatherManager;
import weather2.weathersystem.storm.EnumWeatherObjectType;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;

@OnlyIn(value=Dist.CLIENT)
public class WeatherManagerClient
extends WeatherManager {
    public WeatherManagerClient(ResourceKey<Level> dimension) {
        super(dimension);
    }

    @Override
    public void tick() {
        boolean cloudTest;
        super.tick();
        if (Weather.isLoveTropicsInstalled() || (cloudTest = false)) {
            // empty if block
        }
    }

    @Override
    public Level getWorld() {
        return Minecraft.getInstance().level;
    }

    public void nbtSyncFromServer(CompoundTag parNBT) {
        String command = parNBT.getString("command");
        if (command.equals("syncStormNew")) {
            CULog.dbg((String)("nbtSyncFromServer: " + String.valueOf(parNBT)));
            CompoundTag stormNBT = parNBT.getCompound("data");
            long ID = stormNBT.getLong("ID");
            Weather.dbg("syncStormNewsss, ID: " + ID);
            String dimID = stormNBT.getString("dimID");
            EnumWeatherObjectType weatherObjectType = EnumWeatherObjectType.get(stormNBT.getInt("weatherObjectType"));
            WeatherObject wo = null;
            if (weatherObjectType == EnumWeatherObjectType.CLOUD) {
                wo = new StormObject(ClientTickHandler.weatherManager);
            } else if (weatherObjectType == EnumWeatherObjectType.SAND) {
                wo = new WeatherObjectParticleStorm(ClientTickHandler.weatherManager);
                ((WeatherObjectParticleStorm)wo).setType(WeatherObjectParticleStorm.StormType.SANDSTORM);
            } else if (weatherObjectType == EnumWeatherObjectType.SNOW) {
                wo = new WeatherObjectParticleStorm(ClientTickHandler.weatherManager);
                ((WeatherObjectParticleStorm)wo).setType(WeatherObjectParticleStorm.StormType.SNOWSTORM);
            }
            wo.getNbtCache().setNewNBT(stormNBT);
            wo.nbtSyncFromServer();
            wo.getNbtCache().updateCacheFromNew();
            this.addStormObject(wo);
        } else if (command.equals("syncStormRemove")) {
            CompoundTag stormNBT = parNBT.getCompound("data");
            long ID = stormNBT.getLong("ID");
            WeatherObject so = (WeatherObject)this.lookupStormObjectsByID.get(ID);
            if (so != null) {
                Weather.dbg("syncStormRemove, ID: " + ID);
                this.removeStormObject(ID);
            } else {
                Weather.dbg("error removing storm, cant find by ID: " + ID);
            }
        } else if (command.equals("syncStormUpdate")) {
            CompoundTag stormNBT = parNBT.getCompound("data");
            long ID = stormNBT.getLong("ID");
            WeatherObject so = (WeatherObject)this.lookupStormObjectsByID.get(ID);
            if (so != null) {
                so.getNbtCache().setNewNBT(stormNBT);
                so.nbtSyncFromServer();
                so.getNbtCache().updateCacheFromNew();
            } else {
                Weather.dbg("error syncing storm, cant find by ID: " + ID + ", probably due to client resetting and waiting on full resync (this is ok)");
            }
        } else if (command.equals("syncWindUpdate")) {
            CompoundTag nbt = parNBT.getCompound("data");
            this.getWindManager().nbtSyncFromServer(nbt);
        } else if (command.equals("syncWeatherUpdate")) {
            this.isVanillaRainActiveOnServer = parNBT.getBoolean("isVanillaRainActiveOnServer");
            this.isVanillaThunderActiveOnServer = parNBT.getBoolean("isVanillaThunderActiveOnServer");
            this.vanillaRainTimeOnServer = parNBT.getInt("vanillaRainTimeOnServer");
            this.vanillaRainAmountOnServer = parNBT.getFloat("vanillaRainAmountOnServer");
        } else if (command.equals("syncBlockParticleNew")) {
            CompoundTag nbt = parNBT.getCompound("data");
            int posX = nbt.getInt("posX");
            int posY = nbt.getInt("posY") + 1;
            int posZ = nbt.getInt("posZ");
            BlockState state = NbtUtils.readBlockState((HolderGetter)this.getWorld().holderLookup(Registries.BLOCK), (CompoundTag)nbt.getCompound("blockstate"));
            long ownerID = nbt.getLong("ownerID");
            StormObject storm = this.getStormObjectByID(ownerID);
            if (storm != null && ConfigParticle.Particle_effect_rate > 0.0) {
                int extraCubes = (int)(1.0 + (double)ConfigParticle.Particle_Tornado_extraParticleCubes * ConfigParticle.Particle_effect_rate);
                Random rand = CoroUtilMisc.random();
                float randRange = 3.0f;
                for (int i = 0; i < extraCubes; ++i) {
                    ParticleCube hail = new ParticleCube(this.getWorld(), (double)((float)posX + (rand.nextFloat() - rand.nextFloat()) * randRange), (double)((float)posY + (rand.nextFloat() - rand.nextFloat()) * randRange), (double)((float)posZ + (rand.nextFloat() - rand.nextFloat()) * randRange), 0.0, 0.0, 0.0, state);
                    SceneEnhancer.checkParticleBehavior();
                    SceneEnhancer.particleBehavior.initParticleCube(hail);
                    storm.listParticlesDebris.add(hail);
                    hail.spawnAsWeatherEffect();
                }
            }
        }
    }
}

