/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import weather2.ClientTickHandler;
import weather2.ServerTickHandler;
import weather2.weathersystem.WeatherManager;

public class WindReader {
    public static float getWindAngle(Level world) {
        return WindReader.getWindAngle(world, null);
    }

    public static float getWindAngle(Level world, Vec3 pos) {
        WeatherManager weather = WindReader.getWeatherManagerFor(world);
        return weather != null ? weather.getWindManager().getWindAngle(pos) : 0.0f;
    }

    public static float getWindSpeed(Level world) {
        return WindReader.getWindSpeed(world, null);
    }

    public static float getWindSpeed(Level world, @Nullable BlockPos pos) {
        return WindReader.getWindSpeed(world, pos, 1.0f);
    }

    public static float getWindSpeed(Level world, @Nullable BlockPos pos, float extraHeightAmpMax) {
        WeatherManager weather = WindReader.getWeatherManagerFor(world);
        return weather != null ? weather.getWindManager().getWindSpeed(pos, extraHeightAmpMax) : 0.0f;
    }

    public static float getWindSpeedCached(Level world, @Nullable BlockPos pos, float extraHeightAmpMax) {
        WeatherManager weather = WindReader.getWeatherManagerFor(world);
        return weather != null ? weather.getWindManager().getCachedWindSpeedForHeight(pos, extraHeightAmpMax) : 0.0f;
    }

    public static WeatherManager getWeatherManagerFor(Level world) {
        if (world.isClientSide) {
            return WindReader.getWeatherManagerClient();
        }
        return ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)world.dimension());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static WeatherManager getWeatherManagerClient() {
        return ClientTickHandler.weatherManager;
    }
}

