/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import com.corosus.coroutil.util.CoroUtilEntOrParticle;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilParticle;

public class WeatherUtilEntity {
    public static HashMap<Item, Float> armorToWeight = new HashMap();

    public static float getWeight(Object entity1, boolean forTornado) {
        float var;
        Level world = CoroUtilEntOrParticle.getWorld((Object)entity1);
        if (world == null) {
            return 1.0f;
        }
        if (WeatherUtilEntity.isParticleRotServerSafe(world, entity1) && (var = WeatherUtilParticle.getParticleWeight((EntityRotFX)entity1)) != -1.0f) {
            return var;
        }
        if (entity1 instanceof Squid) {
            return 400.0f;
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEnt = (LivingEntity)entity1;
            int airTime = livingEnt.getPersistentData().getInt("timeInAir");
            airTime = livingEnt.onGround() || livingEnt.isInWater() ? 0 : ++airTime;
            livingEnt.getPersistentData().putInt("timeInAir", airTime);
            if (entity1 instanceof Player) {
                if (((Player)entity1).abilities.instabuild) {
                    return 1.0E8f;
                }
                return 5.0f + (float)airTime / 400.0f;
            }
            return 500.0f + (livingEnt.onGround() ? 2.0f : 0.0f) + (float)airTime / 400.0f;
        }
        if (entity1 instanceof Boat || entity1 instanceof ItemEntity || entity1 instanceof FishingHook) {
            return 4000.0f;
        }
        if (entity1 instanceof AbstractMinecart) {
            return 80.0f;
        }
        return 1.0f;
    }

    public static float getWeightAdjFromEquipment(float weightIn, Player player) {
        float influence = 1.2f;
        for (ItemStack stack : player.getArmorSlots()) {
            if (!armorToWeight.containsKey(stack.getItem())) continue;
            weightIn += armorToWeight.get(stack.getItem()).floatValue() * influence;
        }
        return weightIn;
    }

    public static float getWeight(Object entity1) {
        float var;
        Level world = CoroUtilEntOrParticle.getWorld((Object)entity1);
        if (world == null) {
            return 1.0f;
        }
        if (WeatherUtilEntity.isParticleRotServerSafe(world, entity1) && (var = WeatherUtilParticle.getParticleWeight((EntityRotFX)entity1)) != -1.0f) {
            return var;
        }
        if (entity1 instanceof Squid) {
            return 400.0f;
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingEnt = (LivingEntity)entity1;
            int airTime = livingEnt.getPersistentData().getInt("timeInAir");
            airTime = livingEnt.onGround() || livingEnt.isInWater() ? 0 : ++airTime;
            livingEnt.getPersistentData().putInt("timeInAir", airTime);
            if (entity1 instanceof Player) {
                if (((Player)entity1).abilities.instabuild) {
                    return 1.0E8f;
                }
                return 5.0f + (float)airTime / 400.0f;
            }
            return 500.0f + (livingEnt.onGround() ? 2.0f : 0.0f) + (float)airTime / 400.0f;
        }
        if (entity1 instanceof Boat || entity1 instanceof ItemEntity || entity1 instanceof FishingHook) {
            return 4000.0f;
        }
        if (entity1 instanceof AbstractMinecart) {
            return 80.0f;
        }
        return 1.0f;
    }

    public static boolean isParticleRotServerSafe(Level world, Object obj) {
        if (EffectiveSide.get().equals((Object)LogicalSide.SERVER)) {
            return false;
        }
        if (!world.isClientSide) {
            return false;
        }
        return WeatherUtilEntity.isParticleRotClientCheck(obj);
    }

    public static boolean isParticleRotClientCheck(Object obj) {
        return obj instanceof EntityRotFX;
    }

    public static double getDistanceSqEntToPos(Entity ent, BlockPos pos) {
        return ent.position().distanceToSqr(Vec3.atCenterOf((Vec3i)pos));
    }

    public static boolean isEntityOutside(Entity parEnt) {
        return WeatherUtilEntity.isEntityOutside(parEnt, false);
    }

    public static boolean isEntityOutside(Entity parEnt, boolean cheapCheck) {
        return WeatherUtilEntity.isPosOutside(parEnt.level(), parEnt.position(), cheapCheck, false);
    }

    public static boolean isPosOutside(Level parWorld, Vec3 parPos) {
        return WeatherUtilEntity.isPosOutside(parWorld, parPos, false, false);
    }

    public static boolean isPosOutside(Level parWorld, Vec3 parPos, boolean cheapCheck, boolean eachSideClearCheck) {
        int height = WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(Mth.floor((double)parPos.x), 0, Mth.floor((double)parPos.z))).getY();
        if ((double)height < parPos.y + 1.0) {
            return true;
        }
        if (cheapCheck) {
            return false;
        }
        int rangeCheck = 5;
        boolean yOffset = false;
        int xzInitialOffset = 1;
        boolean nsCheck = false;
        Vec3 vecTry = new Vec3(parPos.x + (double)(Direction.NORTH.getStepX() * rangeCheck), parPos.y + (double)yOffset, parPos.z + (double)(Direction.NORTH.getStepZ() * rangeCheck));
        Vec3 parPosTry = new Vec3(parPos.x + (double)(Direction.NORTH.getStepX() * xzInitialOffset), parPos.y + (double)yOffset, parPos.z + (double)(Direction.NORTH.getStepZ() * xzInitialOffset));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPosTry, vecTry)) {
            if (eachSideClearCheck) {
                nsCheck = true;
            } else {
                return true;
            }
        }
        vecTry = new Vec3(parPos.x + (double)(Direction.SOUTH.getStepX() * rangeCheck), parPos.y + (double)yOffset, parPos.z + (double)(Direction.SOUTH.getStepZ() * rangeCheck));
        parPosTry = new Vec3(parPos.x + (double)(Direction.SOUTH.getStepX() * xzInitialOffset), parPos.y + (double)yOffset, parPos.z + (double)(Direction.SOUTH.getStepZ() * xzInitialOffset));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPosTry, vecTry)) {
            if (eachSideClearCheck) {
                return nsCheck;
            }
            return true;
        }
        nsCheck = false;
        vecTry = new Vec3(parPos.x + (double)(Direction.EAST.getStepX() * rangeCheck), parPos.y + (double)yOffset, parPos.z + (double)(Direction.EAST.getStepZ() * rangeCheck));
        parPosTry = new Vec3(parPos.x + (double)(Direction.EAST.getStepX() * xzInitialOffset), parPos.y + (double)yOffset, parPos.z + (double)(Direction.EAST.getStepZ() * xzInitialOffset));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPosTry, vecTry)) {
            if (eachSideClearCheck) {
                nsCheck = true;
            } else {
                return true;
            }
        }
        vecTry = new Vec3(parPos.x + (double)(Direction.WEST.getStepX() * rangeCheck), parPos.y + (double)yOffset, parPos.z + (double)(Direction.WEST.getStepZ() * rangeCheck));
        parPosTry = new Vec3(parPos.x + (double)(Direction.WEST.getStepX() * xzInitialOffset), parPos.y + (double)yOffset, parPos.z + (double)(Direction.WEST.getStepZ() * xzInitialOffset));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPosTry, vecTry)) {
            if (eachSideClearCheck) {
                return nsCheck;
            }
            return true;
        }
        return false;
    }

    public static boolean checkVecOutside(Level parWorld, Vec3 parPos, Vec3 parCheckPos) {
        int height;
        BlockHitResult blockhitresult = parWorld.clip(new ClipContext(parPos, parCheckPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return blockhitresult.getType() == HitResult.Type.MISS && (double)(height = WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(Mth.floor((double)parCheckPos.x), 0, Mth.floor((double)parCheckPos.z))).getY()) < parCheckPos.y;
    }

    public static boolean isPlayerSheltered(Entity player) {
        int x = Mth.floor((double)player.getX());
        int y = Mth.floor((double)(player.getY() + (double)player.getEyeHeight()));
        int z = Mth.floor((double)player.getZ());
        return player.level().getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) > y;
    }

    public static boolean canPosSeePos(Level level, Vec3 pos1, Vec3 pos2) {
        Vec3 vec3 = new Vec3(pos1.x(), pos1.y(), pos1.z());
        Vec3 vec31 = new Vec3(pos2.x(), pos2.y(), pos2.z());
        if (vec31.distanceTo(vec3) > 128.0) {
            return false;
        }
        return level.clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty())).getType() == HitResult.Type.MISS;
    }

    static {
        armorToWeight.put(Items.IRON_HELMET, Float.valueOf(0.1f));
        armorToWeight.put(Items.IRON_CHESTPLATE, Float.valueOf(0.2f));
        armorToWeight.put(Items.IRON_LEGGINGS, Float.valueOf(0.15f));
        armorToWeight.put(Items.IRON_BOOTS, Float.valueOf(0.1f));
        armorToWeight.put(Items.GOLDEN_HELMET, Float.valueOf(0.1f));
        armorToWeight.put(Items.GOLDEN_CHESTPLATE, Float.valueOf(0.2f));
        armorToWeight.put(Items.GOLDEN_LEGGINGS, Float.valueOf(0.15f));
        armorToWeight.put(Items.GOLDEN_BOOTS, Float.valueOf(0.1f));
        armorToWeight.put(Items.DIAMOND_HELMET, Float.valueOf(0.1f));
        armorToWeight.put(Items.DIAMOND_CHESTPLATE, Float.valueOf(0.2f));
        armorToWeight.put(Items.DIAMOND_LEGGINGS, Float.valueOf(0.15f));
        armorToWeight.put(Items.DIAMOND_BOOTS, Float.valueOf(0.1f));
    }
}

