/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WeatherUtilDim {
    public static boolean canBlockSeeSky(Level world, BlockPos pos) {
        if (pos.getY() >= WeatherUtilDim.getSeaLevel(world)) {
            return world.canSeeSkyFromBelowWater(pos);
        }
        BlockPos blockpos = new BlockPos(pos.getX(), WeatherUtilDim.getSeaLevel(world), pos.getZ());
        if (!world.canSeeSkyFromBelowWater(blockpos)) {
            return false;
        }
        BlockPos blockpos1 = blockpos.below();
        while (blockpos1.getY() > pos.getY()) {
            BlockState blockstate = world.getBlockState(blockpos1);
            if (blockstate.getLightBlock((BlockGetter)world, blockpos1) > 0 && !blockstate.liquid()) {
                return false;
            }
            blockpos1 = blockpos1.below();
        }
        return true;
    }

    public static int getSeaLevel(Level world) {
        return 63;
    }
}

