/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import com.corosus.coroutil.util.CoroUtilBlock;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import weather2.WeatherBlocks;
import weather2.block.SandLayerBlock;

public class WeatherUtilBlock {
    public static int layerableHeightPropMax = 8;

    public static void fillAgainstWallSmoothly(Level world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable, int maxBlockStackingAllowed) {
        WeatherUtilBlock.fillAgainstWallSmoothly(world, posSource, directionYaw, scanDistance, fillRadius, blockLayerable, 4, maxBlockStackingAllowed);
    }

    public static void fillAgainstWallSmoothly(Level world, Vec3 posSource, float directionYaw, float scanDistance, float fillRadius, Block blockLayerable, int heightDiff, int maxBlockStackingAllowed) {
        int heightTest;
        BlockState stateTest = world.getBlockState(CoroUtilBlock.blockPos((Vec3)posSource));
        if (stateTest.getBlock() != blockLayerable || (heightTest = WeatherUtilBlock.getHeightForAnyBlock(stateTest)) < 8) {
            // empty if block
        }
        BlockPos posSourcei = CoroUtilBlock.blockPos((Vec3)posSource);
        int y = posSourcei.getY();
        float tickStep = 0.75f;
        Vec3 posLastNonWall = new Vec3(posSource.x, posSource.y, posSource.z);
        Vec3 posWall = null;
        BlockPos lastScannedPosXZ = null;
        int previousBlockHeight = 0;
        for (float i = 0.0f; i < scanDistance; i += tickStep) {
            double vecX = -Math.sin(Math.toRadians(directionYaw)) * (double)i;
            double vecZ = Math.cos(Math.toRadians(directionYaw)) * (double)i;
            int x = Mth.floor((double)(posSource.x + vecX));
            int z = Mth.floor((double)(posSource.z + vecZ));
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos posXZ = new BlockPos(x, 0, z);
            BlockState state = world.getBlockState(pos);
            if (lastScannedPosXZ != null && posXZ.equals(lastScannedPosXZ)) continue;
            lastScannedPosXZ = new BlockPos((Vec3i)posXZ);
            AABB aabbCompare = new AABB(pos);
            ArrayList listAABBCollision = new ArrayList();
            VoxelShape voxelshape = Shapes.create((AABB)aabbCompare);
            boolean collided = Shapes.joinIsNotEmpty((VoxelShape)state.getCollisionShape((BlockGetter)world, pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.AND);
            if (!state.isAir() && state.getBlock().defaultMapColor() != MapColor.PLANT && collided) {
                BlockPos posUp = new BlockPos(x, y + 1, z);
                BlockState stateUp = world.getBlockState(posUp);
                if (stateUp.isAir()) {
                    int height = WeatherUtilBlock.getHeightForAnyBlock(state);
                    if (height - previousBlockHeight <= heightDiff) {
                        if (height == 8) {
                            previousBlockHeight = 0;
                            ++y;
                        } else {
                            previousBlockHeight = height;
                        }
                        posLastNonWall = new Vec3(posSource.x + vecX, (double)y, posSource.z + vecZ);
                        continue;
                    }
                    posWall = new Vec3(posSource.x + vecX, (double)y, posSource.z + vecZ);
                    break;
                }
                posWall = new Vec3(posSource.x + vecX, (double)y, posSource.z + vecZ);
                break;
            }
            posLastNonWall = new Vec3(posSource.x + vecX, (double)y, posSource.z + vecZ);
        }
        if (posWall != null) {
            int amountWeHave = 1;
            int amountToAddPerXZ = 1;
            BlockState state = world.getBlockState(CoroUtilBlock.blockPos(posWall));
            BlockState state1 = world.getBlockState(CoroUtilBlock.blockPos((Vec3)posLastNonWall).offset(1, 0, 0));
            BlockState state22 = world.getBlockState(CoroUtilBlock.blockPos((Vec3)posLastNonWall).offset(-1, 0, 0));
            BlockState state3 = world.getBlockState(CoroUtilBlock.blockPos((Vec3)posLastNonWall).offset(0, 0, 1));
            BlockState state4 = world.getBlockState(CoroUtilBlock.blockPos((Vec3)posLastNonWall).offset(0, 0, -1));
            if (state.getBlock() == Blocks.CACTUS || state1.getBlock() == Blocks.CACTUS || state22.getBlock() == Blocks.CACTUS || state3.getBlock() == Blocks.CACTUS || state4.getBlock() == Blocks.CACTUS) {
                return;
            }
            BlockPos pos2 = CoroUtilBlock.blockPos((double)posLastNonWall.x, (double)posLastNonWall.y, (double)posLastNonWall.z);
            BlockState state2 = world.getBlockState(pos2);
            if (state2.getBlock().defaultMapColor() == MapColor.WATER || state2.getBlock().defaultMapColor() == MapColor.FIRE) {
                return;
            }
            amountWeHave = WeatherUtilBlock.trySpreadOnPos2(world, CoroUtilBlock.blockPos((double)posLastNonWall.x, (double)posLastNonWall.y, (double)posLastNonWall.z), amountWeHave, amountToAddPerXZ, 10, blockLayerable, maxBlockStackingAllowed);
        }
    }

    public static int trySpreadOnPos2(Level world, BlockPos posSpreadTo, int amount, int amountAllowedToAdd, int maxDropAllowed, Block blockLayerable, int maxBlockStackingAllowed) {
        int distForPlaceableBlocks;
        if (amount <= 0) {
            return amount;
        }
        if (!world.getBlockState(posSpreadTo.offset(0, 1, 0)).isAir()) {
            return amount;
        }
        BlockState statePos = world.getBlockState(posSpreadTo);
        BlockPos posCheckNonAir = new BlockPos((Vec3i)posSpreadTo);
        BlockState stateCheckNonAir = world.getBlockState(posCheckNonAir);
        int depth = 0;
        while (stateCheckNonAir.isAir()) {
            posCheckNonAir = posCheckNonAir.offset(0, -1, 0);
            stateCheckNonAir = world.getBlockState(posCheckNonAir);
            if (++depth <= maxDropAllowed) continue;
            return amount;
        }
        BlockPos posCheckPlaceable = new BlockPos((Vec3i)posCheckNonAir);
        BlockState stateCheckPlaceable = world.getBlockState(posCheckPlaceable);
        if (maxBlockStackingAllowed > 0) {
            boolean sandMode = false;
            if (blockLayerable == Blocks.SNOW) {
                sandMode = false;
            } else if (blockLayerable == WeatherBlocks.BLOCK_SAND_LAYER.get()) {
                sandMode = true;
            }
            int foundBlocks = 0;
            BlockPos posCheckDownForStacks = new BlockPos((Vec3i)posCheckPlaceable);
            BlockState stateCheckDownForStacks = world.getBlockState(posCheckPlaceable);
            if (!sandMode && stateCheckPlaceable.getBlock() == Blocks.SNOW_BLOCK || sandMode && stateCheckPlaceable.getBlock() == Blocks.SAND) {
                while (!sandMode && stateCheckDownForStacks.getBlock() == Blocks.SNOW_BLOCK || sandMode && stateCheckDownForStacks.getBlock() == Blocks.SAND) {
                    if (++foundBlocks >= maxBlockStackingAllowed) {
                        return amount;
                    }
                    posCheckDownForStacks = posCheckDownForStacks.offset(0, -1, 0);
                    stateCheckDownForStacks = world.getBlockState(posCheckDownForStacks);
                }
            }
        }
        for (distForPlaceableBlocks = 0; distForPlaceableBlocks < 10; ++distForPlaceableBlocks) {
            AABB aabbCompare = new AABB(posCheckPlaceable);
            VoxelShape voxelshape = Shapes.create((AABB)aabbCompare);
            boolean collided = Shapes.joinIsNotEmpty((VoxelShape)stateCheckPlaceable.getCollisionShape((BlockGetter)world, posCheckPlaceable).move((double)posCheckPlaceable.getX(), (double)posCheckPlaceable.getY(), (double)posCheckPlaceable.getZ()), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.AND);
            if (stateCheckPlaceable.getBlock() != blockLayerable && !collided && !stateCheckPlaceable.liquid()) {
                posCheckPlaceable = posCheckPlaceable.offset(0, -1, 0);
                stateCheckPlaceable = world.getBlockState(posCheckPlaceable);
                continue;
            }
            if (stateCheckPlaceable.isFaceSturdy((BlockGetter)world, posCheckPlaceable, Direction.UP) || stateCheckPlaceable.getBlock() == blockLayerable) break;
            return amount;
        }
        if (distForPlaceableBlocks >= 10) {
            return amount;
        }
        if (!stateCheckPlaceable.isFaceSturdy((BlockGetter)world, posCheckPlaceable, Direction.UP) && stateCheckPlaceable.getBlock() != blockLayerable) {
            System.out.println("shouldnt be, failed a check somewhere!");
            return amount;
        }
        for (int i = 0; i < distForPlaceableBlocks; ++i) {
            world.setBlockAndUpdate(posCheckNonAir.offset(0, -i, 0), Blocks.AIR.defaultBlockState());
        }
        BlockPos posPlaceLayerable = new BlockPos((Vec3i)posCheckPlaceable);
        BlockState statePlaceLayerable = world.getBlockState(posPlaceLayerable);
        int amountToAdd = amountAllowedToAdd;
        while (amountAllowedToAdd > 0 && world.getBlockState(posPlaceLayerable.offset(0, 1, 0)).isAir() && amountAllowedToAdd > 0) {
            int height;
            if (statePlaceLayerable.getBlock() == blockLayerable && WeatherUtilBlock.getHeightForLayeredBlock(statePlaceLayerable) < layerableHeightPropMax) {
                height = WeatherUtilBlock.getHeightForLayeredBlock(statePlaceLayerable);
                if ((height += amountAllowedToAdd) > layerableHeightPropMax) {
                    amountAllowedToAdd = height - layerableHeightPropMax;
                    height = layerableHeightPropMax;
                } else {
                    amountAllowedToAdd = 0;
                }
                try {
                    world.setBlockAndUpdate(posPlaceLayerable, WeatherUtilBlock.setBlockWithLayerState(blockLayerable, height));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (height != layerableHeightPropMax) continue;
                posPlaceLayerable = posPlaceLayerable.offset(0, 1, 0);
                statePlaceLayerable = world.getBlockState(posPlaceLayerable);
                continue;
            }
            if (statePlaceLayerable.isFaceSturdy((BlockGetter)world, posPlaceLayerable, Direction.UP)) {
                posPlaceLayerable = posPlaceLayerable.offset(0, 1, 0);
                statePlaceLayerable = world.getBlockState(posPlaceLayerable);
                continue;
            }
            if (!statePlaceLayerable.isAir()) continue;
            height = amountAllowedToAdd;
            if (height > layerableHeightPropMax) {
                amountAllowedToAdd = height - layerableHeightPropMax;
                height = layerableHeightPropMax;
            } else {
                amountAllowedToAdd = 0;
            }
            try {
                world.setBlockAndUpdate(posPlaceLayerable, WeatherUtilBlock.setBlockWithLayerState(blockLayerable, height));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (height != layerableHeightPropMax) continue;
            posPlaceLayerable = posPlaceLayerable.offset(0, 1, 0);
            statePlaceLayerable = world.getBlockState(posPlaceLayerable);
        }
        if (amountAllowedToAdd < 0) {
            // empty if block
        }
        int amountAdded = amountToAdd - amountAllowedToAdd;
        return amount -= amountAdded;
    }

    public static int getHeightForAnyBlock(BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.SNOW) {
            return (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
        }
        if (block == WeatherBlocks.BLOCK_SAND_LAYER.get()) {
            return (Integer)state.getValue((Property)SandLayerBlock.LAYERS);
        }
        if (block == Blocks.SAND || block == Blocks.SNOW_BLOCK) {
            return 8;
        }
        if (block instanceof SlabBlock) {
            return 4;
        }
        if (block == Blocks.AIR) {
            return 0;
        }
        return 8;
    }

    public static int getHeightForLayeredBlock(BlockState state) {
        if (state.getBlock() == Blocks.SNOW) {
            return (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
        }
        if (state.getBlock() == WeatherBlocks.BLOCK_SAND_LAYER.get()) {
            return (Integer)state.getValue((Property)SandLayerBlock.LAYERS);
        }
        if (state.getBlock() == Blocks.SAND || state.getBlock() == Blocks.SNOW_BLOCK) {
            return 8;
        }
        return 0;
    }

    public static BlockState setBlockWithLayerState(Block block, int height) {
        boolean solidBlockUnderMode = true;
        if (block == Blocks.SNOW) {
            if (height == layerableHeightPropMax && solidBlockUnderMode) {
                return Blocks.SNOW_BLOCK.defaultBlockState();
            }
            return (BlockState)block.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(height));
        }
        if (block == WeatherBlocks.BLOCK_SAND_LAYER.get()) {
            if (height == layerableHeightPropMax && solidBlockUnderMode) {
                return Blocks.SAND.defaultBlockState();
            }
            return (BlockState)block.defaultBlockState().setValue((Property)SandLayerBlock.LAYERS, (Comparable)Integer.valueOf(height));
        }
        return null;
    }

    public static BlockPos getPrecipitationHeightSafe(Level world, BlockPos pos) {
        return WeatherUtilBlock.getPrecipitationHeightSafe(world, pos, Heightmap.Types.MOTION_BLOCKING);
    }

    public static BlockPos getPrecipitationHeightSafe(Level world, BlockPos pos, Heightmap.Types heightmapType) {
        if (world.hasChunkAt(pos)) {
            return world.getHeightmapPos(heightmapType, pos);
        }
        return new BlockPos(pos.getX(), -255, pos.getZ());
    }
}

