/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import com.corosus.coroutil.util.CULog;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.joml.Vector3d;
import org.joml.Vector3f;
import weather2.config.ConfigTornado;

public class WeatherUtil {
    public static HashMap<ResourceLocation, Boolean> listGrabBlockCache = new HashMap();
    public static List<String> listGrabBlocks = new ArrayList<String>();
    public static List<String> listGrabBlockTags = new ArrayList<String>();
    public static String lastConfigChecked = "";

    public static void updateGrabBlockList(String grabListStr) {
        CULog.dbg((String)"Updating weather2 tornado grab list");
        listGrabBlocks.clear();
        listGrabBlockTags.clear();
        listGrabBlockCache.clear();
        try {
            String[] splEnts;
            for (String str : splEnts = grabListStr.split(",")) {
                if ((str = str.trim()).contains("#")) {
                    listGrabBlockTags.add(WeatherUtil.addNamespaceIfMissing(str.substring(1)));
                    continue;
                }
                listGrabBlocks.add(WeatherUtil.addNamespaceIfMissing(str));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
    }

    public static void testAllBlocks() {
        lastConfigChecked = ConfigTornado.Storm_Tornado_GrabList;
        CULog.log((String)"PRINTING OUT ALL WEATHER2 TORNADO GRABBABLE BLOCKS WITH CURRENT CONFIG: ");
        BuiltInRegistries.BLOCK.forEach(block -> {
            ImmutableList list = block.getStateDefinition().getPossibleStates();
            for (BlockState state : list) {
                boolean result = WeatherUtil.canGrabViaLists(state);
                if (!result) continue;
                CULog.log((String)(String.valueOf(state) + " -> " + result));
            }
        });
    }

    public static String addNamespaceIfMissing(String str) {
        if (!((String)str).contains(":")) {
            str = "minecraft:" + (String)str;
        }
        return str;
    }

    public static boolean isStateInListOfTags(BlockState state) {
        for (String str : listGrabBlockTags) {
            TagKey<Block> key = WeatherUtil.getTagKeyFor(str);
            if (key == null || !state.is(key)) continue;
            return true;
        }
        return false;
    }

    public static TagKey<Block> getTagKeyFor(String str) {
        return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.parse((String)str));
    }

    public static boolean canGrabViaLists(BlockState state) {
        boolean returnVal = !ConfigTornado.Storm_Tornado_GrabListBlacklistMode;
        ResourceLocation registeredName = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        if (listGrabBlockCache.containsKey(registeredName)) {
            return listGrabBlockCache.get(registeredName);
        }
        if (listGrabBlocks.contains(registeredName.toString())) {
            listGrabBlockCache.put(registeredName, returnVal);
            return returnVal;
        }
        if (WeatherUtil.isStateInListOfTags(state)) {
            listGrabBlockCache.put(registeredName, returnVal);
            return returnVal;
        }
        listGrabBlockCache.put(registeredName, !returnVal);
        return !returnVal;
    }

    public static boolean isPaused() {
        return Minecraft.getInstance().isPaused();
    }

    public static boolean isPausedSideSafe(Level world) {
        if (!world.isClientSide) {
            return false;
        }
        return WeatherUtil.isPausedForClient();
    }

    public static boolean isPausedForClient() {
        return Minecraft.getInstance().isPaused();
    }

    public static boolean isAprilFoolsDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    public static boolean shouldRemoveBlock(BlockState blockID) {
        return blockID.getBlock().defaultMapColor() != MapColor.WATER;
    }

    public static boolean isOceanBlock(Block blockID) {
        return false;
    }

    public static boolean isSolidBlock(Block id) {
        return id == Blocks.STONE || id == Blocks.COBBLESTONE || id == Blocks.SANDSTONE;
    }

    public static boolean shouldGrabBlock(Level parWorld, BlockState state) {
        try {
            ItemStack itemStr = new ItemStack((ItemLike)Items.DIAMOND_AXE);
            Block block = state.getBlock();
            boolean result = true;
            if (ConfigTornado.Storm_Tornado_GrabCond_List) {
                try {
                    result = WeatherUtil.canGrabViaLists(state);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = false;
                }
            } else {
                if (ConfigTornado.Storm_Tornado_GrabCond_StrengthGrabbing) {
                    float strMin = 0.0f;
                    float strMax = 0.74f;
                    if (block == null) {
                        result = false;
                        return result;
                    }
                    System.out.println(state.getDestroySpeed((BlockGetter)parWorld, new BlockPos(0, 0, 0)) + " test " + String.valueOf(block) + " - " + itemStr.getDestroySpeed(block.defaultBlockState()));
                    float strVsBlock = state.getDestroySpeed((BlockGetter)parWorld, new BlockPos(0, 0, 0)) - (itemStr.getDestroySpeed(block.defaultBlockState()) - 1.0f) / 4.0f;
                    if (strVsBlock <= strMax && strVsBlock >= strMin || state.getBlock().defaultMapColor() == MapColor.WOOD || state.getBlock().defaultMapColor() == MapColor.WOOL || state.getBlock().defaultMapColor() == MapColor.PLANT || block instanceof TallGrassBlock) {
                        if (!WeatherUtil.safetyCheck(state)) {
                            result = false;
                        }
                    } else {
                        result = false;
                    }
                }
                if (ConfigTornado.Storm_Tornado_RefinedGrabRules) {
                    if (block == Blocks.DIRT || block == Blocks.COARSE_DIRT || block == Blocks.ROOTED_DIRT || block == Blocks.GRASS_BLOCK || block == Blocks.DIRT_PATH || block == Blocks.SAND || block == Blocks.RED_SAND || block instanceof RotatedPillarBlock && state.getBlock().defaultMapColor() == MapColor.WOOD) {
                        result = false;
                    }
                    if (!WeatherUtil.canTornadoGrabBlockRefinedRules(state)) {
                        result = false;
                    }
                }
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean safetyCheck(BlockState state) {
        Block id = state.getBlock();
        return id != Blocks.BEDROCK && id != Blocks.ACACIA_LOG && id != Blocks.CHEST && id != Blocks.JUKEBOX;
    }

    public static ServerLevel getWorld(ResourceKey<Level> levelResourceKey) {
        return ServerLifecycleHooks.getCurrentServer().getLevel(levelResourceKey);
    }

    public static boolean canTornadoGrabBlockRefinedRules(BlockState state) {
        ResourceLocation registeredName = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        return !registeredName.getNamespace().equals("dynamictrees") || !registeredName.getPath().contains("rooty") && !registeredName.getPath().contains("branch");
    }

    public static float dist(Vector3f vec1, Vector3f vec2) {
        double d0 = vec2.x() - vec1.x();
        double d1 = vec2.y() - vec1.y();
        double d2 = vec2.z() - vec1.z();
        return (float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public static double dist(Vector3d vec1, Vector3d vec2) {
        double d0 = vec2.x - vec1.x;
        double d1 = vec2.y - vec1.y;
        double d2 = vec2.z - vec1.z;
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }
}

