/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class CachedNBTTagCompound {
    private CompoundTag newData = new CompoundTag();
    private CompoundTag cachedData = new CompoundTag();
    private boolean forced = false;

    public void setCachedNBT(CompoundTag cachedData) {
        if (cachedData == null) {
            cachedData = new CompoundTag();
        }
        this.cachedData = cachedData;
    }

    public CompoundTag getCachedNBT() {
        return this.cachedData;
    }

    public CompoundTag getNewNBT() {
        return this.newData;
    }

    public void setNewNBT(CompoundTag newData) {
        this.newData = newData;
    }

    public void setUpdateForced(boolean forced) {
        this.forced = forced;
    }

    public long getLong(String key) {
        if (!this.newData.contains(key)) {
            this.newData.putLong(key, this.cachedData.getLong(key));
        }
        return this.newData.getLong(key);
    }

    public void putLong(String key, long newVal) {
        if (!this.cachedData.contains(key) || this.cachedData.getLong(key) != newVal || this.forced) {
            this.newData.putLong(key, newVal);
        }
        this.cachedData.putLong(key, newVal);
    }

    public int getInt(String key) {
        if (!this.newData.contains(key)) {
            this.newData.putInt(key, this.cachedData.getInt(key));
        }
        return this.newData.getInt(key);
    }

    public void putInt(String key, int newVal) {
        if (!this.cachedData.contains(key) || this.cachedData.getInt(key) != newVal || this.forced) {
            this.newData.putInt(key, newVal);
        }
        this.cachedData.putInt(key, newVal);
    }

    public short getShort(String key) {
        if (!this.newData.contains(key)) {
            this.newData.putShort(key, this.cachedData.getShort(key));
        }
        return this.newData.getShort(key);
    }

    public void putShort(String key, short newVal) {
        if (!this.cachedData.contains(key) || this.cachedData.getShort(key) != newVal || this.forced) {
            this.newData.putShort(key, newVal);
        }
        this.cachedData.putShort(key, newVal);
    }

    public String getString(String key) {
        if (!this.newData.contains(key)) {
            this.newData.putString(key, this.cachedData.getString(key));
        }
        return this.newData.getString(key);
    }

    public void putString(String key, String newVal) {
        if (!this.cachedData.contains(key) || !this.cachedData.getString(key).equals(newVal) || this.forced) {
            this.newData.putString(key, newVal);
        }
        this.cachedData.putString(key, newVal);
    }

    public boolean getBoolean(String key) {
        if (!this.newData.contains(key)) {
            this.newData.putBoolean(key, this.cachedData.getBoolean(key));
        }
        return this.newData.getBoolean(key);
    }

    public void putBoolean(String key, boolean newVal) {
        if (!this.cachedData.contains(key) || this.cachedData.getBoolean(key) != newVal || this.forced) {
            this.newData.putBoolean(key, newVal);
        }
        this.cachedData.putBoolean(key, newVal);
    }

    public float getFloat(String key) {
        if (!this.newData.contains(key)) {
            this.newData.putFloat(key, this.cachedData.getFloat(key));
        }
        return this.newData.getFloat(key);
    }

    public void putFloat(String key, float newVal) {
        if (!this.cachedData.contains(key) || this.cachedData.getFloat(key) != newVal || this.forced) {
            this.newData.putFloat(key, newVal);
        }
        this.cachedData.putFloat(key, newVal);
    }

    public double getDouble(String key) {
        if (!this.newData.contains(key)) {
            this.newData.putDouble(key, this.cachedData.getDouble(key));
        }
        return this.newData.getDouble(key);
    }

    public void putDouble(String key, double newVal) {
        if (!this.cachedData.contains(key) || this.cachedData.getDouble(key) != newVal || this.forced) {
            this.newData.putDouble(key, newVal);
        }
        this.cachedData.putDouble(key, newVal);
    }

    public CompoundTag get(String key) {
        return this.newData.getCompound(key);
    }

    public void put(String key, CompoundTag tag) {
        this.newData.put(key, (Tag)tag);
        this.cachedData.put(key, (Tag)tag);
    }

    public boolean contains(String key) {
        return this.newData.contains(key);
    }

    public void updateCacheFromNew() {
        this.cachedData = this.newData;
    }
}

