/*
 * Decompiled with CFR 0.152.
 */
package weather2.data;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SpriteSourceProvider;

public class BlockAndItemProvider
extends SpriteSourceProvider {
    public BlockAndItemProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper fileHelper) {
        super(output, lookupProvider, "weather2", fileHelper);
    }

    protected void gather() {
        this.addSpriteBlock("tornado_siren");
        this.addSpriteBlock("tornado_siren_manual");
        this.addSpriteBlock("tornado_siren_manual_on");
        this.addSpriteBlock("tornado_sensor");
        this.addSpriteBlock("weather_deflector");
        this.addSpriteBlock("weather_forecast");
        this.addSpriteBlock("weather_machine");
        this.addSpriteBlock("anemometer");
        this.addSpriteBlock("wind_vane");
        this.addSpriteBlock("wind_turbine");
        this.addSpriteItem("weather_item");
        this.addSpriteItem("sand_layer");
        this.addSpriteItem("sand_layer_placeable");
    }

    public void addSpriteBlock(String textureName) {
        this.atlas(SpriteSourceProvider.BLOCKS_ATLAS).addSource((SpriteSource)new SingleFile(ResourceLocation.parse((String)("weather2:blocks/" + textureName)), Optional.empty()));
    }

    public void addSpriteItem(String textureName) {
        this.atlas(SpriteSourceProvider.BLOCKS_ATLAS).addSource((SpriteSource)new SingleFile(ResourceLocation.parse((String)("weather2:items/" + textureName)), Optional.empty()));
    }
}

