/*
 * Decompiled with CFR 0.152.
 */
package weather2.command;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigMod;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import weather2.ClientTickHandler;
import weather2.config.ConfigDebug;
import weather2.config.ConfigParticle;

public class CommandWeather2Client {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)CommandWeather2Client.getCommandName()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"client").then(Commands.literal((String)"particle_rate").then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(c -> {
            float value = FloatArgumentType.getFloat((CommandContext)c, (String)"value");
            ConfigParticle.Particle_effect_rate = value;
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Set weather2 particle effect rate to " + value)), true);
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            return 1;
        })))).then(Commands.literal((String)"particle_vanilla_precipitation").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean value;
            ConfigParticle.Particle_vanilla_precipitation = value = BoolArgumentType.getBool((CommandContext)c, (String)"value");
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("Set weather2 to use vanilla particles?: " + value)), true);
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"particle_engine").then(Commands.literal((String)"weather2").executes(c -> {
            ConfigParticle.Particle_engine_weather2 = true;
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Set particle engine to weather2"), true);
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            return 1;
        }))).then(Commands.literal((String)"vanilla").executes(c -> {
            ConfigParticle.Particle_engine_weather2 = false;
            ClientTickHandler.particleManagerExtended().clearParticles();
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"Set particle engine to vanilla"), true);
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").then(Commands.literal((String)"particles_weather2").executes(c -> {
            CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "total particle count: " + ClientTickHandler.particleManagerExtended().countParticles());
            Map<ParticleRenderType, Queue<Particle>> particles = ClientTickHandler.particleManagerExtended().getParticles();
            if (particles != null) {
                CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "particle type count: " + particles.size());
                CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "detailed particle info output to log file");
                int maxCount = 200;
                int count = 0;
                CULog.log((String)"outputting particle data:");
                for (Map.Entry<ParticleRenderType, Queue<Particle>> type : particles.entrySet()) {
                    CULog.log((String)("type: " + String.valueOf(type.getKey()) + " -> " + type.getValue().size() + " - classpath: " + type.getKey().getClass().getName()));
                    if (count > maxCount) {
                        CULog.log((String)"aborted due to large particle type list");
                        break;
                    }
                    ++count;
                }
            } else {
                CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "failed to get particles list");
            }
            return 1;
        }))).then(Commands.literal((String)"particles_vanilla").executes(c -> {
            ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
            CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "total particle count: " + particleEngine.countParticles());
            CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "emitter count: " + particleEngine.trackingEmitters.size());
            Map<ParticleRenderType, Queue<Particle>> particles = CommandWeather2Client.getParticles();
            if (particles != null) {
                CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "particle type count: " + particles.size());
                CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "detailed particle info output to log file");
                int maxCount = 200;
                int count = 0;
                CULog.log((String)"outputting particle data:");
                for (Map.Entry<ParticleRenderType, Queue<Particle>> type : particles.entrySet()) {
                    CULog.log((String)("type: " + String.valueOf(type.getKey()) + " -> " + type.getValue().size() + " - classpath: " + type.getKey().getClass().getName()));
                    if (count > maxCount) {
                        CULog.log((String)"aborted due to large particle type list");
                        break;
                    }
                    ++count;
                }
            } else {
                CommandWeather2Client.msg((CommandContext<CommandSourceStack>)c, "failed to get particles list");
            }
            return 1;
        }))).then(Commands.literal((String)"particle_engine_render").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean value;
            ConfigDebug.Particle_engine_render = value = BoolArgumentType.getBool((CommandContext)c, (String)"value");
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("ConfigParticle.Particle_engine_render: " + value)), true);
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            return 1;
        })))).then(Commands.literal((String)"particle_engine_tick").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean value;
            ConfigDebug.Particle_engine_tick = value = BoolArgumentType.getBool((CommandContext)c, (String)"value");
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)("ConfigParticle.Particle_engine_tick: " + value)), true);
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            return 1;
        })))).then(Commands.literal((String)"reset_vanilla_particles").executes(c -> {
            Minecraft.getInstance().particleEngine.clearParticles();
            ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)"cleared particles"), true);
            return 1;
        })))));
    }

    public static Map<ParticleRenderType, Queue<Particle>> getParticles() {
        try {
            Field[] fields = ParticleEngine.class.getDeclaredFields();
            fields[6].setAccessible(true);
            return (Map)fields[6].get(Minecraft.getInstance().particleEngine);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void msg(CommandContext<CommandSourceStack> c, String msg) {
        ((CommandSourceStack)c.getSource()).sendSuccess(() -> Component.literal((String)msg), true);
    }

    public static String getCommandName() {
        return "weather2";
    }
}

