/*
 * Decompiled with CFR 0.152.
 */
package weather2.client.tile;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector3f;
import weather2.ClientTickHandler;
import weather2.WeatherBlocks;
import weather2.blockentity.WindVaneBlockEntity;
import weather2.client.entity.model.WindVaneModel;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

public class WindVaneEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    private final Block block = (Block)WeatherBlocks.BLOCK_WIND_VANE.get();
    protected final WindVaneModel model = new WindVaneModel(Minecraft.getInstance().getEntityModels().bakeLayer(WindVaneModel.LAYER_LOCATION));

    public static Material getTEMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WindVaneEntityRenderer.createTEMaterial(path));
    }

    private static Material createTEMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, WindVaneEntityRenderer.getTextureTE(path));
    }

    public static ResourceLocation getTextureTE(String path) {
        return WindVaneEntityRenderer.getTexture(String.format("textures/blocks/te/%s.png", path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindVaneEntityRenderer.getResLoc(path));
    }

    private static ResourceLocation getResLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"weather2", (String)path);
    }

    public static void renderModel(Material material, Model model, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(stack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public WindVaneEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T te, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        this.model.root().getAllParts().forEach(ModelPart::resetPose);
        ModelPart root = this.model.root();
        root.x += 8.0f;
        root.y += 8.0f;
        root.z += 8.0f;
        root.xRot = (float)((double)root.xRot + Math.toRadians(180.0));
        root.yRot = (float)((double)root.yRot + Math.toRadians(180.0));
        root.y += 28.0f;
        float scale = 0.5f;
        root.offsetScale(new Vector3f(scale, scale, scale));
        ModelPart top = this.model.root().getChild("root").getChild("base").getChild("middle").getChild("top");
        if (top != null) {
            boolean shaking;
            float lerpAngle;
            WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
            if (weatherMan == null) {
                return;
            }
            WindManager windMan = weatherMan.getWindManager();
            if (windMan == null) {
                return;
            }
            float renderAngle = lerpAngle = (float)Mth.lerp((double)partialTicks, (double)((WindVaneBlockEntity)((Object)te)).smoothAnglePrev, (double)((WindVaneBlockEntity)((Object)te)).smoothAngle);
            top.yRot = (float)Math.toRadians(renderAngle);
            boolean bl = shaking = (double)windMan.getWindSpeed(te.getBlockPos()) >= 1.5;
            if (shaking) {
                Random rand = new Random(te.getLevel().getGameTime());
                top.yRot += (float)((double)(rand.nextFloat() - rand.nextFloat()) * Math.toRadians(2.0));
                top.zRot = (float)((double)(rand.nextFloat() - rand.nextFloat()) * Math.toRadians(1.0));
            }
        }
        WindVaneEntityRenderer.renderModel(WindVaneEntityRenderer.getTEMaterial("wind_vane"), (Model)this.model, stack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

