/*
 * Decompiled with CFR 0.152.
 */
package weather2.client.tile;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import weather2.WeatherBlocks;
import weather2.blockentity.WindTurbineBlockEntity;
import weather2.client.entity.model.WindTurbineModel;

public class WindTurbineEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    private final Block block = (Block)WeatherBlocks.BLOCK_WIND_TURBINE.get();
    protected final WindTurbineModel model = new WindTurbineModel(Minecraft.getInstance().getEntityModels().bakeLayer(WindTurbineModel.LAYER_LOCATION));

    public static Material getTEMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WindTurbineEntityRenderer.createTEMaterial(path));
    }

    private static Material createTEMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, WindTurbineEntityRenderer.getTextureTE(path));
    }

    public static ResourceLocation getTextureTE(String path) {
        return WindTurbineEntityRenderer.getTexture(String.format("textures/blocks/te/%s.png", path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindTurbineEntityRenderer.getResLoc(path));
    }

    private static ResourceLocation getResLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"weather2", (String)path);
    }

    public static void renderModel(Material material, Model model, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(stack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public WindTurbineEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T te, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        this.model.root().getAllParts().forEach(ModelPart::resetPose);
        ModelPart root = this.model.root();
        root.x += 8.0f;
        root.y += 8.0f;
        root.z += 8.0f;
        root.xRot = (float)((double)root.xRot + Math.toRadians(180.0));
        root.yRot = (float)((double)root.yRot + Math.toRadians(180.0));
        root.y += 16.0f;
        ModelPart top = this.model.root().getChild("root").getChild("shaft");
        if (top != null) {
            float lerpAngle;
            float renderAngle = lerpAngle = (float)Mth.lerp((double)partialTicks, (double)((WindTurbineBlockEntity)((Object)te)).smoothAnglePrev, (double)((WindTurbineBlockEntity)((Object)te)).smoothAngle);
            top.yRot = (float)Math.toRadians(renderAngle);
        }
        WindTurbineEntityRenderer.renderModel(WindTurbineEntityRenderer.getTEMaterial("wind_turbine"), (Model)this.model, stack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

