/*
 * Decompiled with CFR 0.152.
 */
package weather2.client;

import com.corosus.coroutil.config.ConfigCoroUtil;
import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.ChunkCoordinatesBlock;
import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import com.corosus.coroutil.util.CoroUtilMisc;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorSandstorm;
import extendedrenderer.particle.entity.DustEmitter;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.particle.entity.ParticleCrossSection;
import extendedrenderer.particle.entity.ParticleTexExtraRender;
import extendedrenderer.particle.entity.ParticleTexFX;
import extendedrenderer.particle.entity.ParticleTexLeafColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SuspendedParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import weather2.ClientTickHandler;
import weather2.ClientWeatherHelper;
import weather2.ClientWeatherProxy;
import weather2.SoundRegistry;
import weather2.Weather;
import weather2.client.entity.particle.ParticleHail;
import weather2.client.entity.particle.ParticleSandstorm;
import weather2.config.ConfigMisc;
import weather2.config.ConfigParticle;
import weather2.config.ConfigSand;
import weather2.config.ConfigSound;
import weather2.datatypes.PrecipitationType;
import weather2.datatypes.WeatherEventType;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilDim;
import weather2.util.WeatherUtilEntity;
import weather2.util.WeatherUtilParticle;
import weather2.util.WeatherUtilSound;
import weather2.util.WindReader;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.fog.FogAdjuster;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;
import weather2.weathersystem.tornado.TornadoManagerTodoRenameMe;
import weather2.weathersystem.wind.WindManager;

@OnlyIn(value=Dist.CLIENT)
public class SceneEnhancer
implements Runnable {
    private static final double PRECIPITATION_PARTICLE_EFFECT_RATE = 0.7;
    public ClientLevel lastWorldDetected = null;
    public static List<Particle> spawnQueueNormal = new ArrayList<Particle>();
    public static List<Particle> spawnQueue = new ArrayList<Particle>();
    public static long threadLastWorldTickTime;
    public static int lastTickFoundBlocks;
    public static long lastTickAmbient;
    public static long lastTickAmbientThreaded;
    public static ArrayList<ChunkCoordinatesBlock> soundLocations;
    public static HashMap<ChunkCoordinatesBlock, Long> soundTimeLocations;
    public static List<Block> LEAVES_BLOCKS;
    private static final List<BlockPos> listPosRandom;
    public static final ResourceLocation RAIN_TEXTURES_GREEN;
    public static final ResourceLocation RAIN_TEXTURES;
    public static boolean FORCE_ON_DEBUG_TESTING;
    public static ParticleBehaviorSandstorm particleBehavior;
    private static FogAdjuster fogAdjuster;
    public static boolean isPlayerOutside;
    public static boolean isPlayerNearTornadoCached;
    public static WeatherEventType lastWeatherType;
    public static int particleRateLerp;
    public static int particleRateLerpMax;
    public static TornadoManagerTodoRenameMe playerManagerClient;
    private static Biome lastBiomeIn;
    public static float downfallSheetThreshold;
    private int rainSoundTime;

    public SceneEnhancer() {
        listPosRandom.clear();
        listPosRandom.add(new BlockPos(0, -1, 0));
        listPosRandom.add(new BlockPos(1, 0, 0));
        listPosRandom.add(new BlockPos(-1, 0, 0));
        listPosRandom.add(new BlockPos(0, 0, 1));
        listPosRandom.add(new BlockPos(0, 0, -1));
        Collections.addAll(LEAVES_BLOCKS, Blocks.OAK_LEAVES, Blocks.SPRUCE_LEAVES, Blocks.BIRCH_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.ACACIA_LEAVES, Blocks.CHERRY_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.MANGROVE_LEAVES, Blocks.AZALEA_LEAVES, Blocks.FLOWERING_AZALEA_LEAVES);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.tickClientThreaded();
                    Thread.sleep(400L);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void tickClient() {
        if (!Minecraft.getInstance().isPaused()) {
            WeatherManagerClient weatherMan;
            boolean testTornadoTech;
            Minecraft client = Minecraft.getInstance();
            if (client.level != null && this.lastWorldDetected != client.level) {
                this.lastWorldDetected = client.level;
                this.reset();
            }
            if (testTornadoTech = false) {
                if (playerManagerClient == null) {
                    playerManagerClient = new TornadoManagerTodoRenameMe();
                }
                playerManagerClient.tick((Level)client.level);
            }
            if ((weatherMan = ClientTickHandler.weatherManager) == null) {
                return;
            }
            WindManager windMan = weatherMan.getWindManager();
            if (windMan == null) {
                return;
            }
            ClientTickHandler.getClientWeather();
            ClientWeatherProxy weather = ClientWeatherProxy.get();
            WeatherEventType curWeather = SceneEnhancer.getWeatherState();
            if (curWeather != lastWeatherType) {
                particleRateLerp = 0;
            }
            lastWeatherType = SceneEnhancer.getWeatherState();
            if (particleRateLerp < particleRateLerpMax) {
                ++particleRateLerp;
            }
            if (weather.hasWeather() || windMan.cachedWindSpeedClient > 0.0f) {
                this.tryParticleSpawning();
            }
            FORCE_ON_DEBUG_TESTING = false;
            if (weather.hasWeather() || !Weather.isLoveTropicsInstalled()) {
                ClientWeatherHelper.get().tick();
                this.tickEnvironmentalParticleSpawning();
                this.trySoundPlaying();
                SceneEnhancer.tryWind((Level)client.level);
            }
            this.tickMisc();
            SceneEnhancer.getFogAdjuster().tickGame(weather);
            SceneEnhancer.checkParticleBehavior();
            particleBehavior.tickUpdateList();
            if (client.player != null && client.level != null && client.level.getGameTime() % 10L == 0L) {
                isPlayerOutside = WeatherUtilEntity.isEntityOutside((Entity)client.player);
            }
        }
    }

    public void tickClientThreaded() {
        Minecraft client = Minecraft.getInstance();
        if (client != null && client.level != null && client.player != null) {
            this.profileSurroundings();
            if (!Weather.isLoveTropicsInstalled() || ClientWeatherProxy.get().hasWeather()) {
                SceneEnhancer.tryAmbientSounds();
            }
        }
    }

    public synchronized void trySoundPlaying() {
        try {
            Minecraft client = Minecraft.getInstance();
            this.tickRainSound();
            if (lastTickAmbient < System.currentTimeMillis()) {
                lastTickAmbient = System.currentTimeMillis() + 500L;
                ClientLevel worldRef = client.level;
                LocalPlayer player = client.player;
                int size = 32;
                int hsize = size / 2;
                BlockPos cur = player.blockPosition();
                Random rand = new Random();
                for (int i = 0; i < soundLocations.size(); ++i) {
                    ChunkCoordinatesBlock cCor = soundLocations.get(i);
                    if (Math.sqrt(cCor.distSqr((Vec3i)cur)) > (double)size) {
                        soundLocations.remove(i--);
                        soundTimeLocations.remove(cCor);
                        continue;
                    }
                    Block block = SceneEnhancer.getBlock((Level)worldRef, cCor.getX(), cCor.getY(), cCor.getZ());
                    if (block == null || block.defaultMapColor() != MapColor.WATER && block.defaultMapColor() != MapColor.PLANT) {
                        soundLocations.remove(i);
                        soundTimeLocations.remove(cCor);
                        continue;
                    }
                    long lastPlayTime = 0L;
                    float soundMuffle = 0.6f;
                    if (SceneEnhancer.getWeatherState() == WeatherEventType.SANDSTORM || SceneEnhancer.getWeatherState() == WeatherEventType.SNOWSTORM) {
                        soundMuffle = 0.15f;
                    }
                    if (soundTimeLocations.containsKey(cCor)) {
                        lastPlayTime = soundTimeLocations.get(cCor);
                    }
                    float maxLeavesVolume = 1.0f;
                    soundMuffle = (float)((double)soundMuffle * ConfigSound.leavesVolume);
                    if (lastPlayTime >= System.currentTimeMillis() || !LEAVES_BLOCKS.contains(cCor.block)) continue;
                    float windSpeed = WindReader.getWindSpeed((Level)client.level, cur);
                    if (windSpeed > 0.2f) {
                        soundTimeLocations.put(cCor, System.currentTimeMillis() + 12000L + (long)rand.nextInt(50));
                        client.level.playLocalSound((BlockPos)cCor, SoundRegistry.get("env.wind_calmfade"), SoundSource.AMBIENT, Math.min(maxLeavesVolume, windSpeed * 2.0f * soundMuffle), 0.7f + rand.nextFloat() * 0.1f, false);
                        continue;
                    }
                    windSpeed = WindReader.getWindSpeed((Level)client.level, cur);
                    if (CoroUtilMisc.random.nextInt(15) != 0) continue;
                    soundTimeLocations.put(cCor, System.currentTimeMillis() + 12000L + (long)rand.nextInt(50));
                    client.level.playLocalSound((BlockPos)cCor, SoundRegistry.get("env.wind_calmfade"), SoundSource.AMBIENT, Math.min(maxLeavesVolume, windSpeed * soundMuffle), 0.7f + rand.nextFloat() * 0.1f, false);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Weather2: Error handling sound play queue: ");
            ex.printStackTrace();
        }
    }

    public void tickRainSound() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = Minecraft.getInstance().player;
        float precipitationStrength = ClientWeatherHelper.get().getPrecipitationStrength((Player)player);
        if (!(precipitationStrength <= 0.0f) && !SceneEnhancer.shouldSnowHere(player.level(), (Biome)player.level().getBiome(player.blockPosition()).value(), player.blockPosition())) {
            Random random = new Random(player.level().getGameTime() * 312987231L);
            ClientLevel levelreader = minecraft.level;
            BlockPos blockpos = player.blockPosition();
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * precipitationStrength * precipitationStrength) / (minecraft.options.particles.get() == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = random.nextInt(21) - 10;
                int l = random.nextInt(21) - 10;
                BlockPos blockpos2 = levelreader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos.offset(k, 0, l));
                Biome biome = (Biome)levelreader.getBiome(blockpos2).value();
                if (blockpos2.getY() <= levelreader.getMinBuildHeight() || blockpos2.getY() > blockpos.getY() + 10 || blockpos2.getY() < blockpos.getY() - 10 || biome.getPrecipitationAt(blockpos2) != Biome.Precipitation.RAIN || !biome.warmEnoughToRain(blockpos2)) continue;
                blockpos1 = blockpos2.below();
                if (minecraft.options.particles.get() == ParticleStatus.MINIMAL) break;
                double d0 = random.nextDouble();
                double d1 = random.nextDouble();
                BlockState blockstate = levelreader.getBlockState(blockpos1);
                FluidState fluidstate = levelreader.getFluidState(blockpos1);
                VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)levelreader, blockpos1);
                double d2 = voxelshape.max(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.getHeight((BlockGetter)levelreader, blockpos1);
                double d4 = Math.max(d2, d3);
                SimpleParticleType particleoptions = !fluidstate.is(FluidTags.LAVA) && !blockstate.is(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLitCampfire((BlockState)blockstate) ? ParticleTypes.RAIN : ParticleTypes.SMOKE;
                minecraft.level.addParticle((ParticleOptions)particleoptions, (double)blockpos1.getX() + d0, (double)blockpos1.getY() + d4, (double)blockpos1.getZ() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && random.nextInt(3) < this.rainSoundTime++) {
                this.rainSoundTime = 0;
                if (blockpos1.getY() > blockpos.getY() + 1 && levelreader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() > Mth.floor((float)blockpos.getY())) {
                    minecraft.level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, 0.1f + 0.4f * precipitationStrength, 0.5f, false);
                } else {
                    minecraft.level.playLocalSound(blockpos1, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f + 0.6f * precipitationStrength, 1.0f, false);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tryAmbientSounds() {
        Minecraft client = Minecraft.getInstance();
        ClientLevel worldRef = client.level;
        LocalPlayer player = client.player;
        if (lastTickAmbientThreaded < System.currentTimeMillis() && ConfigSound.leavesVolume > 0.0) {
            lastTickAmbientThreaded = System.currentTimeMillis() + 500L;
            int size = 32;
            int hsize = size / 2;
            int curX = (int)player.getX();
            int curY = (int)player.getY();
            int curZ = (int)player.getZ();
            for (int xx = curX - hsize; xx < curX + hsize; ++xx) {
                for (int yy = curY - hsize / 2; yy < curY + hsize; ++yy) {
                    for (int zz = curZ - hsize; zz < curZ + hsize; ++zz) {
                        Block block = SceneEnhancer.getBlock((Level)worldRef, xx, yy, zz);
                        if (block == null || block.defaultMapColor() != MapColor.PLANT) continue;
                        boolean proxFail = false;
                        for (ChunkCoordinatesBlock soundLocation : soundLocations) {
                            Vec3i vec3i = new Vec3i(xx, yy, zz);
                            if (!(Math.sqrt(soundLocation.distSqr(vec3i)) < 15.0)) continue;
                            proxFail = true;
                            break;
                        }
                        if (proxFail) continue;
                        soundLocations.add(new ChunkCoordinatesBlock(xx, yy, zz, block));
                    }
                }
            }
        }
    }

    public void reset() {
        if (WeatherUtilParticle.fxLayers == null) {
            WeatherUtilParticle.getFXLayers();
        }
    }

    private static void tickHeatwave(ClientWeatherProxy weather) {
        Minecraft client = Minecraft.getInstance();
    }

    public static boolean tryPlayPlayerLockedSound(String[] sound, int arrIndex, Entity source, float vol) {
        Random rand = new Random();
        if (WeatherUtilSound.soundTimer[arrIndex] <= System.currentTimeMillis()) {
            String soundStr = sound[WeatherUtilSound.snd_rand[arrIndex]];
            WeatherUtilSound.playPlayerLockedSound(source.position(), "streaming." + soundStr, vol, 1.0f);
            int length = WeatherUtilSound.soundToLength.get(soundStr);
            WeatherUtilSound.soundTimer[arrIndex] = System.currentTimeMillis() + (long)length - 500L;
            WeatherUtilSound.snd_rand[arrIndex] = rand.nextInt(sound.length);
        }
        return false;
    }

    public void tickMisc() {
    }

    public void tickEnvironmentalParticleSpawning() {
        int spawnAreaSize;
        BlockPos pos;
        int i;
        int spawnNeed;
        int spawnAreaSize2;
        WeatherObjectParticleStorm storm;
        boolean isRain;
        Biome biome;
        FORCE_ON_DEBUG_TESTING = false;
        LocalPlayer entP = Minecraft.getInstance().player;
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        if (particleBehavior == null) {
            return;
        }
        ClientWeatherProxy weather = ClientWeatherProxy.get();
        float curPrecipVal = weather.getRainAmount();
        if (FORCE_ON_DEBUG_TESTING) {
            curPrecipVal = 0.3f;
        }
        if (Weather.isLoveTropicsInstalled() && curPrecipVal < 1.0E-4f) {
            curPrecipVal = 0.0f;
        }
        float maxPrecip = 1.0f;
        BlockPos posPlayer = CoroUtilBlock.blockPos((double)entP.getX(), (double)entP.getY(), (double)entP.getZ());
        lastBiomeIn = biome = (Biome)entP.level().getBiome(posPlayer).value();
        Level world = entP.level();
        Random rand = CoroUtilMisc.random();
        float windSpeed = windMan.getWindSpeed(posPlayer);
        if (world.getGameTime() % 40L == 0L) {
            curPrecipVal = Weather.isLoveTropicsInstalled() ? Math.min(maxPrecip, Math.max(0.0f, curPrecipVal)) : Math.min(maxPrecip, Math.abs(curPrecipVal));
        }
        float particleSettingsAmplifier = 1.0f;
        if (Minecraft.getInstance().options.particles.get() == ParticleStatus.DECREASED) {
            particleSettingsAmplifier = 0.5f;
        } else if (Minecraft.getInstance().options.particles.get() == ParticleStatus.MINIMAL) {
            particleSettingsAmplifier = 0.2f;
        }
        particleSettingsAmplifier = (float)((double)particleSettingsAmplifier * ConfigParticle.Particle_effect_rate);
        float curPrecipValMaxNoExtraRender = 0.3f;
        int extraRenderCountMax = 10;
        int extraRenderCount = 0;
        if (curPrecipVal > curPrecipValMaxNoExtraRender) {
            float precipValForExtraRenders = curPrecipVal - curPrecipValMaxNoExtraRender;
            float precipValExtraRenderRange = 1.0f - curPrecipValMaxNoExtraRender;
            extraRenderCount = Math.min((int)((float)extraRenderCountMax * (precipValForExtraRenders / precipValExtraRenderRange)), extraRenderCountMax);
        }
        float curPrecipCappedForSpawnNeed = Math.min(curPrecipVal, curPrecipValMaxNoExtraRender);
        double spawnNeedBase = (double)curPrecipCappedForSpawnNeed * ConfigParticle.Precipitation_Particle_effect_rate * (double)particleSettingsAmplifier;
        int safetyCutout = 100;
        if (world.getGameTime() % 20L == 0L) {
            StormObject stormObject = ClientTickHandler.weatherManager.getClosestStorm(entP.position(), ConfigMisc.sirenActivateDistance, StormObject.STATE_FORMING);
            isPlayerNearTornadoCached = stormObject != null && entP.position().distanceTo(stormObject.pos) < (double)stormObject.getSize();
        }
        boolean canPrecip = weather.getPrecipitationType(biome) == PrecipitationType.NORMAL || weather.getPrecipitationType(biome) == PrecipitationType.SNOW;
        boolean bl = isRain = canPrecip && SceneEnhancer.shouldRainHere(world, biome, posPlayer);
        if (Weather.isLoveTropicsInstalled() && ClientWeatherProxy.get().getPrecipitationType(biome) == PrecipitationType.ACID) {
            isRain = true;
        }
        boolean isHail = weather.isHail();
        if (Weather.isLoveTropicsInstalled() && ClientWeatherProxy.get().getPrecipitationType(biome) == PrecipitationType.HAIL) {
            isHail = true;
        }
        boolean isSnowstorm = weather.isSnowstorm();
        boolean isSandstorm = weather.isSandstorm();
        boolean isRain_WaterParticle = true;
        boolean isRain_GroundSplash = true;
        boolean isRain_DownfallSheet = true;
        if (isHail) {
            isRain_WaterParticle = false;
            isRain_GroundSplash = false;
            isRain_DownfallSheet = false;
        }
        if (isPlayerNearTornadoCached) {
            isRain_DownfallSheet = false;
        }
        boolean farSpawn = Minecraft.getInstance().player.isSpectator() || !isPlayerOutside;
        float particleStormIntensity = 0.0f;
        if (isSandstorm) {
            if (Weather.isLoveTropicsInstalled()) {
                if (SceneEnhancer.getWeatherState() == WeatherEventType.SANDSTORM) {
                    particleStormIntensity = 1.0f;
                }
            } else {
                storm = ClientTickHandler.weatherManager.getClosestParticleStormByIntensity(entP.position(), WeatherObjectParticleStorm.StormType.SANDSTORM);
                if (storm != null) {
                    particleStormIntensity = storm.getIntensity();
                }
            }
        }
        if (isSnowstorm) {
            if (Weather.isLoveTropicsInstalled()) {
                if (SceneEnhancer.getWeatherState() == WeatherEventType.SNOWSTORM) {
                    particleStormIntensity = 1.0f;
                }
            } else {
                storm = ClientTickHandler.weatherManager.getClosestParticleStormByIntensity(entP.position(), WeatherObjectParticleStorm.StormType.SNOWSTORM);
                if (storm != null) {
                    particleStormIntensity = storm.getIntensity();
                }
            }
        }
        if (Weather.isLoveTropicsInstalled() && farSpawn) {
            particleStormIntensity *= 0.5f;
        }
        boolean isSnow = canPrecip && (!weather.isSnowstorm() || (double)particleStormIntensity < 0.1) && !isHail && SceneEnhancer.shouldSnowHere(world, biome, posPlayer);
        boolean devTest = false;
        if (devTest && entP.level().getGameTime() % 40L == 0L) {
            if (ConfigCoroUtil.useLoggingDebug) {
                System.out.printf("curPrecipVal: %.2f", Float.valueOf(curPrecipVal));
                System.out.println("");
            }
            CULog.dbg((String)("spawnNeedBase: " + spawnNeedBase));
            CULog.dbg((String)("extraRenderCount: " + extraRenderCount));
            CULog.dbg((String)("particleStormIntensity: " + particleStormIntensity));
        }
        if (biome != null && biome.getPrecipitationAt(posPlayer) != Biome.Precipitation.NONE) {
            VoxelShape shape;
            BlockState state;
            if (curPrecipVal > 0.0f) {
                if (isRain) {
                    int spawnCount = 0;
                    spawnAreaSize2 = 30;
                    spawnNeed = (int)(spawnNeedBase * 300.0);
                    if (entP.level().getGameTime() % 40L == 0L) {
                        // empty if block
                    }
                    if (isRain_WaterParticle && spawnNeed > 0) {
                        for (i = 0; i < safetyCutout; ++i) {
                            pos = CoroUtilBlock.blockPos((double)(entP.getX() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)), (double)(entP.getY() - 5.0 + (double)rand.nextInt(25)), (double)(entP.getZ() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)));
                            if (!SceneEnhancer.canPrecipitateAt(world, pos)) continue;
                            ParticleTexExtraRender rain = new ParticleTexExtraRender((ClientLevel)entP.level(), pos.getX(), pos.getY(), pos.getZ(), 0.0, 0.0, 0.0, ParticleRegistry.rain_white);
                            particleBehavior.initParticleRain(rain, extraRenderCount);
                            if (++spawnCount >= spawnNeed) break;
                        }
                    }
                    spawnAreaSize2 = 40;
                    if (isRain_GroundSplash && (double)curPrecipVal > 0.15) {
                        i = 0;
                        while ((double)i < (double)(30.0f * curPrecipVal) * 0.7 * 8.0 * (double)particleSettingsAmplifier) {
                            pos = CoroUtilBlock.blockPos((double)(entP.getX() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)), (double)(entP.getY() - 5.0 + (double)rand.nextInt(15)), (double)(entP.getZ() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)));
                            pos = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).below();
                            state = world.getBlockState(pos);
                            double maxY = 0.0;
                            double minY = 0.0;
                            shape = state.getShape((BlockGetter)world, pos);
                            if (!shape.isEmpty()) {
                                minY = shape.bounds().minY;
                                maxY = shape.bounds().maxY;
                            }
                            if (!(pos.distSqr((Vec3i)entP.blockPosition()) > (double)(spawnAreaSize2 / 2 * (spawnAreaSize2 / 2))) && SceneEnhancer.canPrecipitateAt(world, pos.above())) {
                                if (world.getBlockState(pos).getBlock().defaultMapColor() == MapColor.WATER) {
                                    pos = pos.offset(0, 1, 0);
                                }
                                ParticleTexFX rain = new ParticleTexFX((ClientLevel)entP.level(), (float)pos.getX() + rand.nextFloat(), (double)pos.getY() + 0.01 + maxY, (float)pos.getZ() + rand.nextFloat(), 0.0, 0.0, 0.0, ParticleRegistry.groundSplash);
                                particleBehavior.initParticleGroundSplash(rain);
                                rain.spawnAsWeatherEffect();
                            }
                            ++i;
                        }
                    }
                    spawnAreaSize2 = 30;
                    if (isRain_DownfallSheet && curPrecipVal > downfallSheetThreshold) {
                        int scanAheadRange = 0;
                        scanAheadRange = WeatherUtilDim.canBlockSeeSky(world, entP.blockPosition()) ? 3 : 10;
                        double closeDistCutoff = 10.0;
                        int i2 = 0;
                        while ((double)i2 < (double)(2.0f * curPrecipVal) * 0.7 * (double)particleSettingsAmplifier * 0.5) {
                            BlockPos pos2 = CoroUtilBlock.blockPos((double)(entP.getX() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)), (double)(entP.getY() + 5.0 + (double)rand.nextInt(15)), (double)(entP.getZ() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)));
                            if (!(WeatherUtilEntity.getDistanceSqEntToPos((Entity)entP, pos2) < closeDistCutoff * closeDistCutoff) && SceneEnhancer.canPrecipitateAt(world, pos2.above(-scanAheadRange))) {
                                ParticleTexFX rain = new ParticleTexFX((ClientLevel)entP.level(), (float)pos2.getX() + rand.nextFloat(), (double)(pos2.getY() - 1) + 0.01, (float)pos2.getZ() + rand.nextFloat(), 0.0, 0.0, 0.0, ParticleRegistry.downfall3);
                                particleBehavior.initParticleRainDownfall(rain);
                                rain.spawnAsWeatherEffect();
                            }
                            ++i2;
                        }
                    }
                } else if (isSnow) {
                    int spawnCount = 0;
                    spawnAreaSize2 = 50;
                    spawnNeed = (int)(spawnNeedBase * 80.0);
                    if (entP.level().getGameTime() % 40L == 0L) {
                        // empty if block
                    }
                    if (spawnNeed > 0) {
                        for (i = 0; i < safetyCutout; ++i) {
                            BlockPos pos3 = CoroUtilBlock.blockPos((double)(entP.getX() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)), (double)(entP.getY() - 5.0 + (double)rand.nextInt(25)), (double)(entP.getZ() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)));
                            if (!SceneEnhancer.canPrecipitateAt(world, pos3)) continue;
                            ParticleTexExtraRender snow = new ParticleTexExtraRender((ClientLevel)entP.level(), pos3.getX(), pos3.getY(), pos3.getZ(), 0.0, 0.0, 0.0, ParticleRegistry.snow2);
                            particleBehavior.initParticleSnow(snow, extraRenderCount, windSpeed);
                            snow.spawnAsWeatherEffect();
                            if (++spawnCount < spawnNeed) {
                                continue;
                            }
                            break;
                        }
                    }
                }
                spawnAreaSize2 = 30;
                int spawnCount = 0;
                spawnNeed = (int)(spawnNeedBase * 80.0);
                if ((SceneEnhancer.getWeatherState() == WeatherEventType.HAIL || isHail) && spawnNeed > 0) {
                    for (i = 0; i < safetyCutout / 4; ++i) {
                        pos = CoroUtilBlock.blockPos((double)(entP.getX() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)), (double)(entP.getY() - 5.0 + (double)rand.nextInt(25)), (double)(entP.getZ() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)));
                        if (!SceneEnhancer.canPrecipitateAt(world, pos)) continue;
                        ParticleHail hail = new ParticleHail((ClientLevel)entP.level(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.0, 0.0, ParticleRegistry.hail);
                        particleBehavior.initParticleHail(hail);
                        hail.spawnAsWeatherEffect();
                        if (++spawnCount >= spawnNeed) break;
                    }
                }
            }
            boolean groundFire = ClientWeatherProxy.get().isHeatwave();
            int spawnAreaSize3 = 40;
            if (groundFire) {
                i = 0;
                while ((double)i < 7.0 * (double)particleSettingsAmplifier) {
                    pos = CoroUtilBlock.blockPos((double)(entP.getX() + (double)rand.nextInt(spawnAreaSize3) - (double)(spawnAreaSize3 / 2)), (double)(entP.getY() - 5.0 + (double)rand.nextInt(15)), (double)(entP.getZ() + (double)rand.nextInt(spawnAreaSize3) - (double)(spawnAreaSize3 / 2)));
                    pos = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).below();
                    state = world.getBlockState(pos);
                    double maxY = 0.0;
                    double minY = 0.0;
                    shape = state.getShape((BlockGetter)world, pos);
                    if (!shape.isEmpty()) {
                        minY = shape.bounds().minY;
                        maxY = shape.bounds().maxY;
                    }
                    if (!(pos.distSqr((Vec3i)entP.blockPosition()) > (double)(spawnAreaSize3 / 2 * (spawnAreaSize3 / 2))) && SceneEnhancer.canPrecipitateAt(world, pos.above()) && world.getBlockState(pos).getBlock().defaultMapColor() != MapColor.WATER) {
                        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + rand.nextFloat()), (double)pos.getY() + 0.01 + maxY, (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0);
                        world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + rand.nextFloat()), (double)pos.getY() + 0.01 + maxY, (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0);
                    }
                    ++i;
                }
            }
        }
        spawnAreaSize2 = 25;
        spawnNeed = (int)(particleSettingsAmplifier * 5.0f * windSpeed);
        int spawnCount = 0;
        for (i = 0; i < safetyCutout && spawnCount < spawnNeed; ++i) {
            if (!(windSpeed >= 0.1f) || !SceneEnhancer.canPrecipitateAt(world, pos = CoroUtilBlock.blockPos((double)(entP.getX() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2)), (double)(entP.getY() - 5.0 + (double)rand.nextInt(25)), (double)(entP.getZ() + (double)rand.nextInt(spawnAreaSize2) - (double)(spawnAreaSize2 / 2))))) continue;
            ParticleTexExtraRender dust = new ParticleTexExtraRender((ClientLevel)entP.level(), pos.getX(), pos.getY(), pos.getZ(), 0.0, 0.0, 0.0, ParticleRegistry.squareGrey);
            particleBehavior.initParticleDustAir(dust);
            dust.spawnAsWeatherEffect();
            ++spawnCount;
        }
        if (isSnowstorm) {
            spawnCount = 0;
            float particleSettingsAmplifierExtra = particleSettingsAmplifier;
            spawnNeedBase = ConfigParticle.Precipitation_Particle_effect_rate * (double)particleSettingsAmplifierExtra;
            spawnNeed = (int)Math.max(0.0, spawnNeedBase * 5.0);
            safetyCutout = 60;
            spawnAreaSize = 20;
            double closeDistCutoff = 7.0;
            float yetAnotherRateNumber = 120.0f * SceneEnhancer.getParticleFadeInLerpForNewWeatherState();
            if (farSpawn) {
                safetyCutout = 20;
                spawnAreaSize = 100;
                yetAnotherRateNumber = 40.0f * SceneEnhancer.getParticleFadeInLerpForNewWeatherState();
            }
            if (particleStormIntensity >= 0.01f && spawnNeed > 0) {
                particleSettingsAmplifierExtra = SceneEnhancer.getParticleFadeInLerpForNewWeatherState() > 0.5f ? (particleSettingsAmplifierExtra *= (SceneEnhancer.getParticleFadeInLerpForNewWeatherState() - 0.5f) * 2.0f) : 0.0f;
                int i3 = 0;
                while ((float)i3 < Math.max(1.0f, (float)safetyCutout * particleSettingsAmplifierExtra)) {
                    BlockPos pos4 = CoroUtilBlock.blockPos((double)(entP.getX() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)), (double)(entP.getY() - 5.0 + (double)rand.nextInt(20)), (double)(entP.getZ() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)));
                    Vec3 windForce = ClientTickHandler.getClientWeather().getWindManager().getWindForce(null);
                    double upwindDistAdjust = -10.0;
                    windForce = windForce.multiply(upwindDistAdjust, upwindDistAdjust, upwindDistAdjust);
                    if (!(WeatherUtilEntity.getDistanceSqEntToPos((Entity)entP, pos4 = pos4.offset(Mth.floor((double)windForce.x), Mth.floor((double)windForce.y), Mth.floor((double)windForce.z))) < closeDistCutoff * closeDistCutoff) && SceneEnhancer.canPrecipitateAt(world, pos4)) {
                        ParticleTexExtraRender snow = new ParticleTexExtraRender((ClientLevel)entP.level(), pos4.getX(), pos4.getY(), pos4.getZ(), 0.0, 0.0, 0.0, ParticleRegistry.snow);
                        particleBehavior.initParticleSnowstorm(snow, (int)(10.0f * particleStormIntensity));
                        snow.spawnAsWeatherEffect();
                    }
                    ++i3;
                }
                double sandstormParticleRateDust = ConfigSand.Sandstorm_Particle_Dust_effect_rate;
                Minecraft client = Minecraft.getInstance();
                LocalPlayer player = client.player;
                float adjustAmountSmooth75 = particleStormIntensity;
                int i4 = 0;
                while ((double)i4 < (double)(particleSettingsAmplifier * yetAnotherRateNumber * adjustAmountSmooth75) * sandstormParticleRateDust) {
                    BlockPos pos5 = CoroUtilBlock.blockPos((double)(player.getX() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)), (double)(player.getY() - 2.0 + (double)rand.nextInt(10)), (double)(player.getZ() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)));
                    if (!(WeatherUtilEntity.getDistanceSqEntToPos((Entity)entP, pos5) < closeDistCutoff * closeDistCutoff) && SceneEnhancer.canPrecipitateAt(world, pos5)) {
                        TextureAtlasSprite sprite = ParticleRegistry.cloud256;
                        ParticleSandstorm part = new ParticleSandstorm(world, (double)pos5.getX(), (double)pos5.getY(), (double)pos5.getZ(), 0.0, 0.0, 0.0, sprite);
                        particleBehavior.initParticle(part);
                        particleBehavior.initParticleSnowstormCloudDust(part);
                        SceneEnhancer.particleBehavior.particles.add(part);
                        part.spawnAsWeatherEffect();
                    }
                    ++i4;
                }
            }
            SceneEnhancer.tickSandstormSound();
        }
        if (isSandstorm) {
            Minecraft client = Minecraft.getInstance();
            LocalPlayer player = client.player;
            ClientTickHandler.getClientWeather();
            if (particleStormIntensity >= 0.01f) {
                BlockPos pos6;
                rand = CoroUtilMisc.random();
                spawnAreaSize = 60;
                double sandstormParticleRateDebris = ConfigSand.Sandstorm_Particle_Debris_effect_rate;
                double sandstormParticleRateDust = ConfigSand.Sandstorm_Particle_Dust_effect_rate;
                float adjustAmountSmooth75 = particleStormIntensity;
                if (farSpawn) {
                    adjustAmountSmooth75 *= 0.3f;
                }
                adjustAmountSmooth75 *= particleSettingsAmplifier;
                adjustAmountSmooth75 *= SceneEnhancer.getParticleFadeInLerpForNewWeatherState();
                int i5 = 0;
                while ((double)i5 < (double)(60.0f * adjustAmountSmooth75) * sandstormParticleRateDust) {
                    pos6 = CoroUtilBlock.blockPos((double)(player.getX() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)), (double)(player.getY() - 2.0 + (double)rand.nextInt(10)), (double)(player.getZ() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)));
                    if (SceneEnhancer.canPrecipitateAt(world, pos6)) {
                        TextureAtlasSprite sprite = ParticleRegistry.cloud256;
                        ParticleSandstorm part = new ParticleSandstorm(world, (double)pos6.getX(), (double)pos6.getY(), (double)pos6.getZ(), 0.0, 0.0, 0.0, sprite);
                        particleBehavior.initParticle(part);
                        particleBehavior.initParticleSandstormDust(part);
                        SceneEnhancer.particleBehavior.particles.add(part);
                        part.spawnAsWeatherEffect();
                    }
                    ++i5;
                }
                i5 = 0;
                while ((double)i5 < (double)(1.0f * adjustAmountSmooth75) * sandstormParticleRateDebris) {
                    pos6 = CoroUtilBlock.blockPos((double)(player.getX() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)), (double)(player.getY() - 2.0 + (double)rand.nextInt(10)), (double)(player.getZ() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)));
                    if (SceneEnhancer.canPrecipitateAt(world, pos6)) {
                        TextureAtlasSprite sprite = ParticleRegistry.tumbleweed;
                        ParticleCrossSection part = new ParticleCrossSection(world, (double)pos6.getX(), (double)pos6.getY(), (double)pos6.getZ(), 0.0, 0.0, 0.0, sprite);
                        particleBehavior.initParticle(part);
                        particleBehavior.initParticleSandstormTumbleweed(part);
                        SceneEnhancer.particleBehavior.particles.add(part);
                        part.spawnAsWeatherEffect();
                    }
                    ++i5;
                }
                i5 = 0;
                while ((double)i5 < (double)(8.0f * adjustAmountSmooth75) * sandstormParticleRateDebris) {
                    pos6 = CoroUtilBlock.blockPos((double)(player.getX() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)), (double)(player.getY() - 2.0 + (double)rand.nextInt(10)), (double)(player.getZ() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)));
                    if (SceneEnhancer.canPrecipitateAt(world, pos6)) {
                        TextureAtlasSprite sprite = null;
                        int tex = rand.nextInt(3);
                        if (tex == 0) {
                            sprite = ParticleRegistry.debris_1;
                        } else if (tex == 1) {
                            sprite = ParticleRegistry.debris_2;
                        } else if (tex == 2) {
                            sprite = ParticleRegistry.debris_3;
                        }
                        ParticleSandstorm part = new ParticleSandstorm(world, (double)pos6.getX(), (double)pos6.getY(), (double)pos6.getZ(), 0.0, 0.0, 0.0, sprite);
                        particleBehavior.initParticle(part);
                        particleBehavior.initParticleSandstormDebris(part);
                        SceneEnhancer.particleBehavior.particles.add(part);
                        part.spawnAsWeatherEffect();
                    }
                    ++i5;
                }
            }
            SceneEnhancer.tickSandstormSound();
        }
    }

    public static boolean canPrecipitateAt(Level world, BlockPos strikePosition) {
        return world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, strikePosition).getY() <= strikePosition.getY();
    }

    public synchronized void tryParticleSpawning() {
        try {
            for (Particle ent : spawnQueue) {
                if (ent == null || !(ent instanceof EntityRotFX)) continue;
                ((EntityRotFX)ent).spawnAsWeatherEffect();
            }
            for (Particle ent : spawnQueueNormal) {
                if (ent == null) continue;
                Minecraft.getInstance().particleEngine.add(ent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        spawnQueue.clear();
        spawnQueueNormal.clear();
    }

    public void profileSurroundings() {
        Minecraft client = Minecraft.getInstance();
        ClientLevel worldRef = this.lastWorldDetected;
        LocalPlayer player = Minecraft.getInstance().player;
        WeatherManagerClient manager = ClientTickHandler.weatherManager;
        if (worldRef == null || player == null || manager == null || manager.getWindManager() == null || manager.getWindManager() != null && manager.getWindManager().cachedWindSpeedClient == 0.0f) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (threadLastWorldTickTime == worldRef.getGameTime()) {
            return;
        }
        threadLastWorldTickTime = worldRef.getGameTime();
        Random rand = new Random();
        int size = 40;
        int hsize = size / 2;
        int curX = (int)player.getX();
        int curY = (int)player.getY();
        int curZ = (int)player.getZ();
        float windStr = manager.getWindManager().cachedWindSpeedClient;
        int spawnRateRandChanceOdds = (int)(30.0 / ((double)windStr + 0.001));
        float lastBlockCount = lastTickFoundBlocks;
        float particleCreationRate = 0.7f;
        float maxScaleSample = 15000.0f;
        if (lastBlockCount > maxScaleSample) {
            lastBlockCount = maxScaleSample - 1.0f;
        }
        float scaleRate = (maxScaleSample - lastBlockCount) / maxScaleSample;
        spawnRateRandChanceOdds = (int)((float)spawnRateRandChanceOdds / (scaleRate + 0.001f) / (particleCreationRate + 0.001f));
        float particleSettingsAmplifier = 1.0f;
        if (Minecraft.getInstance().options.particles.get() == ParticleStatus.DECREASED) {
            particleSettingsAmplifier = 0.5f;
        } else if (Minecraft.getInstance().options.particles.get() == ParticleStatus.MINIMAL) {
            particleSettingsAmplifier = 0.2f;
        }
        particleSettingsAmplifier = (float)((double)particleSettingsAmplifier * ConfigParticle.Particle_effect_rate);
        spawnRateRandChanceOdds = (int)((float)spawnRateRandChanceOdds / particleSettingsAmplifier);
        if ((spawnRateRandChanceOdds /= 2) < 40) {
            spawnRateRandChanceOdds = 40;
        }
        lastTickFoundBlocks = 0;
        double particleAmp = 1.0;
        spawnRateRandChanceOdds = (int)((double)spawnRateRandChanceOdds / particleAmp);
        for (int xx = curX - hsize; xx < curX + hsize; ++xx) {
            for (int yy = curY - hsize / 2; yy < curY + hsize; ++yy) {
                for (int zz = curZ - hsize; zz < curZ + hsize; ++zz) {
                    Block block = SceneEnhancer.getBlock((Level)worldRef, xx, yy, zz);
                    if (block == null) continue;
                    if (block.defaultMapColor() == MapColor.PLANT) {
                        ++lastTickFoundBlocks;
                        if (CoroUtilMisc.random.nextInt(spawnRateRandChanceOdds) == 0) {
                            double relAdj = 0.7;
                            BlockPos pos = SceneEnhancer.getRandomWorkingPos((Level)worldRef, new BlockPos(xx, yy, zz));
                            double xRand = 0.0;
                            double yRand = 0.0;
                            double zRand = 0.0;
                            if (pos != null) {
                                float particleAABB = 0.1f;
                                float particleAABBAndBuffer = particleAABB + 0.05f;
                                float invert = 1.0f - particleAABBAndBuffer * 2.0f;
                                if (pos.getY() != 0) {
                                    xRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                    zRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                } else if (pos.getX() != 0) {
                                    yRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                    zRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                } else if (pos.getZ() != 0) {
                                    yRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                    xRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                }
                                ParticleTexLeafColor particle = new ParticleTexLeafColor(worldRef, xx, yy, zz, 0.0, 0.0, 0.0, ParticleRegistry.leaf);
                                particle.setPos((double)xx + 0.5 + (double)pos.getX() * relAdj + xRand, (double)yy + 0.5 + (double)pos.getY() * relAdj + yRand, (double)zz + 0.5 + (double)pos.getZ() * relAdj + zRand);
                                particle.setPrevPosX(particle.getPosX());
                                particle.setPrevPosY(particle.getPosY());
                                particle.setPrevPosZ(particle.getPosZ());
                                particleBehavior.initParticleLeaf(particle, particleAABB);
                                spawnQueue.add((Particle)particle);
                            }
                        }
                    }
                    if (!(windStr >= 0.1f) || !(block instanceof GrassBlock) && block.defaultMapColor() != MapColor.DIRT && block.defaultMapColor() != MapColor.SAND && block.defaultMapColor() != MapColor.PLANT) continue;
                    ++lastTickFoundBlocks;
                    boolean spawnInside = false;
                    boolean spawnAbove = false;
                    boolean spawnAboveSnow = false;
                    if (block instanceof GrassBlock || block.defaultMapColor() == MapColor.DIRT || block.defaultMapColor() == MapColor.SAND) {
                        spawnAbove = true;
                    }
                    int oddsTo1 = spawnRateRandChanceOdds;
                    if (block.defaultMapColor() == MapColor.PLANT) {
                        oddsTo1 = spawnRateRandChanceOdds / 3;
                        spawnInside = true;
                    }
                    if (CoroUtilMisc.random.nextInt(oddsTo1) != 0) continue;
                    BlockPos pos = new BlockPos(xx, yy, zz);
                    BlockPos posAbove = new BlockPos(xx, yy + 1, zz);
                    BlockState blockStateAbove = SceneEnhancer.getBlockState((Level)worldRef, posAbove);
                    if (blockStateAbove == null || !blockStateAbove.isAir() && !(blockStateAbove.getBlock() instanceof SnowLayerBlock)) continue;
                    spawnAboveSnow = blockStateAbove.getBlock() instanceof SnowLayerBlock;
                    boolean test = false;
                    if (!test) {
                        ParticleTexLeafColor dust = new ParticleTexLeafColor(worldRef, pos.getX(), spawnAboveSnow ? (double)posAbove.getY() : (double)pos.getY(), pos.getZ(), 0.0, 0.0, 0.0, ParticleRegistry.squareGrey);
                        if (spawnAbove) {
                            if (spawnAboveSnow) {
                                dust.setPosition(posAbove.getX(), (float)posAbove.getY() + 0.4f, posAbove.getZ());
                            } else {
                                dust.setPosition(posAbove.getX(), (float)posAbove.getY() + 0.1f, posAbove.getZ());
                            }
                        } else if (spawnInside) {
                            dust.setPosition((float)pos.getX() + rand.nextFloat(), (float)pos.getY() + rand.nextFloat(), (float)pos.getZ() + rand.nextFloat());
                        }
                        dust.setPrevPosX(dust.getPosX());
                        dust.setPrevPosY(dust.getPosY());
                        dust.setPrevPosZ(dust.getPosZ());
                        particleBehavior.initParticleDustGround(dust, spawnInside, spawnAboveSnow);
                        spawnQueue.add((Particle)dust);
                        continue;
                    }
                    DustEmitter dustEmitter = new DustEmitter(worldRef, pos.getX(), spawnAboveSnow ? (double)posAbove.getY() : (double)pos.getY(), pos.getZ(), 0.0, 0.0, 0.0);
                    dustEmitter.setLifetime(20);
                    spawnQueue.add((Particle)dustEmitter);
                }
            }
        }
    }

    public static BlockPos getRandomWorkingPos(Level world, BlockPos posOrigin) {
        Collections.shuffle(listPosRandom);
        for (BlockPos posRel : listPosRandom) {
            Block blockCheck = SceneEnhancer.getBlock(world, posOrigin.offset((Vec3i)posRel));
            if (blockCheck == null || !CoroUtilBlock.isAir((Block)blockCheck)) continue;
            return posRel;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tryWind(Level world) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        if (WeatherUtilParticle.fxLayers != null && (double)windMan.getWindSpeed(player.blockPosition()) >= 0.1) {
            for (Queue<Particle> type : WeatherUtilParticle.fxLayers.values()) {
                for (Particle particle : type) {
                    if (particle instanceof SuspendedParticle || WeatherUtilBlock.getPrecipitationHeightSafe(world, WeatherUtilParticle.getPos(particle)).getY() - 1 >= Mth.floor((double)particle.y) + 1 && !(particle instanceof ParticleTexFX)) continue;
                    if (particle instanceof FlameParticle && (double)windMan.getWindSpeed(player.blockPosition()) >= 0.2) {
                        ++particle.age;
                    }
                    windMan.applyWindForceNew(particle, 0.05f, 0.5f, true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Block getBlock(Level parWorld, BlockPos pos) {
        return SceneEnhancer.getBlock(parWorld, pos.getX(), pos.getY(), pos.getZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Block getBlock(Level parWorld, int x, int y, int z) {
        try {
            if (!parWorld.hasChunkAt(new BlockPos(x, 0, z))) {
                return null;
            }
            return parWorld.getBlockState(new BlockPos(x, y, z)).getBlock();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BlockState getBlockState(Level parWorld, BlockPos pos) {
        return SceneEnhancer.getBlockState(parWorld, pos.getX(), pos.getY(), pos.getZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BlockState getBlockState(Level parWorld, int x, int y, int z) {
        try {
            if (!parWorld.hasChunkAt(new BlockPos(x, 0, z))) {
                return null;
            }
            return parWorld.getBlockState(new BlockPos(x, y, z));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isFogOverridding() {
        Minecraft client = Minecraft.getInstance();
        BlockState blockAtCamera = client.gameRenderer.getMainCamera().getBlockAtCamera();
        if (blockAtCamera.getBlock().defaultMapColor() == MapColor.WATER) {
            return false;
        }
        return fogAdjuster.isFogOverriding();
    }

    public static void renderTick(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        ClientWeatherProxy weather = ClientWeatherProxy.get();
        if (client.level != null) {
            ClientWeatherHelper.get().controlVisuals(weather.getVanillaRainAmount() > 0.0f);
        }
    }

    public static void tickSandstorm() {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        ClientLevel world = client.level;
        WindManager windMan = ClientTickHandler.weatherManager.getWindManager();
        ClientTickHandler.getClientWeather();
        boolean farSpawn = Minecraft.getInstance().player.isSpectator() || !isPlayerOutside;
        float adjustAmountSmooth = 0.0f;
        WeatherObjectParticleStorm sandstorm = ClientTickHandler.weatherManager.getClosestParticleStormByIntensity(player.position(), WeatherObjectParticleStorm.StormType.SANDSTORM);
        if (sandstorm != null) {
            adjustAmountSmooth = sandstorm.getIntensity();
        }
        if (adjustAmountSmooth >= 0.25f) {
            ParticleTexFX part;
            TextureAtlasSprite sprite;
            BlockPos pos;
            Random rand = CoroUtilMisc.random();
            int spawnAreaSize = 80;
            double sandstormParticleRateDebris = ConfigSand.Sandstorm_Particle_Debris_effect_rate;
            double sandstormParticleRateDust = ConfigSand.Sandstorm_Particle_Dust_effect_rate;
            float adjustAmountSmooth75 = (adjustAmountSmooth += 0.5f) * 8.0f - 7.0f;
            if (farSpawn) {
                adjustAmountSmooth75 *= 0.3f;
            }
            if (Minecraft.getInstance().options.particles.get() == ParticleStatus.DECREASED) {
                adjustAmountSmooth75 *= 0.5f;
            } else if (Minecraft.getInstance().options.particles.get() == ParticleStatus.MINIMAL) {
                adjustAmountSmooth75 *= 0.25f;
            }
            adjustAmountSmooth75 *= SceneEnhancer.getParticleFadeInLerpForNewWeatherState();
            int i = 0;
            while ((double)i < (double)(60.0f * adjustAmountSmooth75) * sandstormParticleRateDust) {
                pos = CoroUtilBlock.blockPos((double)(player.getX() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)), (double)(player.getY() - 2.0 + (double)rand.nextInt(10)), (double)(player.getZ() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)));
                if (SceneEnhancer.canPrecipitateAt((Level)world, pos)) {
                    sprite = ParticleRegistry.cloud256;
                    part = new ParticleSandstorm((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle(part);
                    particleBehavior.initParticleSandstormDust(part);
                    SceneEnhancer.particleBehavior.particles.add(part);
                    part.spawnAsWeatherEffect();
                }
                ++i;
            }
            i = 0;
            while ((double)i < (double)(1.0f * adjustAmountSmooth75) * sandstormParticleRateDebris) {
                pos = CoroUtilBlock.blockPos((double)(player.getX() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)), (double)(player.getY() - 2.0 + (double)rand.nextInt(10)), (double)(player.getZ() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)));
                if (SceneEnhancer.canPrecipitateAt((Level)world, pos)) {
                    sprite = ParticleRegistry.tumbleweed;
                    part = new ParticleCrossSection((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle(part);
                    particleBehavior.initParticleSandstormTumbleweed(part);
                    SceneEnhancer.particleBehavior.particles.add(part);
                    part.spawnAsWeatherEffect();
                }
                ++i;
            }
            i = 0;
            while ((double)i < (double)(8.0f * adjustAmountSmooth75) * sandstormParticleRateDebris) {
                pos = CoroUtilBlock.blockPos((double)(player.getX() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)), (double)(player.getY() - 2.0 + (double)rand.nextInt(10)), (double)(player.getZ() + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2)));
                if (SceneEnhancer.canPrecipitateAt((Level)world, pos)) {
                    sprite = null;
                    int tex = rand.nextInt(3);
                    if (tex == 0) {
                        sprite = ParticleRegistry.debris_1;
                    } else if (tex == 1) {
                        sprite = ParticleRegistry.debris_2;
                    } else if (tex == 2) {
                        sprite = ParticleRegistry.debris_3;
                    }
                    ParticleSandstorm part2 = new ParticleSandstorm((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle(part2);
                    particleBehavior.initParticleSandstormDebris(part2);
                    SceneEnhancer.particleBehavior.particles.add(part2);
                    part2.spawnAsWeatherEffect();
                }
                ++i;
            }
        }
        SceneEnhancer.tickSandstormSound();
    }

    public static void tickSandstormSound() {
        Minecraft mc = Minecraft.getInstance();
        if (particleRateLerp > 0) {
            if ((float)particleRateLerp < 0.66f) {
                SceneEnhancer.tryPlayPlayerLockedSound(WeatherUtilSound.snd_sandstorm_low, 5, (Entity)mc.player, 0.6f);
            } else if ((float)particleRateLerp < 0.85f) {
                SceneEnhancer.tryPlayPlayerLockedSound(WeatherUtilSound.snd_sandstorm_med, 4, (Entity)mc.player, 0.6f);
            } else {
                SceneEnhancer.tryPlayPlayerLockedSound(WeatherUtilSound.snd_sandstorm_high, 3, (Entity)mc.player, 0.6f);
            }
        }
    }

    public static FogAdjuster getFogAdjuster() {
        if (fogAdjuster == null) {
            fogAdjuster = new FogAdjuster();
        }
        return fogAdjuster;
    }

    public static WeatherEventType getWeatherState() {
        ClientWeatherProxy clientWeather = ClientWeatherProxy.get();
        if (clientWeather.isSandstorm()) {
            return WeatherEventType.SANDSTORM;
        }
        if (clientWeather.isSnowstorm()) {
            return WeatherEventType.SNOWSTORM;
        }
        if (clientWeather.isHeatwave()) {
            return WeatherEventType.HEATWAVE;
        }
        if (clientWeather.getRainAmount() > 0.0f && clientWeather.getPrecipitationType(lastBiomeIn) == PrecipitationType.ACID) {
            return WeatherEventType.ACID_RAIN;
        }
        if (clientWeather.getRainAmount() > 0.0f && clientWeather.getPrecipitationType(lastBiomeIn) == PrecipitationType.NORMAL) {
            return WeatherEventType.HEAVY_RAIN;
        }
        if (clientWeather.getRainAmount() > 0.0f && clientWeather.getPrecipitationType(lastBiomeIn) == PrecipitationType.HAIL) {
            return WeatherEventType.HAIL;
        }
        return null;
    }

    public static float getParticleFadeInLerpForNewWeatherState() {
        return (float)particleRateLerp / (float)particleRateLerpMax;
    }

    public static boolean shouldRainHere(Level level, Biome biome, BlockPos pos) {
        return CoroUtilCompatibility.warmEnoughToRain((Biome)biome, (BlockPos)pos, (Level)level);
    }

    public static boolean shouldSnowHere(Level level, Biome biome, BlockPos pos) {
        return CoroUtilCompatibility.coldEnoughToSnow((Biome)biome, (BlockPos)pos, (Level)level);
    }

    public static void checkParticleBehavior() {
        if (particleBehavior == null) {
            particleBehavior = new ParticleBehaviorSandstorm(null);
        }
    }

    static {
        soundLocations = new ArrayList();
        soundTimeLocations = new HashMap();
        LEAVES_BLOCKS = new ArrayList<Block>();
        listPosRandom = new ArrayList<BlockPos>();
        RAIN_TEXTURES_GREEN = ResourceLocation.fromNamespaceAndPath((String)"weather2", (String)"textures/environment/rain_green.png");
        RAIN_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/environment/rain.png");
        FORCE_ON_DEBUG_TESTING = false;
        isPlayerOutside = true;
        isPlayerNearTornadoCached = false;
        lastWeatherType = null;
        particleRateLerp = 0;
        particleRateLerpMax = 100;
        lastBiomeIn = null;
        downfallSheetThreshold = 0.32f;
    }
}

