/*
 * Decompiled with CFR 0.152.
 */
package weather2.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import weather2.weathersystem.storm.StormObject;

public class MovingSoundStreamingSource
extends AbstractTickableSoundInstance {
    private StormObject storm = null;
    public float cutOffRange = 128.0f;
    public Vec3 realSource = null;
    public boolean lockToPlayer = false;
    private float extraVolumeAdjForDistScale = 1.0f;

    public MovingSoundStreamingSource(Vec3 parPos, SoundEvent event, SoundSource category, float parVolume, float parPitch, boolean lockToPlayer) {
        super(event, category, SoundInstance.createUnseededRandom());
        this.looping = false;
        this.volume = parVolume;
        this.extraVolumeAdjForDistScale = parVolume;
        this.pitch = parPitch;
        this.realSource = parPos;
        this.lockToPlayer = lockToPlayer;
        this.tick();
    }

    public MovingSoundStreamingSource(Vec3 parPos, SoundEvent event, SoundSource category, float parVolume, float parPitch, float parCutOffRange) {
        super(event, category, SoundInstance.createUnseededRandom());
        this.looping = false;
        this.volume = parVolume;
        this.extraVolumeAdjForDistScale = parVolume;
        this.pitch = parPitch;
        this.cutOffRange = parCutOffRange;
        this.realSource = parPos;
        this.tick();
    }

    public MovingSoundStreamingSource(StormObject parStorm, SoundEvent event, SoundSource category, float parVolume, float parPitch, float parCutOffRange) {
        super(event, category, SoundInstance.createUnseededRandom());
        this.storm = parStorm;
        this.looping = false;
        this.volume = parVolume;
        this.extraVolumeAdjForDistScale = parVolume;
        this.pitch = parPitch;
        this.cutOffRange = parCutOffRange;
        this.tick();
    }

    public void tick() {
        LocalPlayer entP = Minecraft.getInstance().player;
        if (entP != null) {
            this.x = (float)entP.getX();
            this.y = (float)entP.getY();
            this.z = (float)entP.getZ();
        }
        if (this.storm != null) {
            this.realSource = this.storm.posGround;
        }
        if (!this.lockToPlayer) {
            double dist = this.getDistanceFrom(this.realSource, entP.position());
            this.volume = dist > (double)this.cutOffRange ? 0.0f : (float)(1.0 - dist / (double)this.cutOffRange) * this.extraVolumeAdjForDistScale;
        }
    }

    public double getDistanceFrom(Vec3 source, Vec3 targ) {
        return source.distanceTo(targ);
    }
}

