/*
 * Decompiled with CFR 0.152.
 */
package weather2.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import weather2.WeatherBlocks;
import weather2.config.ConfigWind;
import weather2.util.WeatherUtilEntity;
import weather2.util.WindReader;
import weather2.weathersystem.WeatherManager;

public class WindTurbineBlockEntity
extends BlockEntity {
    public float smoothAngle = 0.0f;
    public float smoothAnglePrev = 0.0f;
    public float smoothAngleRotationalVel = 0.0f;
    public boolean isOutsideCached = false;
    private boolean needsInit = true;
    private int maxNormalGenerated = ConfigWind.Wind_Turbine_FE_Generated_Per_Tick;
    private int capacity;
    private int maxTransfer = this.capacity = this.maxNormalGenerated * 2;
    private float lastWindSpeed = 0.0f;

    public WindTurbineBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(WeatherBlocks.BLOCK_ENTITY_WIND_TURBINE.get(), p_155229_, p_155230_);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WindTurbineBlockEntity entity) {
        entity.tick(level, pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        WeatherManager weatherManager;
        if (this.needsInit) {
            this.needsInit = false;
            this.updateIsOutside();
        }
        if (level.getGameTime() % 100L == 0L) {
            this.updateIsOutside();
        }
        if (this.isOutsideCached && level.getGameTime() % 20L == 0L && (weatherManager = WindReader.getWeatherManagerFor(level)) != null) {
            this.lastWindSpeed = weatherManager.getWindManager().getWindSpeedPositional(this.getBlockPos(), 2.0f, false);
        }
        if (!level.isClientSide) {
            if (this.isOutsideCached) {
                this.outputEnergy();
            }
        } else {
            if (this.isOutsideCached) {
                float windSpeed = this.lastWindSpeed;
                float rotMax = 100.0f;
                float maxSpeed = windSpeed / 2.0f * rotMax;
                if (this.smoothAngleRotationalVel < maxSpeed) {
                    this.smoothAngleRotationalVel += windSpeed * 0.3f;
                }
                if (this.smoothAngleRotationalVel > rotMax) {
                    this.smoothAngleRotationalVel = rotMax;
                }
                if (this.smoothAngle >= 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
            }
            this.smoothAnglePrev = this.smoothAngle;
            this.smoothAngle += this.smoothAngleRotationalVel;
            this.smoothAngleRotationalVel -= 0.01f;
            this.smoothAngleRotationalVel *= 0.99f;
            if (this.smoothAngleRotationalVel <= 0.0f) {
                this.smoothAngleRotationalVel = 0.0f;
            }
        }
    }

    public void updateIsOutside() {
        this.isOutsideCached = WeatherUtilEntity.isPosOutside(this.level, new Vec3((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f)), false, true);
    }

    public void outputEnergy() {
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
    }
}

