/*
 * Decompiled with CFR 0.152.
 */
package weather2.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import weather2.ServerTickHandler;
import weather2.WeatherBlocks;
import weather2.block.SensorBlock;
import weather2.config.ConfigMisc;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;

public class SensorBlockEntity
extends BlockEntity {
    public SensorBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(WeatherBlocks.BLOCK_ENTITY_TORNADO_SENSOR.get(), p_155229_, p_155230_);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
    }

    public static void tick(Level level, BlockPos pos2, BlockState state, SensorBlockEntity entity) {
        WeatherManagerServer wm;
        if (!level.isClientSide && level.getGameTime() % 100L == 0L && (wm = ServerTickHandler.getWeatherManagerFor(level)) != null) {
            Vec3 pos = new Vec3((double)pos2.getX(), (double)pos2.getY(), (double)pos2.getZ());
            StormObject so = wm.getClosestStorm(pos, ConfigMisc.sirenActivateDistance, StormObject.STATE_FORMING);
            if (so != null) {
                entity.setPoweredState(true);
            } else {
                entity.setPoweredState(false);
            }
        }
    }

    public void setPoweredState(boolean state) {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        if (blockState.getBlock() instanceof SensorBlock) {
            ((SensorBlock)blockState.getBlock()).setPoweredState(this.getBlockState(), this.level, this.getBlockPos(), state);
        }
    }
}

