/*
 * Decompiled with CFR 0.152.
 */
package weather2.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import weather2.WeatherBlocks;
import weather2.blockentity.SensorBlockEntity;

public class SensorBlock
extends BaseEntityBlock {
    public static final MapCodec<SensorBlock> CODEC = SensorBlock.simpleCodec(SensorBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public static final void register() {
    }

    public SensorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{POWERED});
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new SensorBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return SensorBlock.createTickerHelper(p_153214_, WeatherBlocks.BLOCK_ENTITY_TORNADO_SENSOR.get(), SensorBlockEntity::tick);
    }

    @Nullable
    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTicker(BlockEntityType<A> type, BlockEntityType<E> tickerType, BlockEntityTicker<? super E> ticker) {
        return tickerType == type ? ticker : null;
    }

    public int getSignal(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        return (Boolean)pState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public BlockState setPoweredState(BlockState pState, Level pLevel, BlockPos pPos, boolean state) {
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(state)), 3);
        pLevel.updateNeighborsAt(pPos, (Block)this);
        return pState;
    }

    public BlockState toggle(BlockState pState, Level pLevel, BlockPos pPos) {
        pState = (BlockState)pState.cycle((Property)POWERED);
        pLevel.setBlock(pPos, pState, 3);
        pLevel.updateNeighborsAt(pPos, (Block)this);
        return pState;
    }
}

