/*
 * Decompiled with CFR 0.152.
 */
package weather2.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import weather2.ServerTickHandler;
import weather2.config.ConfigStorm;
import weather2.weathersystem.WeatherManagerServer;

public class ForecastBlock
extends Block {
    public ForecastBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.use(state, level, pos, player, hand, hitResult) == InteractionResult.SUCCESS) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(state, level, pos, player, InteractionHand.MAIN_HAND, hitResult);
    }

    public InteractionResult use(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (!p_60504_.isClientSide) {
            int rateLessOften;
            int rateOften;
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)p_60506_.level().dimension());
            float chance = wm.getBiomeBasedStormSpawnChanceInArea(new BlockPos((Vec3i)p_60506_.blockPosition()));
            float chanceEvery10Days = 0.0f;
            int day = 24000;
            int diceRollRate = ConfigStorm.Storm_AllTypes_TickRateDelay;
            if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                rateOften = ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks / day;
                rateLessOften = ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks_Land_Based / day;
                chanceEvery10Days = ConfigStorm.Server_Storm_Deadly_OddsTo1_Land_Based;
            } else {
                rateOften = ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks / day;
                rateLessOften = ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks_Land_Based / day;
                chanceEvery10Days = ConfigStorm.Player_Storm_Deadly_OddsTo1_Land_Based;
            }
            if (chanceEvery10Days > 0.0f && diceRollRate > 0) {
                chanceEvery10Days = (float)day / (float)diceRollRate / chanceEvery10Days;
            }
            p_60506_.sendSystemMessage((Component)Component.literal((String)String.format("Chance of a deadly storm here every:", new Object[0])));
            p_60506_.sendSystemMessage((Component)Component.literal((String)(String.format("%d days: %.2f", rateOften, Float.valueOf(chance * 100.0f)) + "% from nearby biome temperature differences")));
            p_60506_.sendSystemMessage((Component)Component.literal((String)(String.format("%d days: %.2f", rateLessOften, Float.valueOf(chanceEvery10Days * 100.0f)) + "% from randomly trying once a day")));
            int count = 0;
            for (int i = 0; i < 100000; ++i) {
                if (p_60504_.random.nextInt(1000) != 0) continue;
                ++count;
            }
        }
        return InteractionResult.CONSUME;
    }
}

