/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import weather2.ClientTickHandler;
import weather2.PacketBase;
import weather2.PacketNBTFromClient;
import weather2.PacketNBTFromServer;
import weather2.WeatherNetworkingBase;

public class WeatherNetworkingv2
extends WeatherNetworkingBase {
    public static void register(Object ... args) {
        WeatherNetworkingv2.registerClientboundPacket(PacketNBTFromServer.TYPE, PacketNBTFromServer.STREAM_CODEC, PacketNBTFromServer::handle, args);
        WeatherNetworkingv2.registerServerboundPacket(PacketNBTFromClient.TYPE, PacketNBTFromClient.STREAM_CODEC, PacketNBTFromClient::handle, args);
    }

    public static <T extends PacketBase, B extends FriendlyByteBuf> void registerServerboundPacket(CustomPacketPayload.Type<T> type, StreamCodec<B, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        PayloadRegistrar registrar = (PayloadRegistrar)args[0];
        IPayloadHandler serverHandler = (packet, ctx) -> ctx.enqueueWork(() -> handler.accept(packet, ctx.player()));
        registrar.playToServer(type, codec, serverHandler);
    }

    public static <T extends PacketBase, B extends FriendlyByteBuf> void registerClientboundPacket(CustomPacketPayload.Type<T> type, StreamCodec<B, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        PayloadRegistrar registrar = (PayloadRegistrar)args[0];
        IPayloadHandler clientHandler = (packet, ctx) -> ctx.enqueueWork(() -> handler.accept(packet, ClientTickHandler.getPlayer()));
        registrar.playToClient(type, codec, clientHandler);
    }

    @Override
    public void clientSendToServer(CompoundTag data) {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketNBTFromClient(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void serverSendToClientAll(CompoundTag data) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PacketNBTFromServer(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void serverSendToClientPlayer(CompoundTag data, Player player) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new PacketNBTFromServer(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void serverSendToClientNear(CompoundTag data, Vec3 pos, double dist, Level level) {
        PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)pos.x, (double)pos.y, (double)pos.z, (double)dist, (CustomPacketPayload)new PacketNBTFromServer(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void serverSendToClientsInDimension(CompoundTag data, Level level) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)level), (CustomPacketPayload)new PacketNBTFromServer(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

