/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredRegister;
import weather2.block.AnemometerBlock;
import weather2.block.DeflectorBlock;
import weather2.block.ForecastBlock;
import weather2.block.SandLayerBlock;
import weather2.block.SensorBlock;
import weather2.block.SirenBlock;
import weather2.block.WindTurbineBlock;
import weather2.block.WindVaneBlock;
import weather2.blockentity.AnemometerBlockEntity;
import weather2.blockentity.DeflectorBlockEntity;
import weather2.blockentity.SensorBlockEntity;
import weather2.blockentity.SirenBlockEntity;
import weather2.blockentity.WindTurbineBlockEntity;
import weather2.blockentity.WindVaneBlockEntity;

@Mod(value="weather2")
public class WeatherBlocks {
    public static final String SAND_LAYER = "sand_layer";
    public static final String DEFLECTOR = "weather_deflector";
    public static final String TORNADO_SENSOR = "tornado_sensor";
    public static final String TORNADO_SIREN = "tornado_siren";
    public static final String WEATHER_MACHINE = "weather_machine";
    public static final String WEATHER_FORECAST = "weather_forecast";
    public static final String WIND_VANE = "wind_vane";
    public static final String ANEMOMETER = "anemometer";
    public static final String TORNADO_SIREN_MANUAL = "tornado_siren_manual";
    public static final String SAND_LAYER_PLACEABLE = "sand_layer_placeable";
    public static final String WEATHER_ITEM = "weather_item";
    public static final String POCKET_SAND = "pocket_sand";
    public static final String WIND_TURBINE = "wind_turbine";
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"weather2");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"weather2");
    public static final Supplier<SandLayerBlock> BLOCK_SAND_LAYER = BLOCKS.register("sand_layer", () -> new SandLayerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).mapColor(MapColor.SAND).strength(0.1f).sound(SoundType.SAND)));
    public static final Supplier<DeflectorBlock> BLOCK_DEFLECTOR = BLOCKS.register("weather_deflector", () -> new DeflectorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).mapColor(MapColor.STONE).strength(0.5f, 6.0f).sound(SoundType.STONE)));
    public static final Supplier<ForecastBlock> BLOCK_FORECAST = BLOCKS.register("weather_forecast", () -> new ForecastBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.5f, 6.0f).sound(SoundType.STONE)));
    public static final Supplier<SensorBlock> BLOCK_TORNADO_SENSOR = BLOCKS.register("tornado_sensor", () -> new SensorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.5f, 6.0f).sound(SoundType.STONE)));
    public static final Supplier<AnemometerBlock> BLOCK_ANEMOMETER = BLOCKS.register("anemometer", () -> new AnemometerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.5f, 6.0f).sound(SoundType.STONE)));
    public static final Supplier<WindVaneBlock> BLOCK_WIND_VANE = BLOCKS.register("wind_vane", () -> new WindVaneBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.5f, 6.0f).sound(SoundType.STONE)));
    public static final Supplier<SirenBlock> BLOCK_TORNADO_SIREN = BLOCKS.register("tornado_siren", () -> new SirenBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.5f, 6.0f).sound(SoundType.STONE)));
    public static final Supplier<WindTurbineBlock> BLOCK_WIND_TURBINE = BLOCKS.register("wind_turbine", () -> new WindTurbineBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.5f, 6.0f).sound(SoundType.STONE)));
    public static final Supplier<BlockEntityType<DeflectorBlockEntity>> BLOCK_ENTITY_DEFLECTOR = BLOCK_ENTITIES.register("weather_deflector", () -> BlockEntityType.Builder.of(DeflectorBlockEntity::new, (Block[])new Block[]{(Block)BLOCK_DEFLECTOR.get()}).build(null));
    public static final Supplier<BlockEntityType<SirenBlockEntity>> BLOCK_ENTITY_TORNADO_SIREN = BLOCK_ENTITIES.register("tornado_siren", () -> BlockEntityType.Builder.of(SirenBlockEntity::new, (Block[])new Block[]{(Block)BLOCK_TORNADO_SIREN.get()}).build(null));
    public static final Supplier<BlockEntityType<SensorBlockEntity>> BLOCK_ENTITY_TORNADO_SENSOR = BLOCK_ENTITIES.register("tornado_sensor", () -> BlockEntityType.Builder.of(SensorBlockEntity::new, (Block[])new Block[]{(Block)BLOCK_TORNADO_SENSOR.get()}).build(null));
    public static final Supplier<BlockEntityType<AnemometerBlockEntity>> BLOCK_ENTITY_ANEMOMETER = BLOCK_ENTITIES.register("anemometer", () -> BlockEntityType.Builder.of(AnemometerBlockEntity::new, (Block[])new Block[]{(Block)BLOCK_ANEMOMETER.get()}).build(null));
    public static final Supplier<BlockEntityType<WindVaneBlockEntity>> BLOCK_ENTITY_WIND_VANE = BLOCK_ENTITIES.register("wind_vane", () -> BlockEntityType.Builder.of(WindVaneBlockEntity::new, (Block[])new Block[]{(Block)BLOCK_WIND_VANE.get()}).build(null));
    public static final Supplier<BlockEntityType<WindTurbineBlockEntity>> BLOCK_ENTITY_WIND_TURBINE = BLOCK_ENTITIES.register("wind_turbine", () -> BlockEntityType.Builder.of(WindTurbineBlockEntity::new, (Block[])new Block[]{(Block)BLOCK_WIND_TURBINE.get()}).build(null));

    public static void registerHandlers(IEventBus modBus) {
        BLOCKS.register(modBus);
        BLOCK_ENTITIES.register(modBus);
    }
}

