/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.IConfigCategory;
import com.mojang.brigadier.CommandDispatcher;
import extendedrenderer.particle.ParticleRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import weather2.ClientRegistry;
import weather2.ClientTickHandler;
import weather2.EntityRegistry;
import weather2.EventHandlerForge;
import weather2.ServerTickHandler;
import weather2.SoundRegistry;
import weather2.WeatherBlocks;
import weather2.WeatherItems;
import weather2.WeatherNetworkingv2;
import weather2.command.WeatherCommand;
import weather2.config.ConfigDebug;
import weather2.config.ConfigMisc;
import weather2.config.ConfigParticle;
import weather2.config.ConfigSand;
import weather2.config.ConfigSnow;
import weather2.config.ConfigSound;
import weather2.config.ConfigStorm;
import weather2.config.ConfigTornado;
import weather2.config.ConfigWind;
import weather2.data.BlockAndItemProvider;
import weather2.data.BlockLootTables;
import weather2.data.WeatherRecipeProvider;
import weather2.util.WeatherUtilSound;

@Mod(value="weather2")
public class Weather {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "weather2";
    public static boolean initProperNeededForWorld = true;
    public static List<IConfigCategory> listConfigs = new ArrayList<IConfigCategory>();
    public static ConfigMisc configMisc = null;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"weather2");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> WEATHER_TAB = CREATIVE_MODE_TABS.register("weather_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).title((Component)Component.translatable((String)"itemGroup.weather2")).icon(() -> ((Item)WeatherItems.WEATHER_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)WeatherItems.WEATHER_ITEM.get());
        output.accept((ItemLike)WeatherItems.BLOCK_TORNADO_SIREN_ITEM.get());
        output.accept((ItemLike)WeatherItems.BLOCK_TORNADO_SENSOR_ITEM.get());
        output.accept((ItemLike)WeatherItems.BLOCK_DEFLECTOR_ITEM.get());
        output.accept((ItemLike)WeatherItems.BLOCK_FORECAST_ITEM.get());
        output.accept((ItemLike)WeatherItems.BLOCK_SAND_LAYER_ITEM.get());
        output.accept((ItemLike)WeatherItems.BLOCK_ANEMOMETER_ITEM.get());
        output.accept((ItemLike)WeatherItems.BLOCK_WIND_VANE_ITEM.get());
        output.accept((ItemLike)WeatherItems.BLOCK_WIND_TURBINE_ITEM.get());
    }).build());

    public Weather(ModContainer modContainer) {
        new WeatherNetworkingv2();
        EntityRegistry.init(modContainer);
        IEventBus modBus = modContainer.getEventBus();
        modBus.addListener(this::setup);
        NeoForge.EVENT_BUS.addListener(this::serverStop);
        NeoForge.EVENT_BUS.addListener(this::serverStart);
        NeoForge.EVENT_BUS.register(ServerTickHandler.class);
        CREATIVE_MODE_TABS.register(modBus);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::gatherData);
        modBus.addListener(this::processIMC);
        modBus.addListener(this::addCreative);
        NeoForge.EVENT_BUS.register((Object)this);
        WeatherBlocks.registerHandlers(modBus);
        WeatherItems.registerHandlers(modBus);
        NeoForge.EVENT_BUS.register((Object)new EventHandlerForge());
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        modContainer.getEventBus().addListener(this::registerPackets);
        new File("./config/Weather2").mkdirs();
        configMisc = new ConfigMisc();
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(configMisc));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigWind()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigSand()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigSnow()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigStorm()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigTornado()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigParticle()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigDebug()));
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)Weather.addConfig(new ConfigSound()));
        SoundRegistry.init();
        if (FMLEnvironment.dist.isClient()) {
            modBus.addListener(ParticleRegistry::getRegisteredParticles);
            modBus.addListener(ClientRegistry::clientSetup);
            modBus.addListener(ClientRegistry::registerRenderers);
            modBus.addListener(ClientRegistry::registerLayerDefinitions);
            NeoForge.EVENT_BUS.addListener(ClientTickHandler::tick);
        }
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1.0.0");
        WeatherNetworkingv2.register(registrar);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            event.accept((ItemLike)WeatherItems.WEATHER_ITEM.get());
        }
    }

    public static IConfigCategory addConfig(IConfigCategory config) {
        listConfigs.add(config);
        return config;
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        WeatherUtilSound.init();
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void serverStart(ServerStartedEvent event) {
    }

    @SubscribeEvent
    public void serverStop(ServerStoppedEvent event) {
        initProperNeededForWorld = true;
    }

    public static void dbg(Object obj) {
        CULog.dbg((String)String.valueOf(obj));
    }

    public static boolean isLoveTropicsInstalled() {
        return ModList.get().isLoaded("ltminigames");
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        WeatherCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.addProvider(event.includeServer(), (DataProvider)new WeatherRecipeProvider(gen.getPackOutput(), event.getLookupProvider()));
            gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(gen.getPackOutput(), Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTables::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        }
        if (event.includeClient()) {
            this.gatherClientData(event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void gatherClientData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new ParticleRegistry(packOutput, event.getLookupProvider(), existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockAndItemProvider(packOutput, event.getLookupProvider(), existingFileHelper));
    }
}

