/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigMod;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import weather2.WeatherNetworkingv2;
import weather2.config.ClientConfigData;
import weather2.config.ConfigMisc;
import weather2.config.WeatherUtilConfig;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;

@Mod(value="weather2")
public class ServerTickHandler {
    private static final Map<ResourceKey<Level>, WeatherManagerServer> MANAGERS = new Reference2ObjectOpenHashMap();
    private static final HashMap<String, WeatherManagerServer> MANAGERSLOOKUP = new HashMap();

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        if (!world.isClientSide() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            ResourceKey dimension = serverWorld.dimension();
            WeatherManagerServer weatherManagerServer = new WeatherManagerServer(serverWorld);
            if (WeatherUtilConfig.listDimensionsWeather.contains(weatherManagerServer.getWorld().dimension().location().toString())) {
                weatherManagerServer.read();
            }
            MANAGERS.put((ResourceKey<Level>)dimension, weatherManagerServer);
            MANAGERSLOOKUP.put(dimension.location().toString(), weatherManagerServer);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        if (!world.isClientSide() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            MANAGERS.remove(serverWorld.dimension());
            MANAGERSLOOKUP.remove(serverWorld.dimension().toString());
        }
    }

    @SubscribeEvent
    public static void tickServer(ServerTickEvent.Pre event) {
        for (WeatherManagerServer manager : MANAGERS.values()) {
            manager.tick();
        }
        ServerTickHandler.processIMCMessages();
    }

    @SubscribeEvent
    public static void tickServer(LevelTickEvent.Post event) {
        if (event.getLevel().dimension() == Level.OVERWORLD && !event.getLevel().isClientSide() && ConfigMisc.Aesthetic_Only_Mode && !ConfigMisc.overcastMode) {
            ConfigMisc.overcastMode = true;
            CULog.dbg((String)"detected Aesthetic_Only_Mode on, setting overcast mode on");
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            ServerTickHandler.syncServerConfigToClient(null);
        }
    }

    public static void processIMCMessages() {
        InterModComms.getMessages((String)"weather2").forEach(msg -> {
            CompoundTag tag = (CompoundTag)msg.messageSupplier().get();
            String dimResource = tag.getString("dimension");
            WeatherManagerServer wm = MANAGERSLOOKUP.get(dimResource);
            if (wm != null) {
                if (msg.method().equals("player_tornado")) {
                    int timeTicks = tag.getInt("time_ticks");
                    boolean baby = tag.getBoolean("baby");
                    String uuid = tag.getString("uuid");
                    Player player = wm.getWorld().getPlayerByUUID(UUID.fromString(uuid));
                    if (player != null) {
                        StormObject stormObject = new StormObject(wm);
                        stormObject.setupStorm((Entity)player);
                        stormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                        stormObject.levelStormIntensityMax = StormObject.STATE_STAGE1;
                        stormObject.setupPlayerControlledTornado((Entity)player);
                        stormObject.setPlayerControlledTimeLeft(timeTicks);
                        stormObject.setBaby(baby);
                        wm.addStormObject(stormObject);
                        wm.syncStormNew(stormObject);
                        CULog.dbg((String)("processed imc message: " + String.valueOf(tag)));
                    } else {
                        CULog.err((String)("error cant find player in dimension " + dimResource + " for uuid " + uuid + " via IMC"));
                    }
                } else if (msg.method().equals("sharknado")) {
                    StormObject stormObject = new StormObject(wm);
                    stormObject.setupStorm(null);
                    stormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                    stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
                    stormObject.setSharknado(true);
                    stormObject.setupTornadoAwayFromPlayersAimAtPlayers();
                    wm.addStormObject(stormObject);
                    wm.syncStormNew(stormObject);
                    CULog.dbg((String)("processed imc message: " + String.valueOf(tag) + " - " + String.valueOf(msg) + " - " + String.valueOf(wm.dimension)));
                } else if (msg.method().equals("firenado")) {
                    StormObject stormObject = new StormObject(wm);
                    stormObject.setupStorm(null);
                    stormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                    stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
                    stormObject.isFirenado = true;
                    stormObject.setupTornadoAwayFromPlayersAimAtPlayers();
                    wm.addStormObject(stormObject);
                    wm.syncStormNew(stormObject);
                    CULog.dbg((String)("processed imc message: " + String.valueOf(tag)));
                } else if (msg.method().equals("tornado")) {
                    StormObject stormObject = new StormObject(wm);
                    stormObject.setupStorm(null);
                    stormObject.levelCurIntensityStage = StormObject.STATE_STAGE1;
                    stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
                    stormObject.setSharknado(false);
                    stormObject.setupTornadoAwayFromPlayersAimAtPlayers();
                    wm.addStormObject(stormObject);
                    wm.syncStormNew(stormObject);
                    CULog.dbg((String)("processed imc message: " + String.valueOf(tag)));
                }
            } else {
                CULog.err((String)("error cant find WeatherManagerServer for dimension " + dimResource + " via IMC"));
            }
        });
    }

    @SubscribeEvent
    public static void tickPlayer(PlayerTickEvent.Pre event) {
        if (!event.getEntity().level().isClientSide()) {
            ServerTickHandler.syncServerConfigToClient(event.getEntity());
        }
    }

    public static void joinPlayer(PlayerEvent.PlayerLoggedInEvent event) {
    }

    public static WeatherManagerServer getWeatherManagerFor(ResourceKey<Level> dimension) {
        return MANAGERS.get(dimension);
    }

    public static WeatherManagerServer getWeatherManagerFor(Level level) {
        return MANAGERS.get(level.dimension());
    }

    public static void playerClientRequestsFullSync(ServerPlayer entP) {
        WeatherManagerServer wm = MANAGERS.get(entP.level().dimension());
        if (wm != null) {
            wm.playerJoinedWorldSyncFull(entP);
        }
    }

    public static void syncServerConfigToClient(Player player) {
        CompoundTag data = new CompoundTag();
        data.putString("packetCommand", "ClientConfigData");
        data.putString("command", "syncUpdate");
        ClientConfigData.writeNBT(data);
        if (player != null) {
            WeatherNetworkingv2.instance().serverSendToClientPlayer(data, player);
        } else {
            WeatherNetworkingv2.instance().serverSendToClientAll(data);
        }
    }
}

