/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class PerlinNoiseHelper {
    private SimplexNoise simplexNoise;
    private PerlinNoise perlinNoise;
    private NormalNoise normalNoise;
    private static PerlinNoiseHelper instance = null;

    public SimplexNoise getSimplexNoise() {
        return this.simplexNoise;
    }

    public PerlinNoise getPerlinNoise() {
        return this.perlinNoise;
    }

    public NormalNoise getNormalNoise() {
        return this.normalNoise;
    }

    public static PerlinNoiseHelper get() {
        if (instance == null) {
            instance = new PerlinNoiseHelper();
        }
        return instance;
    }

    public PerlinNoiseHelper() {
        Random random = new Random(5L);
        this.simplexNoise = new SimplexNoise((RandomSource)new LegacyRandomSource(random.nextLong()));
        NoiseParameters noiseParameters = new NoiseParameters(-9, 1.0, 0.0, 3.0, 3.0, 3.0, 3.0);
        this.perlinNoise = PerlinNoise.create((RandomSource)new LegacyRandomSource(random.nextLong()), (int)noiseParameters.firstOctave(), (DoubleList)noiseParameters.amplitudes());
    }

    public static class NoiseParameters {
        private final int firstOctave;
        private final DoubleList amplitudes;
        public static final Codec<NoiseParameters> CODEC = RecordCodecBuilder.create(p_48510_ -> p_48510_.group((App)Codec.INT.fieldOf("firstOctave").forGetter(NoiseParameters::firstOctave), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(NoiseParameters::amplitudes)).apply((Applicative)p_48510_, NoiseParameters::new));

        public NoiseParameters(int p_48506_, List<Double> p_48507_) {
            this.firstOctave = p_48506_;
            this.amplitudes = new DoubleArrayList(p_48507_);
        }

        public NoiseParameters(int p_151854_, double ... p_151855_) {
            this.firstOctave = p_151854_;
            this.amplitudes = new DoubleArrayList(p_151855_);
        }

        public int firstOctave() {
            return this.firstOctave;
        }

        public DoubleList amplitudes() {
            return this.amplitudes;
        }
    }
}

