/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import weather2.ClientTickHandler;
import weather2.PacketBase;

public record PacketNBTFromServer(CompoundTag nbt) implements PacketBase
{
    public static final CustomPacketPayload.Type<PacketNBTFromServer> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"weather2", (String)"nbt_client"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketNBTFromServer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketNBTFromServer::nbt, PacketNBTFromServer::new);

    public PacketNBTFromServer(FriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
    }

    public void handle(Player player) {
        try {
            String packetCommand = this.nbt.getString("packetCommand");
            String command = this.nbt.getString("command");
            if (packetCommand.equals("WeatherData")) {
                ClientTickHandler.getClientWeather();
                ClientTickHandler.weatherManager.nbtSyncFromServer(this.nbt);
            } else if (packetCommand.equals("ClientConfigData") && command.equals("syncUpdate")) {
                ClientTickHandler.clientConfigData.readNBT(this.nbt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

