/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import weather2.PacketBase;
import weather2.ServerTickHandler;
import weather2.Weather;

public record PacketNBTFromClient(CompoundTag nbt) implements PacketBase
{
    public static final CustomPacketPayload.Type<PacketNBTFromClient> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"weather2", (String)"nbt_server"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketNBTFromClient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketNBTFromClient::nbt, PacketNBTFromClient::new);

    public PacketNBTFromClient(RegistryFriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
    }

    public void handle(Player player) {
        try {
            if (player instanceof ServerPlayer) {
                String packetCommand = this.nbt.getString("packetCommand");
                String command = this.nbt.getString("command");
                Weather.dbg("Weather2 packet command from client: " + packetCommand + " - " + command);
                if (packetCommand.equals("WeatherData") && command.equals("syncFull")) {
                    ServerTickHandler.playerClientRequestsFullSync((ServerPlayer)player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

