/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import weather2.ClientTickHandler;
import weather2.ClientWeatherProxy;
import weather2.client.SceneEnhancer;
import weather2.command.CommandWeather2Client;
import weather2.config.ConfigDebug;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

@Mod(value="weather2")
public class EventHandlerForge {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void worldRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            ClientTickHandler.getClientWeather();
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && ConfigDebug.Particle_engine_render) {
            ClientTickHandler.particleManagerExtended().render(event.getPoseStack(), null, Minecraft.getInstance().gameRenderer.lightTexture(), event.getCamera(), event.getPartialTick().getGameTimeDeltaPartialTick(false), event.getFrustum());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onFogColors(ViewportEvent.ComputeFogColor event) {
        SceneEnhancer.getFogAdjuster().onFogColors(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onFogRender(ViewportEvent.RenderFog event) {
        SceneEnhancer.getFogAdjuster().onFogRender(event);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        SceneEnhancer.renderTick(event);
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(EntityTickEvent.Pre event) {
        Entity ent = event.getEntity();
        if (ent.level().isClientSide && ent instanceof Player && ((Player)ent).isLocalPlayer()) {
            this.onClientPlayerUpdate(event);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        CompoundTag tag = event.getOriginal().getPersistentData();
        CompoundTag tag2 = event.getEntity().getPersistentData();
        tag2.putLong("lastSandstormTime", tag.getLong("lastSandstormTime"));
        tag2.putLong("lastStormDeadlyTime", tag.getLong("lastStormDeadlyTime"));
    }

    public void onServerPlayerUpdate(EntityTickEvent.Pre event) {
        Level level = event.getEntity().level();
        if (level.getGameTime() % 40L == 0L) {
            Entity ent = event.getEntity();
            Biome bgb = (Biome)level.getBiome(WeatherUtilBlock.getPrecipitationHeightSafe(level, new BlockPos(Mth.floor((double)ent.position().x), 0, Mth.floor((double)ent.position().z)))).value();
            float biomeTemp = CoroUtilCompatibility.getAdjustedTemperature((Level)ent.level(), (Biome)bgb, (BlockPos)new BlockPos(Mth.floor((double)ent.position().x), Mth.floor((double)ent.position().y), Mth.floor((double)ent.position().z)));
            CULog.dbg((String)("biomeTemp: " + biomeTemp));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientPlayerUpdate(EntityTickEvent.Pre event) {
        float playerSpeed;
        Entity ent = event.getEntity();
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        ClientWeatherProxy weather = ClientWeatherProxy.get();
        if ((weather.isSnowstorm() || weather.isSandstorm()) && ent.onGround() && !ent.isSpectator() && !WeatherUtilEntity.isPlayerSheltered(ent) && (playerSpeed = (float)Math.sqrt(ent.getDeltaMovement().x * ent.getDeltaMovement().x + ent.getDeltaMovement().z * ent.getDeltaMovement().z)) > 0.02f && playerSpeed < 0.3f) {
            float dampenRate;
            float dampen;
            float diffAngle;
            float playerAngle = -((float)Math.toDegrees(Math.atan2(ent.getDeltaMovement().x, ent.getDeltaMovement().z)));
            int phi = (int)(Math.abs(windMan.getWindAngle(ent.position()) - playerAngle) % 360.0f);
            float f = diffAngle = phi > 180 ? (float)(360 - phi) : (float)phi;
            if (diffAngle < 90.0f) {
                float assistRate = 1.0f - diffAngle / 90.0f;
                float assist = 1.0f + 0.12f * assistRate;
                ent.setDeltaMovement(ent.getDeltaMovement().x * (double)assist, ent.getDeltaMovement().y, ent.getDeltaMovement().z * (double)assist);
            } else if (diffAngle >= 90.0f && (dampen = 1.0f - 0.12f * (dampenRate = (diffAngle - 90.0f) / 90.0f)) != 0.0f) {
                ent.setDeltaMovement(ent.getDeltaMovement().x * (double)dampen, ent.getDeltaMovement().y, ent.getDeltaMovement().z * (double)dampen);
            }
        }
    }

    @SubscribeEvent
    public void registerCommandsClient(RegisterClientCommandsEvent event) {
        CommandWeather2Client.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

