/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import weather2.ClientTickHandler;
import weather2.ClientWeatherHelper;
import weather2.Weather;
import weather2.client.SceneEnhancer;
import weather2.datatypes.PrecipitationType;
import weather2.ltcompat.ClientWeatherIntegration;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;

public final class ClientWeatherProxy {
    private static ClientWeatherProxy instance;
    private static boolean cacheIsSnowstorm;
    private static boolean cacheIsSandstorm;
    private static boolean cacheIsHail;
    private static int cacheRate;

    private ClientWeatherProxy() {
    }

    public static ClientWeatherProxy get() {
        if (instance == null) {
            instance = new ClientWeatherProxy();
        }
        return instance;
    }

    public void reset() {
        cacheIsSnowstorm = false;
        cacheIsSandstorm = false;
        cacheIsHail = false;
    }

    public float getRainAmount() {
        if (this.isWeatherEffectsServerSideControlled()) {
            return ClientWeatherIntegration.get().getRainAmount();
        }
        return ClientWeatherHelper.get().getPrecipitationStrength((Player)Minecraft.getInstance().player);
    }

    public float getVanillaRainAmount() {
        if (Weather.isLoveTropicsInstalled()) {
            return ClientWeatherIntegration.get().getVanillaRainAmount();
        }
        return ClientWeatherHelper.get().getPrecipitationStrength((Player)Minecraft.getInstance().player);
    }

    @Nullable
    public PrecipitationType getPrecipitationType(Biome biome) {
        if (Weather.isLoveTropicsInstalled()) {
            return ClientWeatherIntegration.get().getPrecipitationType();
        }
        if (biome == null) {
            return null;
        }
        if (biome.hasPrecipitation() && biome.getModifiedClimateSettings().temperatureModifier() == Biome.TemperatureModifier.NONE) {
            return PrecipitationType.NORMAL;
        }
        if (biome.hasPrecipitation() && biome.getModifiedClimateSettings().temperatureModifier() == Biome.TemperatureModifier.FROZEN) {
            return PrecipitationType.SNOW;
        }
        if (!biome.hasPrecipitation()) {
            return null;
        }
        return null;
    }

    public float getWindSpeed() {
        System.out.println("client getWindSpeed" + ClientWeatherIntegration.get().getWindSpeed());
        return ClientWeatherIntegration.get().getWindSpeed();
    }

    public boolean isHeatwave() {
        return ClientWeatherIntegration.get().isHeatwave();
    }

    public boolean isSandstorm() {
        if (this.isWeatherEffectsServerSideControlled()) {
            return ClientWeatherIntegration.get().isSandstorm();
        }
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return false;
        }
        if (player.level().getGameTime() % (long)cacheRate == 0L) {
            Vec3 posPlayer = new Vec3(client.player.getX(), 0.0, client.player.getZ());
            WeatherObjectParticleStorm storm = ClientTickHandler.getClientWeather().getClosestParticleStormByIntensity(posPlayer, WeatherObjectParticleStorm.StormType.SANDSTORM);
            cacheIsSandstorm = storm != null && posPlayer.distanceTo(storm.pos) < (double)storm.getSize();
        }
        return cacheIsSandstorm;
    }

    public boolean isSnowstorm() {
        if (this.isWeatherEffectsServerSideControlled()) {
            return ClientWeatherIntegration.get().isSnowstorm();
        }
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return false;
        }
        if (player.level().getGameTime() % (long)cacheRate == 0L) {
            Vec3 posPlayer = new Vec3(client.player.getX(), 0.0, client.player.getZ());
            WeatherObjectParticleStorm storm = ClientTickHandler.weatherManager.getClosestParticleStormByIntensity(posPlayer, WeatherObjectParticleStorm.StormType.SNOWSTORM);
            cacheIsSnowstorm = storm != null && posPlayer.distanceTo(storm.pos) < (double)storm.getSize();
        }
        return cacheIsSnowstorm;
    }

    public boolean isHail() {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return false;
        }
        if (player.level().getGameTime() % (long)cacheRate == 0L) {
            double maxStormDist;
            Vec3 posPlayer = new Vec3(client.player.getX(), 0.0, client.player.getZ());
            StormObject storm = ClientTickHandler.weatherManager.getClosestStorm(posPlayer, maxStormDist = 384.0, StormObject.STATE_HAIL, StormObject.STATE_HAIL, false);
            cacheIsHail = storm != null && posPlayer.distanceTo(storm.posGround) < (double)storm.getSize();
        }
        return cacheIsHail;
    }

    public boolean hasWeather() {
        if (SceneEnhancer.FORCE_ON_DEBUG_TESTING) {
            return true;
        }
        return ClientWeatherIntegration.get().hasWeather();
    }

    public boolean isWeatherEffectsServerSideControlled() {
        return Weather.isLoveTropicsInstalled();
    }

    static {
        cacheIsSnowstorm = false;
        cacheIsSandstorm = false;
        cacheIsHail = false;
        cacheRate = 40;
    }
}

