/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import com.corosus.coroutil.util.CULog;
import extendedrenderer.ParticleManagerExtended;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import weather2.ClientWeatherHelper;
import weather2.ClientWeatherProxy;
import weather2.Weather;
import weather2.WeatherNetworkingv2;
import weather2.client.SceneEnhancer;
import weather2.config.ClientConfigData;
import weather2.config.ConfigDebug;
import weather2.util.WeatherUtil;
import weather2.util.WindReader;
import weather2.weathersystem.WeatherManagerClient;

public class ClientTickHandler {
    public static final ClientTickHandler INSTANCE = new ClientTickHandler();
    public static Level lastWorld;
    public static WeatherManagerClient weatherManager;
    public static SceneEnhancer sceneEnhancer;
    public static ClientConfigData clientConfigData;
    public float smoothAngle = 0.0f;
    public float smoothAngleRotationalVelAccel = 0.0f;
    public float smoothAngleAdj = 0.1f;
    public int prevDir = 0;
    public long lastParticleResetTime = 0L;
    private static ParticleManagerExtended particleManagerExtended;

    public ClientTickHandler() {
        if (sceneEnhancer == null) {
            sceneEnhancer = new SceneEnhancer();
            new Thread((Runnable)sceneEnhancer, "Weather2 Scene Enhancer").start();
        }
        clientConfigData = new ClientConfigData();
    }

    @SubscribeEvent
    public static void tick(ClientTickEvent.Pre event) {
        INSTANCE.onTickInGame();
    }

    public void onTickInGame() {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        if (world != null) {
            ClientTickHandler.getClientWeather();
            weatherManager.tick();
            sceneEnhancer.tickClient();
            if (!WeatherUtil.isPausedForClient() && ConfigDebug.Particle_engine_tick) {
                ClientTickHandler.particleManagerExtended().tick();
            }
            if (ConfigDebug.Particle_Reset_Frequency > 0 && this.lastParticleResetTime + (long)ConfigDebug.Particle_Reset_Frequency < world.getGameTime()) {
                CULog.log((String)"clearing vanilla particles, set Weather2 Debug Particle_Reset_Frequency to 0 to disable");
                this.lastParticleResetTime = world.getGameTime();
                mc.particleEngine.clearParticles();
            }
            float windDir = WindReader.getWindAngle((Level)world);
            float windSpeed = WindReader.getWindSpeed((Level)world, mc.player != null ? mc.player.blockPosition() : null);
            float diff = Math.abs(windDir - this.smoothAngle);
            if (diff > 10.0f) {
                if (this.smoothAngle > 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
                if (this.smoothAngle < -180.0f) {
                    this.smoothAngle += 360.0f;
                }
                float bestMove = Mth.wrapDegrees((float)(windDir - this.smoothAngle));
                this.smoothAngleAdj = windSpeed;
                if (Math.abs(bestMove) < 180.0f) {
                    float realAdj = this.smoothAngleAdj;
                    if (realAdj * 2.0f > windSpeed) {
                        if (bestMove > 0.0f) {
                            this.smoothAngleRotationalVelAccel -= realAdj;
                            if (this.prevDir < 0) {
                                this.smoothAngleRotationalVelAccel = 0.0f;
                            }
                            this.prevDir = 1;
                        } else if (bestMove < 0.0f) {
                            this.smoothAngleRotationalVelAccel += realAdj;
                            if (this.prevDir > 0) {
                                this.smoothAngleRotationalVelAccel = 0.0f;
                            }
                            this.prevDir = -1;
                        }
                    }
                    if ((double)this.smoothAngleRotationalVelAccel > 0.3 || (double)this.smoothAngleRotationalVelAccel < -0.3) {
                        this.smoothAngle += this.smoothAngleRotationalVelAccel * 0.3f;
                    }
                    this.smoothAngleRotationalVelAccel *= 0.8f;
                }
            }
        } else {
            ClientTickHandler.resetClientWeather();
        }
    }

    public static void resetClientWeather() {
        weatherManager = null;
        ClientWeatherProxy.get().reset();
        ClientWeatherHelper.get().reset();
    }

    public static WeatherManagerClient getClientWeather() {
        try {
            ClientLevel world = Minecraft.getInstance().level;
            if (weatherManager == null || world != lastWorld) {
                ClientTickHandler.init((Level)world);
            }
        }
        catch (Exception ex) {
            Weather.dbg("Weather2: Warning, client received packet before it was ready to use, and failed to init client weather due to null world");
        }
        return weatherManager;
    }

    public static void init(Level world) {
        Weather.dbg("Weather2: Initializing WeatherManagerClient for client world and requesting full sync");
        lastWorld = world;
        weatherManager = new WeatherManagerClient((ResourceKey<Level>)world.dimension());
        Minecraft mc = Minecraft.getInstance();
        if (particleManagerExtended == null) {
            particleManagerExtended = new ParticleManagerExtended(mc.level, mc.getTextureManager());
        } else {
            particleManagerExtended.setLevel((ClientLevel)world);
        }
        CompoundTag data = new CompoundTag();
        data.putString("command", "syncFull");
        data.putString("packetCommand", "WeatherData");
        WeatherNetworkingv2.instance().clientSendToServer(data);
    }

    public static ParticleManagerExtended particleManagerExtended() {
        return particleManagerExtended;
    }

    public static Player getPlayer() {
        return Minecraft.getInstance().player;
    }
}

