/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import extendedrenderer.particle.entity.ParticleTexFX;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import weather2.ClientTickHandler;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

public class ParticleTexExtraRender
extends ParticleTexFX {
    private int severityOfRainRate = 2;
    private int extraParticlesBaseAmount = 5;
    public boolean noExtraParticles = false;
    private float extraRandomSecondaryYawRotation = 360.0f;

    public ParticleTexExtraRender(ClientLevel worldIn, double posXIn, double posYIn, double posZIn, double mX, double mY, double mZ, TextureAtlasSprite par8Item) {
        super(worldIn, posXIn, posYIn, posZIn, mX, mY, mZ, par8Item);
    }

    public int getSeverityOfRainRate() {
        return this.severityOfRainRate;
    }

    public void setSeverityOfRainRate(int severityOfRainRate) {
        this.severityOfRainRate = severityOfRainRate;
    }

    public int getExtraParticlesBaseAmount() {
        return this.extraParticlesBaseAmount;
    }

    public void setExtraParticlesBaseAmount(int extraParticlesBaseAmount) {
        this.extraParticlesBaseAmount = extraParticlesBaseAmount;
    }

    @Override
    public void tickExtraRotations() {
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        if (this.isSlantParticleToWind()) {
            double speed = this.xd * this.xd + this.zd * this.zd;
            this.rotationYaw = -((float)Math.toDegrees(Math.atan2(this.zd, this.xd))) - 90.0f;
            this.rotationPitch = Math.min(45.0f, (float)(speed * 120.0));
            this.rotationPitch += (float)(this.getEntityId() % 10 - 5);
        }
        windMan.applyWindForceNew(this, 0.5f, 0.5f);
    }

    @Override
    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion;
        Vec3 Vector3d = renderInfo.getPosition();
        if (this.facePlayer || this.rotationPitch == 0.0f && this.rotationYaw == 0.0f) {
            quaternion = renderInfo.rotation();
        } else {
            quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
            quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(this.rotationYaw));
            quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(this.rotationPitch));
            if (this.extraRandomSecondaryYawRotation > 0.0f) {
                quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees((float)this.getEntityId() % this.extraRandomSecondaryYawRotation));
            }
        }
        float posX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - Vector3d.x());
        float posY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - Vector3d.y());
        float posZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - Vector3d.z());
        float f = this.getU0();
        float f1 = this.getU1();
        float f2 = this.getV0();
        float f3 = this.getV1();
        float fixY = 0.0f;
        float part = 5.3333335f;
        float offset = 0.0f;
        float posBottom = (float)(this.y - 10.0);
        float height = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, CoroUtilBlock.blockPos((double)this.x, (double)this.y, (double)this.z)).getY();
        if (posBottom < height) {
            float diff;
            offset = diff = height - posBottom;
            fixY = 0.0f;
            if (offset > part) {
                offset = part;
            }
        }
        int renderAmount = 0;
        renderAmount = this.noExtraParticles ? 1 : Math.min(1 + this.extraParticlesBaseAmount, CoroUtilParticle.maxRainDrops);
        try {
            for (int ii = 0; ii < renderAmount; ++ii) {
                int height2;
                double xx = 0.0;
                double zz = 0.0;
                double yy = 0.0;
                if (ii != 0) {
                    xx = CoroUtilParticle.rainPositions[ii].x;
                    zz = CoroUtilParticle.rainPositions[ii].z;
                    yy = CoroUtilParticle.rainPositions[ii].y;
                }
                if (this.isDontRenderUnderTopmostBlock() && this.y + yy < (double)(height2 = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, CoroUtilBlock.blockPos((double)(this.x + xx), (double)this.y, (double)(this.z + zz))).getY())) continue;
                int i = this.getLightColor(partialTicks);
                if (i > 0) {
                    this.setLastNonZeroBrightness(i);
                } else {
                    i = this.getLastNonZeroBrightness();
                }
                Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
                float scale = this.getQuadSize(partialTicks);
                for (int v = 0; v < 4; ++v) {
                    Vector3f vector3f = avector3f[v];
                    vector3f.rotate((Quaternionfc)quaternion);
                    vector3f.mul(scale);
                    vector3f.add(posX, posY, posZ);
                }
                buffer.addVertex((float)(xx + (double)avector3f[0].x()), (float)(yy + (double)avector3f[0].y()), (float)(zz + (double)avector3f[0].z())).setUv(f1, f3).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(i);
                buffer.addVertex((float)(xx + (double)avector3f[1].x()), (float)(yy + (double)avector3f[1].y()), (float)(zz + (double)avector3f[1].z())).setUv(f1, f2).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(i);
                buffer.addVertex((float)(xx + (double)avector3f[2].x()), (float)(yy + (double)avector3f[2].y()), (float)(zz + (double)avector3f[2].z())).setUv(f, f2).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(i);
                buffer.addVertex((float)(xx + (double)avector3f[3].x()), (float)(yy + (double)avector3f[3].y()), (float)(zz + (double)avector3f[3].z())).setUv(f, f3).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(i);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

