/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilBlock;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.entity.ParticleTexFX;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ParticleCube
extends ParticleTexFX {
    public ParticleCube(Level worldIn, double posXIn, double posYIn, double posZIn, double mX, double mY, double mZ, BlockState state) {
        super((ClientLevel)worldIn, posXIn, posYIn, posZIn, mX, mY, mZ, ParticleRegistry.potato);
        TextureAtlasSprite sprite = this.getSpriteFromState(state);
        if (sprite != null) {
            this.setSprite(sprite);
        } else {
            CULog.dbg((String)("unable to find sprite to use from block: " + String.valueOf(state)));
            sprite = this.getSpriteFromState(Blocks.DIRT.defaultBlockState());
            if (sprite != null) {
                this.setSprite(sprite);
            }
        }
        int multiplier = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)this.level, CoroUtilBlock.blockPos((double)posXIn, (double)posYIn, (double)posZIn), 0);
        float mr = (float)(multiplier >>> 16 & 0xFF) / 255.0f;
        float mg = (float)(multiplier >>> 8 & 0xFF) / 255.0f;
        float mb = (float)(multiplier & 0xFF) / 255.0f;
        this.setColor(mr, mg, mb);
    }

    public TextureAtlasSprite getSpriteFromState(BlockState state) {
        BlockRenderDispatcher blockrenderdispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = blockrenderdispatcher.getBlockModel(state);
        for (Direction direction : Direction.values()) {
            List list = model.getQuads(state, direction, RandomSource.create());
            if (list.size() > 0) {
                return ((BakedQuad)list.get(0)).getSprite();
            }
            if (model.getParticleIcon() == null) continue;
            return model.getParticleIcon();
        }
        return null;
    }

    @Override
    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        int j;
        Quaternionf quaternion;
        Vec3 Vector3d = renderInfo.getPosition();
        float f = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - Vector3d.x());
        float f1 = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - Vector3d.y());
        float f2 = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - Vector3d.z());
        if (this.facePlayer || this.rotationPitch == 0.0f && this.rotationYaw == 0.0f) {
            quaternion = renderInfo.rotation();
        } else {
            quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
            if (this.facePlayerYaw) {
                quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(-renderInfo.getYRot()));
            } else {
                quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)this.prevRotationYaw, (float)this.rotationYaw)));
            }
            quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)this.prevRotationPitch, (float)this.rotationPitch)));
        }
        Object sprite = null;
        ArrayList<Vector3f[]> faces = new ArrayList<Vector3f[]>();
        Vector3f[] face = new Vector3f[]{new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f)};
        faces.add(face);
        face = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f)};
        faces.add(face);
        face = new Vector3f[]{new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f)};
        faces.add(face);
        face = new Vector3f[]{new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f)};
        faces.add(face);
        face = new Vector3f[]{new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, -1.0f)};
        faces.add(face);
        face = new Vector3f[]{new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f)};
        faces.add(face);
        float f4 = this.getQuadSize(partialTicks);
        for (Vector3f[] entryFace : faces) {
            for (int i = 0; i < 4; ++i) {
                entryFace[i].rotate((Quaternionfc)quaternion);
                entryFace[i].mul(f4);
                entryFace[i].add(f, f1, f2);
            }
        }
        float f7 = this.getU0();
        float f8 = this.getU1();
        float f5 = this.getV0();
        float f6 = this.getV1();
        if (sprite != null) {
            f7 = sprite.getU0();
            f8 = sprite.getU1();
            f5 = sprite.getV0();
            f6 = sprite.getV1();
        }
        if ((j = this.getLightColor(partialTicks)) > 0) {
            this.lastNonZeroBrightness = j;
        } else {
            j = this.lastNonZeroBrightness;
        }
        for (Vector3f[] entryFace : faces) {
            buffer.addVertex(entryFace[0].x(), entryFace[0].y(), entryFace[0].z()).setUv(f8, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
            buffer.addVertex(entryFace[1].x(), entryFace[1].y(), entryFace[1].z()).setUv(f8, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
            buffer.addVertex(entryFace[2].x(), entryFace[2].y(), entryFace[2].z()).setUv(f7, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
            buffer.addVertex(entryFace[3].x(), entryFace[3].y(), entryFace[3].z()).setUv(f7, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return SORTED_OPAQUE_BLOCK;
    }
}

