/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilMisc;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.PivotingParticle;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import weather2.ClientTickHandler;
import weather2.IWindHandler;
import weather2.config.ConfigParticle;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

@OnlyIn(value=Dist.CLIENT)
public class EntityRotFX
extends TextureSheetParticle
implements IWindHandler {
    public static final ParticleRenderType SORTED_TRANSLUCENT = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.disableCull();
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT.begin(tesselator, textureManager);
        }

        public String toString() {
            return "PARTICLE_SHEET_SORTED_TRANSLUCENT";
        }
    };
    public static final ParticleRenderType SORTED_OPAQUE_BLOCK = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "PARTICLE_BLOCK_SHEET_SORTED_OPAQUE";
        }
    };
    public boolean weatherEffect = false;
    public float spawnY = -1.0f;
    public int particleTextureIndexInt = 0;
    public float brightness = 0.7f;
    public boolean callUpdateSuper = true;
    public boolean callUpdatePB = true;
    public float renderRange = 128.0f;
    public int renderOrder = 0;
    private int entityID = 0;
    public int debugID = 0;
    public float prevRotationYaw;
    public float rotationYaw;
    public float prevRotationPitch;
    public float rotationPitch;
    public float windWeight = 5.0f;
    public boolean isTransparent = true;
    public boolean killOnCollide = false;
    public int killOnCollideActivateAtAge = 0;
    public boolean facePlayer = false;
    public boolean facePlayerYaw = false;
    public boolean vanillaMotionDampen = true;
    public double aboveGroundHeight = 4.5;
    public boolean checkAheadToBounce = true;
    public boolean collisionSpeedDampen = true;
    public double bounceSpeed = 0.05;
    public double bounceSpeedMax = 0.15;
    public double bounceSpeedAhead = 0.35;
    public double bounceSpeedMaxAhead = 0.25;
    public boolean bounceOnVerticalImpact = false;
    public double bounceOnVerticalImpactEnergy = 0.3f;
    public boolean spinFast = false;
    public float spinFastRate = 10.0f;
    public boolean spinTowardsMotionDirection = false;
    private float ticksFadeInMax = 0.0f;
    private float ticksFadeOutMax = 0.0f;
    private float fullAlphaTarget = 1.0f;
    private boolean dontRenderUnderTopmostBlock = false;
    private boolean killWhenUnderTopmostBlock = false;
    private int killWhenUnderTopmostBlock_ScanAheadRange = 0;
    public int killWhenUnderCameraAtLeast = 0;
    public int killWhenFarFromCameraAtLeast = 0;
    private float ticksFadeOutMaxOnDeath = -1.0f;
    private float ticksFadeOutCurOnDeath = 0.0f;
    protected boolean fadingOut = false;
    public float avoidTerrainAngle = 0.0f;
    public boolean useRotationAroundCenter = false;
    public float rotationAroundCenter = 0.0f;
    public float rotationAroundCenterPrev = 0.0f;
    public float rotationSpeedAroundCenter = 0.0f;
    public float rotationDistAroundCenter = 0.0f;
    private boolean slantParticleToWind = false;
    public boolean quatControl = false;
    public boolean fastLight = false;
    public float brightnessCache = 0.5f;
    public boolean rotateOrderXY = false;
    public float extraYRotation = 0.0f;
    public boolean markCollided = false;
    public boolean isCollidedHorizontally = false;
    public boolean isCollidedVerticallyDownwards = false;
    public boolean isCollidedVerticallyUpwards = false;
    public Vector3f rotationAround = new Vector3f();
    protected int lastNonZeroBrightness = 0xF00000;
    public ParticleBehaviors pb = null;
    private boolean useCustomBBForRenderCulling = false;
    private static final AABB INITIAL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private AABB bbRender = INITIAL_AABB;
    private float renderDistanceCull = -1.0f;
    private boolean useDynamicWindSpeed = true;

    public EntityRotFX(ClientLevel par1World, double par2, double par4, double par6, double par8, double par10, double par12) {
        super(par1World, par2, par4, par6, par8, par10, par12);
        this.setSize(0.3f, 0.3f);
        this.entityID = CoroUtilMisc.random.nextInt(100000);
    }

    public boolean isSlantParticleToWind() {
        return this.slantParticleToWind;
    }

    public void setSlantParticleToWind(boolean slantParticleToWind) {
        this.slantParticleToWind = slantParticleToWind;
    }

    public float getTicksFadeOutMaxOnDeath() {
        return this.ticksFadeOutMaxOnDeath;
    }

    public void setTicksFadeOutMaxOnDeath(float ticksFadeOutMaxOnDeath) {
        this.ticksFadeOutMaxOnDeath = ticksFadeOutMaxOnDeath;
    }

    public boolean isKillWhenUnderTopmostBlock() {
        return this.killWhenUnderTopmostBlock;
    }

    public void setKillWhenUnderTopmostBlock(boolean killWhenUnderTopmostBlock) {
        this.killWhenUnderTopmostBlock = killWhenUnderTopmostBlock;
    }

    public boolean isDontRenderUnderTopmostBlock() {
        return this.dontRenderUnderTopmostBlock;
    }

    public void setDontRenderUnderTopmostBlock(boolean dontRenderUnderTopmostBlock) {
        this.dontRenderUnderTopmostBlock = dontRenderUnderTopmostBlock;
    }

    public float getTicksFadeInMax() {
        return this.ticksFadeInMax;
    }

    public void setTicksFadeInMax(float ticksFadeInMax) {
        this.ticksFadeInMax = ticksFadeInMax;
    }

    public float getTicksFadeOutMax() {
        return this.ticksFadeOutMax;
    }

    public void setTicksFadeOutMax(float ticksFadeOutMax) {
        this.ticksFadeOutMax = ticksFadeOutMax;
    }

    public int getParticleTextureIndex() {
        return this.particleTextureIndexInt;
    }

    public void setLifetime(int par) {
        this.lifetime = par;
    }

    public float getAlphaF() {
        return this.alpha;
    }

    public void remove() {
        if (this.pb != null) {
            this.pb.particles.remove(this);
        }
        super.remove();
    }

    public void tick() {
        super.tick();
        this.prevRotationPitch = this.rotationPitch;
        if (!(this instanceof PivotingParticle)) {
            this.prevRotationYaw = this.rotationYaw;
        }
        Entity ent = Minecraft.getInstance().getCameraEntity();
        if (!this.isVanillaMotionDampen()) {
            this.xd /= (double)0.98f;
            this.yd /= (double)0.98f;
            this.zd /= (double)0.98f;
        }
        if (!this.removed && !this.fadingOut) {
            int height;
            if (this.killOnCollide && (this.killOnCollideActivateAtAge == 0 || this.age >= this.killOnCollideActivateAtAge) && this.isCollided()) {
                this.startDeath();
            }
            BlockPos pos = CoroUtilBlock.blockPos((double)this.x, (double)this.y, (double)this.z);
            if (this.killWhenUnderTopmostBlock && this.y - (double)this.killWhenUnderTopmostBlock_ScanAheadRange <= (double)(height = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY())) {
                this.startDeath();
            }
            if (this.killWhenUnderCameraAtLeast != 0 && this.y < ent.getY() - (double)this.killWhenUnderCameraAtLeast) {
                this.startDeath();
            }
            if (this.killWhenFarFromCameraAtLeast != 0 && this.getAge() > 20 && this.getAge() % 5 == 0 && ent.distanceToSqr(this.x, this.y, this.z) > (double)(this.killWhenFarFromCameraAtLeast * this.killWhenFarFromCameraAtLeast)) {
                this.startDeath();
            }
        }
        if (!this.collisionSpeedDampen && this.onGround) {
            this.xd /= (double)0.7f;
            this.zd /= (double)0.7f;
        }
        double speedXZ = Math.sqrt(this.getMotionX() * this.getMotionX() + this.getMotionZ() * this.getMotionZ());
        double spinFastRateAdj = (double)this.spinFastRate * speedXZ * 10.0;
        if (this.spinFast) {
            this.rotationPitch = (float)((double)this.rotationPitch + (this.entityID % 2 == 0 ? spinFastRateAdj : -spinFastRateAdj));
            this.rotationYaw = (float)((double)this.rotationYaw + (this.entityID % 2 == 0 ? -spinFastRateAdj : spinFastRateAdj));
        }
        float angleToMovement = (float)Math.toDegrees(Math.atan2(this.xd, this.zd));
        if (this.spinTowardsMotionDirection) {
            this.rotationYaw = angleToMovement;
            this.rotationPitch += this.spinFastRate;
        }
        if (!this.fadingOut) {
            if (this.ticksFadeInMax > 0.0f && (float)this.getAge() < this.ticksFadeInMax) {
                this.setAlpha((float)this.getAge() / this.ticksFadeInMax * this.getFullAlphaTarget());
            } else if (this.ticksFadeOutMax > 0.0f && (float)this.getAge() > (float)this.getLifetime() - this.ticksFadeOutMax) {
                float count = (float)this.getAge() - ((float)this.getLifetime() - this.ticksFadeOutMax);
                float val = (this.ticksFadeOutMax - count) / this.ticksFadeOutMax;
                this.setAlpha(val * this.getFullAlphaTarget());
            } else if (this.ticksFadeInMax > 0.0f || this.ticksFadeOutMax > 0.0f) {
                this.setAlpha(this.getFullAlphaTarget());
            }
        } else {
            if (this.ticksFadeOutCurOnDeath < this.ticksFadeOutMaxOnDeath) {
                this.ticksFadeOutCurOnDeath += 1.0f;
            } else {
                this.remove();
            }
            float val = 1.0f - this.ticksFadeOutCurOnDeath / this.ticksFadeOutMaxOnDeath;
            this.setAlpha(val * this.getFullAlphaTarget());
        }
        if (this.level.getGameTime() % 5L == 0L) {
            // empty if block
        }
        this.rotationAroundCenter += this.rotationSpeedAroundCenter;
        this.rotationAroundCenter %= 360.0f;
        this.tickExtraRotations();
    }

    public void tickExtraRotations() {
        WeatherManagerClient weatherMan;
        if (this.slantParticleToWind) {
            double motionXZ = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
            this.rotationPitch = (float)Math.atan2(this.yd, motionXZ);
        }
        if ((weatherMan = ClientTickHandler.weatherManager) == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        if (this instanceof PivotingParticle) {
            return;
        }
        if (this.onGround) {
            windMan.applyWindForceNew(this, 0.015000001f, 0.5f, this.useDynamicWindSpeed);
        } else {
            windMan.applyWindForceNew(this, 0.05f, 0.5f, this.useDynamicWindSpeed);
        }
    }

    public void startDeath() {
        if (this.ticksFadeOutMaxOnDeath > 0.0f) {
            this.ticksFadeOutCurOnDeath = 0.0f;
            this.fadingOut = true;
        } else {
            this.remove();
        }
    }

    public void spawnAsWeatherEffect() {
        this.weatherEffect = true;
        if (ConfigParticle.Particle_engine_weather2) {
            ClientTickHandler.particleManagerExtended().add((Particle)this);
        } else {
            Minecraft.getInstance().particleEngine.add((Particle)this);
        }
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setSize(float par1, float par2) {
        super.setSize(par1, par2);
        this.setPos(this.x, this.y, this.z);
    }

    public void setGravity(float par) {
        this.gravity = par;
    }

    public float maxRenderRange() {
        return this.renderRange;
    }

    public void setScale(float parScale) {
        this.setSizeForRenderCulling(parScale, parScale);
        this.quadSize = parScale;
    }

    public Vector3f getPosition() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public float getScale() {
        return this.quadSize;
    }

    public Vec3 getPos() {
        return new Vec3(this.x, this.y, this.z);
    }

    public double getPosX() {
        return this.x;
    }

    public void setPosX(double posX) {
        this.x = posX;
    }

    public double getPosY() {
        return this.y;
    }

    public void setPosY(double posY) {
        this.y = posY;
    }

    public double getPosZ() {
        return this.z;
    }

    public void setPosZ(double posZ) {
        this.z = posZ;
    }

    public double getMotionX() {
        return this.xd;
    }

    public void setMotionX(double motionX) {
        this.xd = motionX;
    }

    public double getMotionY() {
        return this.yd;
    }

    public void setMotionY(double motionY) {
        this.yd = motionY;
    }

    public double getMotionZ() {
        return this.zd;
    }

    public void setMotionZ(double motionZ) {
        this.zd = motionZ;
    }

    public double getPrevPosX() {
        return this.xo;
    }

    public void setPrevPosX(double prevPosX) {
        this.xo = prevPosX;
    }

    public double getPrevPosY() {
        return this.yo;
    }

    public void setPrevPosY(double prevPosY) {
        this.yo = prevPosY;
    }

    public double getPrevPosZ() {
        return this.zo;
    }

    public void setPrevPosZ(double prevPosZ) {
        this.zo = prevPosZ;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public Level getWorld() {
        return this.level;
    }

    public void setCanCollide(boolean val) {
        this.hasPhysics = val;
    }

    public boolean getCanCollide() {
        return this.hasPhysics;
    }

    public boolean isCollided() {
        return this.onGround || this.isCollidedHorizontally;
    }

    public double getDistance(double x, double y, double z) {
        double d0 = this.x - x;
        double d1 = this.y - y;
        double d2 = this.z - z;
        return Mth.sqrt((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion;
        Vec3 Vector3d = renderInfo.getPosition();
        Vec3 pivotedPosition = this.getPivotedPosition(partialTicks);
        float f = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) + pivotedPosition.x - Vector3d.x());
        float f1 = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) + pivotedPosition.y - Vector3d.y());
        float f2 = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) + pivotedPosition.z - Vector3d.z());
        if (this.facePlayer || this.rotationPitch == 0.0f && this.rotationYaw == 0.0f) {
            quaternion = renderInfo.rotation();
        } else {
            quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
            if (this.facePlayerYaw) {
                quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(-renderInfo.getYRot()));
            } else {
                quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)this.prevRotationYaw, (float)this.rotationYaw)));
            }
            quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)this.prevRotationPitch, (float)this.rotationPitch)));
        }
        if (this.roll == 0.0f) {
            quaternionf = renderInfo.rotation();
        } else {
            quaternionf = new Quaternionf((Quaternionfc)renderInfo.rotation());
            quaternionf.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.getQuadSize(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.getU0();
        float f8 = this.getU1();
        float f5 = this.getV0();
        float f6 = this.getV1();
        int j = this.getLightColor(partialTicks);
        if (j > 0) {
            this.lastNonZeroBrightness = j;
        } else {
            j = this.lastNonZeroBrightness;
        }
        buffer.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(f8, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(f8, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(f7, f5).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        buffer.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(f7, f6).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
    }

    public void setKillOnCollide(boolean val) {
        this.killOnCollide = val;
    }

    public void move(double x, double y, double z) {
        double xx = x;
        double yy = y;
        double zz = z;
        if (this.hasPhysics && (x != 0.0 || y != 0.0 || z != 0.0)) {
            Vec3 Vector3d = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = Vector3d.x;
            y = Vector3d.y;
            z = Vector3d.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            if (this.isUseCustomBBForRenderCulling()) {
                this.setBoundingBoxForRender(this.getBoundingBoxForRender(1.0f).move(x, y, z));
            }
            this.setLocationFromBoundingbox();
        }
        this.onGround = yy != y && yy < 0.0;
        this.isCollidedHorizontally = xx != x || zz != z;
        this.isCollidedVerticallyDownwards = yy < y;
        boolean bl = this.isCollidedVerticallyUpwards = yy > y;
        if (xx != x) {
            this.xd = 0.0;
        }
        if (zz != z) {
            this.zd = 0.0;
        }
        if (!this.markCollided) {
            if (this.onGround || this.isCollidedVerticallyDownwards || this.isCollidedHorizontally || this.isCollidedVerticallyUpwards) {
                this.onHit();
                this.markCollided = true;
            }
            if (this.bounceOnVerticalImpact && (this.onGround || this.isCollidedVerticallyDownwards)) {
                this.setMotionY(-this.getMotionY() * this.bounceOnVerticalImpactEnergy);
            }
        }
    }

    public void setFacePlayer(boolean val) {
        this.facePlayer = val;
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.sprite;
    }

    public boolean isVanillaMotionDampen() {
        return this.vanillaMotionDampen;
    }

    public void setVanillaMotionDampen(boolean motionDampen) {
        this.vanillaMotionDampen = motionDampen;
    }

    public int getLightColor(float p_189214_1_) {
        return super.getLightColor(p_189214_1_);
    }

    public void setColor(float particleRedIn, float particleGreenIn, float particleBlueIn) {
        super.setColor(particleRedIn, particleGreenIn, particleBlueIn);
    }

    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
    }

    public int getKillWhenUnderTopmostBlock_ScanAheadRange() {
        return this.killWhenUnderTopmostBlock_ScanAheadRange;
    }

    public void setKillWhenUnderTopmostBlock_ScanAheadRange(int killWhenUnderTopmostBlock_ScanAheadRange) {
        this.killWhenUnderTopmostBlock_ScanAheadRange = killWhenUnderTopmostBlock_ScanAheadRange;
    }

    public boolean isCollidedVertically() {
        return this.isCollidedVerticallyDownwards || this.isCollidedVerticallyUpwards;
    }

    public ParticleRenderType getRenderType() {
        return SORTED_TRANSLUCENT;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        super.setSprite(sprite);
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public float getFullAlphaTarget() {
        return this.fullAlphaTarget;
    }

    public void setFullAlphaTarget(float fullAlphaTarget) {
        this.fullAlphaTarget = fullAlphaTarget;
    }

    public int getLastNonZeroBrightness() {
        return this.lastNonZeroBrightness;
    }

    public void setLastNonZeroBrightness(int lastNonZeroBrightness) {
        this.lastNonZeroBrightness = lastNonZeroBrightness;
    }

    public void onHit() {
    }

    public void setMaxAge(int par) {
        this.setLifetime(par);
    }

    public int getMaxAge() {
        return this.getLifetime();
    }

    public void setAlphaF(float val) {
        this.setAlpha(val);
    }

    public void setPosition(double posX, double posY, double posZ) {
        this.setPos(posX, posY, posZ);
    }

    public Vec3 getPivotedPosition(float partialTicks) {
        return Vec3.ZERO;
    }

    public void setBoundingBoxForRender(AABB p_107260_) {
        this.bbRender = p_107260_;
    }

    public AABB getBoundingBoxForRender(float partialTicks) {
        if (this.isUseCustomBBForRenderCulling()) {
            return this.bbRender;
        }
        return this.getBoundingBox();
    }

    public void setSizeForRenderCulling(float p_107251_, float p_107252_) {
        if (p_107251_ != this.bbWidth || p_107252_ != this.bbHeight) {
            this.bbWidth = p_107251_;
            this.bbHeight = p_107252_;
            AABB aabb = this.getBoundingBox();
            double d0 = (aabb.minX + aabb.maxX - (double)p_107251_) / 2.0;
            double d1 = (aabb.minZ + aabb.maxZ - (double)p_107251_) / 2.0;
            this.setBoundingBoxForRender(new AABB(d0, aabb.minY, d1, d0 + (double)this.bbWidth, aabb.minY + (double)this.bbHeight, d1 + (double)this.bbWidth));
        }
    }

    public boolean isUseCustomBBForRenderCulling() {
        return this.useCustomBBForRenderCulling;
    }

    public void setUseCustomBBForRenderCulling(boolean useCustomBBForRenderCulling) {
        this.useCustomBBForRenderCulling = useCustomBBForRenderCulling;
    }

    @Override
    public float getWindWeight() {
        return this.windWeight;
    }

    @Override
    public int getParticleDecayExtra() {
        return 0;
    }

    public int getKillOnCollideActivateAtAge() {
        return this.killOnCollideActivateAtAge;
    }

    public void setKillOnCollideActivateAtAge(int killOnCollideActivateAtAge) {
        this.killOnCollideActivateAtAge = killOnCollideActivateAtAge;
    }

    public float getRenderDistanceCull() {
        return this.renderDistanceCull;
    }

    public void setRenderDistanceCull(float renderDistanceCull) {
        this.renderDistanceCull = renderDistanceCull;
    }

    public boolean isUseDynamicWindSpeed() {
        return this.useDynamicWindSpeed;
    }

    public void setUseDynamicWindSpeed(boolean useDynamicWindSpeed) {
        this.useDynamicWindSpeed = useDynamicWindSpeed;
    }
}

