/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.behavior;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilMisc;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.particle.entity.ParticleTexExtraRender;
import extendedrenderer.particle.entity.ParticleTexFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import weather2.ClientTickHandler;
import weather2.ClientWeatherProxy;
import weather2.client.SceneEnhancer;
import weather2.datatypes.PrecipitationType;
import weather2.util.WeatherUtilParticle;

@OnlyIn(value=Dist.CLIENT)
public class ParticleBehaviors {
    public List<EntityRotFX> particles = new ArrayList<EntityRotFX>();
    public Vec3 coordSource;
    public Entity sourceEntity = null;
    public Random rand = new Random();
    public float rateDarken = 0.025f;
    public float rateBrighten = 0.01f;
    public float rateBrightenSlower = 0.003f;
    public float rateAlpha = 0.002f;
    public float rateScale = 0.1f;
    public int tickSmokifyTrigger = 40;
    float acidRainRed = 0.5f;
    float acidRainGreen = 1.0f;
    float acidRainBlue = 0.5f;
    float vanillaRainRed = 0.7f;
    float vanillaRainGreen = 0.7f;
    float vanillaRainBlue = 1.0f;

    public ParticleBehaviors(Vec3 source) {
        this.coordSource = source;
    }

    public void tickUpdateList() {
        for (int i = 0; i < this.particles.size(); ++i) {
            EntityRotFX particle = this.particles.get(i);
            if (!particle.isAlive()) {
                this.particles.remove(particle);
                continue;
            }
            this.tickUpdate(particle);
        }
    }

    public void tickUpdate(EntityRotFX particle) {
        if (this.sourceEntity != null) {
            this.coordSource = this.sourceEntity.position();
        }
        this.tickUpdateAct(particle);
    }

    public void tickUpdateAct(EntityRotFX particle) {
        double centerX = particle.getPosX();
        double centerZ = particle.getPosZ();
        if (this.coordSource != null) {
            centerX = this.coordSource.x;
            centerZ = this.coordSource.z;
        }
        double vecX = centerX - particle.getPosX();
        double vecZ = centerZ - particle.getPosZ();
        double distToCenter = Math.sqrt(vecX * vecX + vecZ * vecZ);
        double rotYaw = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
        double adjYaw = Math.min(360, 45 + particle.getAge());
        rotYaw -= adjYaw;
        double speed = 0.1;
        if (particle.getAge() < 25 && distToCenter > 0.05) {
            particle.setMotionX(Math.cos(rotYaw * 0.017453) * speed);
            particle.setMotionZ(Math.sin(rotYaw * 0.017453) * speed);
        } else {
            double speed2 = 0.008;
            double pSpeed = Math.sqrt(particle.getMotionX() * particle.getMotionX() + particle.getMotionZ() * particle.getMotionZ());
            if (pSpeed < 0.2 && particle.getMotionY() < 0.01) {
                speed2 = 0.08;
            }
            if (pSpeed < 0.002 && Math.abs(particle.getMotionY()) < 0.02) {
                particle.setMotionY(particle.getMotionY() - 0.15);
            }
            particle.setMotionX(particle.getMotionX() + (this.rand.nextDouble() - this.rand.nextDouble()) * speed2);
            particle.setMotionZ(particle.getMotionZ() + (this.rand.nextDouble() - this.rand.nextDouble()) * speed2);
        }
        float brightnessShiftRate = this.rateDarken;
        int stateChangeTick = this.tickSmokifyTrigger;
        if (particle.getAge() < stateChangeTick) {
            particle.setGravity(-0.2f);
            particle.setColor(particle.rCol - brightnessShiftRate, particle.gCol - brightnessShiftRate, particle.bCol - brightnessShiftRate);
        } else if (particle.getAge() == stateChangeTick) {
            particle.setColor(0.0f, 0.0f, 0.0f);
        } else {
            brightnessShiftRate = this.rateBrighten;
            particle.setGravity(-0.05f);
            if (!(particle.rCol < 0.3f)) {
                brightnessShiftRate = this.rateBrightenSlower;
            }
            particle.setColor(particle.rCol + brightnessShiftRate, particle.gCol + brightnessShiftRate, particle.bCol + brightnessShiftRate);
            if (particle.getAlphaF() > 0.0f) {
                particle.setAlpha(particle.getAlphaF() - this.rateAlpha);
            } else {
                particle.remove();
            }
        }
        if (particle.getScale() < 8.0f) {
            particle.setScale(particle.getScale() + this.rateScale);
        }
    }

    public void tickUpdateCloud(EntityRotFX particle) {
        particle.rotationYaw = (float)((double)particle.rotationYaw - 0.1);
        int ticksFadeInMax = 100;
        if (particle.getAge() < ticksFadeInMax) {
            particle.setAlpha((float)particle.getAge() * 0.01f);
        } else if (particle.getAlphaF() > 0.0f) {
            particle.setAlpha(particle.getAlphaF() - this.rateAlpha * 1.3f);
        } else {
            particle.remove();
        }
    }

    public EntityRotFX spawnNewParticleIconFX(Level world, TextureAtlasSprite icon, double x, double y, double z, double vecX, double vecY, double vecZ) {
        return this.spawnNewParticleIconFX(world, icon, x, y, z, vecX, vecY, vecZ, 0);
    }

    public EntityRotFX spawnNewParticleIconFX(Level world, TextureAtlasSprite icon, double x, double y, double z, double vecX, double vecY, double vecZ, int renderOrder) {
        ParticleTexFX entityfx = new ParticleTexFX((ClientLevel)world, x, y, z, vecX, vecY, vecZ, icon);
        entityfx.pb = this;
        entityfx.renderOrder = renderOrder;
        return entityfx;
    }

    public EntityRotFX initParticle(EntityRotFX particle) {
        particle.setPrevPosX(particle.getPosX());
        particle.setPrevPosY(particle.getPosY());
        particle.setPrevPosZ(particle.getPosZ());
        particle.setSize(0.01f, 0.01f);
        return particle;
    }

    public void initParticleRain(EntityRotFX particle, int extraRenderCount) {
        particle.setKillWhenUnderTopmostBlock(true);
        particle.setCanCollide(false);
        particle.killWhenUnderCameraAtLeast = 5;
        particle.setDontRenderUnderTopmostBlock(true);
        if (particle instanceof ParticleTexExtraRender) {
            ((ParticleTexExtraRender)particle).setExtraParticlesBaseAmount(extraRenderCount);
        }
        particle.fastLight = true;
        particle.setSlantParticleToWind(true);
        particle.windWeight = 5.0f;
        particle.setFacePlayer(false);
        particle.setScale(0.3f);
        particle.isTransparent = true;
        particle.setGravity(1.8f);
        particle.setLifetime(50);
        particle.setTicksFadeInMax(5.0f);
        particle.setTicksFadeOutMax(5.0f);
        particle.setTicksFadeOutMaxOnDeath(3.0f);
        particle.setFullAlphaTarget(0.6f);
        particle.setAlpha(0.0f);
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
        particle.setMotionY(-0.5);
        ClientTickHandler.getClientWeather().getWindManager().applyWindForceNew(particle, 10.0f, 0.5f);
        LocalPlayer entP = Minecraft.getInstance().player;
        Biome biome = (Biome)entP.level().getBiome(new BlockPos(Mth.floor((double)entP.getX()), (int)Math.floor(entP.getY()), Mth.floor((double)entP.getZ()))).value();
        if (ClientWeatherProxy.get().getPrecipitationType(biome) == PrecipitationType.ACID) {
            particle.rCol = this.acidRainRed;
            particle.gCol = this.acidRainGreen;
            particle.bCol = this.acidRainBlue;
        } else {
            particle.setFullAlphaTarget(0.8f);
            particle.rCol = this.vanillaRainRed;
            particle.gCol = this.vanillaRainGreen;
            particle.bCol = this.vanillaRainBlue;
        }
        particle.spawnAsWeatherEffect();
    }

    public void initParticleGroundSplash(EntityRotFX particle) {
        particle.setKillWhenUnderTopmostBlock(true);
        particle.setCanCollide(false);
        particle.killWhenUnderCameraAtLeast = 5;
        boolean upward = this.rand.nextBoolean();
        particle.windWeight = 20.0f;
        particle.setFacePlayer(upward);
        particle.setScale(0.2f + this.rand.nextFloat() * 0.05f);
        particle.setLifetime(15);
        particle.setGravity(-0.0f);
        particle.setTicksFadeInMax(3.0f);
        particle.setFullAlphaTarget(0.6f);
        particle.setAlpha(0.0f);
        particle.setTicksFadeOutMax(4.0f);
        particle.renderOrder = 2;
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
        particle.rotationPitch = 90.0f;
        particle.setMotionY(0.0);
        particle.setMotionX((this.rand.nextFloat() - 0.5f) * 0.01f);
        particle.setMotionZ((this.rand.nextFloat() - 0.5f) * 0.01f);
        LocalPlayer entP = Minecraft.getInstance().player;
        Biome biome = (Biome)entP.level().getBiome(new BlockPos(Mth.floor((double)entP.getX()), Mth.floor((double)entP.getY()), Mth.floor((double)entP.getZ()))).value();
        if (ClientWeatherProxy.get().getPrecipitationType(biome) == PrecipitationType.ACID) {
            particle.rCol = this.acidRainRed;
            particle.gCol = this.acidRainGreen;
            particle.bCol = this.acidRainBlue;
        } else {
            particle.rCol = this.vanillaRainRed;
            particle.gCol = this.vanillaRainGreen;
            particle.bCol = this.vanillaRainBlue;
        }
    }

    public void initParticleRainDownfall(EntityRotFX particle) {
        particle.setCanCollide(false);
        particle.killWhenUnderCameraAtLeast = 15;
        particle.setKillWhenUnderTopmostBlock(true);
        particle.setKillWhenUnderTopmostBlock_ScanAheadRange(3);
        particle.setTicksFadeOutMaxOnDeath(10.0f);
        particle.setDontRenderUnderTopmostBlock(false);
        particle.windWeight = 5.0f;
        particle.setFacePlayer(false);
        particle.facePlayerYaw = true;
        particle.setScale(12.0f + this.rand.nextFloat() * 0.3f);
        particle.setSize(10.0f, 50.0f);
        particle.setLifetime(120);
        particle.setGravity(0.35f);
        particle.setTicksFadeInMax(20.0f);
        particle.setFullAlphaTarget(1.0f);
        particle.setAlpha(0.0f);
        particle.setTicksFadeOutMax(10.0f);
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
        particle.rotationPitch = 0.0f;
        particle.setMotionY(-0.3);
        particle.setMotionX((this.rand.nextFloat() - 0.5f) * 0.01f);
        particle.setMotionZ((this.rand.nextFloat() - 0.5f) * 0.01f);
        LocalPlayer entP = Minecraft.getInstance().player;
        Biome biome = (Biome)entP.level().getBiome(CoroUtilBlock.blockPos((double)entP.getX(), (double)entP.getY(), (double)entP.getZ())).value();
        if (ClientWeatherProxy.get().getPrecipitationType(biome) == PrecipitationType.ACID) {
            particle.rCol = this.acidRainRed;
            particle.gCol = this.acidRainGreen;
            particle.bCol = this.acidRainBlue;
        } else {
            particle.rCol = this.vanillaRainRed;
            particle.gCol = this.vanillaRainGreen;
            particle.bCol = this.vanillaRainBlue;
        }
    }

    public void initParticleSnow(EntityRotFX particle, int extraRenderCount, float windSpeed) {
        float windScale = Math.max(0.1f, 1.0f - windSpeed);
        particle.setCanCollide(false);
        particle.setTicksFadeOutMaxOnDeath(5.0f);
        particle.setDontRenderUnderTopmostBlock(true);
        particle.setKillWhenUnderTopmostBlock(true);
        if (particle instanceof ParticleTexExtraRender) {
            ((ParticleTexExtraRender)particle).setExtraParticlesBaseAmount(extraRenderCount);
        }
        particle.killWhenFarFromCameraAtLeast = 25;
        particle.setMotionX(0.0);
        particle.setMotionZ(0.0);
        particle.setMotionY(0.0);
        particle.setScale(0.19500001f);
        particle.setGravity(0.05f);
        particle.windWeight = 5.0f;
        particle.setMaxAge((int)(1440.0f * windScale));
        particle.setFacePlayer(true);
        particle.setTicksFadeInMax(40.0f * windScale);
        particle.setAlphaF(0.0f);
        particle.setTicksFadeOutMax(40.0f * windScale);
        particle.setTicksFadeOutMaxOnDeath(10.0f);
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
        ClientTickHandler.getClientWeather().getWindManager().applyWindForceNew(particle, 1.0f, 0.5f);
    }

    public void initParticleSnowstorm(EntityRotFX particle, int extraRenderCount) {
        particle.setCanCollide(false);
        particle.setTicksFadeOutMaxOnDeath(5.0f);
        particle.setDontRenderUnderTopmostBlock(true);
        if (particle instanceof ParticleTexExtraRender) {
            ((ParticleTexExtraRender)particle).setExtraParticlesBaseAmount(extraRenderCount);
        }
        particle.killWhenFarFromCameraAtLeast = 15;
        particle.setMotionX(0.0);
        particle.setMotionZ(0.0);
        particle.setMotionY(0.0);
        particle.setScale(0.19500001f);
        particle.setGravity(0.05f);
        particle.windWeight = 5.0f;
        particle.setMaxAge(120);
        particle.setFacePlayer(false);
        particle.setTicksFadeInMax(5.0f);
        particle.setAlphaF(0.0f);
        particle.setTicksFadeOutMax(20.0f);
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
        ClientTickHandler.getClientWeather().getWindManager().applyWindForceNew(particle, 1.0f, 0.5f);
    }

    public void initParticleHail(EntityRotFX particle) {
        particle.setKillWhenUnderTopmostBlock(false);
        particle.setCanCollide(true);
        particle.setKillOnCollide(true);
        particle.killWhenUnderCameraAtLeast = 5;
        particle.setDontRenderUnderTopmostBlock(true);
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(360);
        particle.fastLight = true;
        particle.setSlantParticleToWind(true);
        particle.windWeight = 5.0f;
        particle.spinFast = true;
        particle.spinFastRate = 10.0f;
        particle.setFacePlayer(false);
        particle.setScale(0.105000004f);
        particle.isTransparent = true;
        particle.setGravity(3.5f);
        particle.setLifetime(70);
        particle.setTicksFadeInMax(5.0f);
        particle.setTicksFadeOutMax(5.0f);
        particle.setTicksFadeOutMaxOnDeath(50.0f);
        particle.setFullAlphaTarget(1.0f);
        particle.setAlpha(0.0f);
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
        particle.setMotionY(-0.5);
        ClientTickHandler.getClientWeather().getWindManager().applyWindForceNew(particle, 1.0f, 0.5f);
        particle.rCol = 0.9f;
        particle.gCol = 0.9f;
        particle.bCol = 0.9f;
        particle.bounceOnVerticalImpact = true;
        particle.bounceOnVerticalImpactEnergy = 0.2f;
    }

    public void initParticleCube(EntityRotFX particle) {
        particle.setKillWhenUnderTopmostBlock(false);
        particle.setCanCollide(true);
        particle.setKillOnCollide(true);
        particle.setKillOnCollideActivateAtAge(30);
        particle.killWhenUnderCameraAtLeast = 0;
        particle.setDontRenderUnderTopmostBlock(true);
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(360);
        particle.fastLight = true;
        particle.windWeight = 5.0f + (float)(Math.random() * 0.3 - Math.random() * 0.3);
        particle.spinFast = true;
        particle.spinFastRate = 1.0f;
        particle.setFacePlayer(false);
        particle.setScale(0.45000002f);
        particle.isTransparent = false;
        particle.setGravity(4.0f);
        particle.setLifetime(400);
        particle.setTicksFadeInMax(5.0f);
        particle.setTicksFadeOutMax(5.0f);
        particle.setTicksFadeOutMaxOnDeath(20.0f);
        particle.setFullAlphaTarget(1.0f);
        particle.setAlpha(0.0f);
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
        particle.setVanillaMotionDampen(true);
        particle.bounceOnVerticalImpact = true;
        particle.bounceOnVerticalImpactEnergy = 0.2f;
    }

    public void initParticleDustAir(EntityRotFX particle) {
        particle.setKillWhenUnderTopmostBlock(false);
        particle.setCanCollide(false);
        particle.killWhenUnderCameraAtLeast = 5;
        particle.setTicksFadeOutMaxOnDeath(5.0f);
        particle.setDontRenderUnderTopmostBlock(true);
        if (particle instanceof ParticleTexExtraRender) {
            ((ParticleTexExtraRender)particle).setExtraParticlesBaseAmount(0);
        }
        particle.setMotionX(0.0);
        particle.setMotionZ(0.0);
        particle.setMotionY(0.0);
        particle.fastLight = true;
        particle.windWeight = 10.0f;
        particle.setFacePlayer(true);
        particle.setScale(0.015000001f);
        particle.isTransparent = true;
        particle.setGravity(0.0f);
        particle.setLifetime(80);
        particle.setTicksFadeInMax(20.0f);
        particle.setTicksFadeOutMax(20.0f);
        particle.setTicksFadeOutMaxOnDeath(20.0f);
        particle.setFullAlphaTarget(0.6f);
        particle.setAlpha(0.0f);
        float brightness = 0.5f + this.rand.nextFloat() * 0.5f;
        particle.setColor(particle.rCol * brightness, particle.gCol * brightness, particle.bCol * brightness);
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
    }

    public void initParticleDustGround(EntityRotFX particle, boolean spawnInside, boolean spawnAboveSnow) {
        particle.setKillOnCollide(false);
        particle.setKillWhenUnderTopmostBlock(false);
        particle.killWhenUnderCameraAtLeast = 5;
        particle.setDontRenderUnderTopmostBlock(false);
        particle.setMotionX(0.0);
        particle.setMotionZ(0.0);
        particle.setMotionY(0.0);
        particle.fastLight = true;
        particle.windWeight = 1.0f;
        particle.setFacePlayer(true);
        particle.setScale(0.0225f);
        particle.isTransparent = true;
        particle.setGravity(0.06f);
        particle.setCanCollide(false);
        particle.setCanCollide(true);
        particle.collisionSpeedDampen = false;
        particle.setLifetime(30);
        particle.setTicksFadeInMax(5.0f);
        particle.setTicksFadeOutMax(5.0f);
        particle.setTicksFadeOutMaxOnDeath(5.0f);
        particle.setFullAlphaTarget(0.6f);
        particle.setAlpha(0.0f);
        if (spawnAboveSnow || !spawnInside) {
            float brightness = 0.5f;
            particle.setColor(particle.rCol * brightness, particle.gCol * brightness, particle.bCol * brightness);
        }
        particle.rotationYaw = (float)CoroUtilMisc.random.nextInt(360) - 180.0f;
    }

    public void initParticleLeaf(EntityRotFX particle, float particleAABB) {
        Vec3 windForce = ClientTickHandler.getClientWeather().getWindManager().getWindForce(WeatherUtilParticle.getPos((Particle)particle));
        particle.setMotionX(windForce.x / 2.0);
        particle.setMotionZ(windForce.z / 2.0);
        particle.setMotionY(windForce.y / 2.0);
        particle.setSize(particleAABB, particleAABB);
        particle.setGravity(0.05f);
        particle.setCanCollide(true);
        particle.setKillOnCollide(false);
        particle.collisionSpeedDampen = false;
        particle.killWhenUnderCameraAtLeast = 20;
        particle.killWhenFarFromCameraAtLeast = 20;
        particle.isTransparent = false;
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(360);
    }

    public void initParticleSnowstormCloudDust(EntityRotFX particle) {
        boolean farSpawn = Minecraft.getInstance().player.isSpectator() || !SceneEnhancer.isPlayerOutside;
        Vec3 windForce = ClientTickHandler.getClientWeather().getWindManager().getWindForce(null);
        particle.setMotionX(windForce.x * 0.3);
        particle.setMotionZ(windForce.z * 0.3);
        particle.setFacePlayer(false);
        particle.isTransparent = true;
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(360);
        particle.setLifetime(farSpawn ? 30 : 10);
        particle.setLifetime(20);
        particle.setGravity(0.09f);
        particle.setAlpha(0.0f);
        float brightnessMulti = 1.0f - this.rand.nextFloat() * 0.4f;
        particle.setColor(1.0f * brightnessMulti, 1.0f * brightnessMulti, 1.0f * brightnessMulti);
        particle.setScale(4.5f);
        particle.aboveGroundHeight = 0.2;
        particle.setKillOnCollide(true);
        particle.killWhenFarFromCameraAtLeast = 15;
        particle.windWeight = 1.0f;
        particle.setTicksFadeInMax(5.0f);
        particle.setTicksFadeOutMax(3.0f);
        particle.setTicksFadeOutMaxOnDeath(3.0f);
        ClientTickHandler.getClientWeather().getWindManager().applyWindForceNew(particle, 0.2f, 0.5f);
    }

    public void initParticleSandstormDust(EntityRotFX particle) {
        Vec3 windForce = ClientTickHandler.getClientWeather().getWindManager().getWindForce(null);
        particle.setMotionX(windForce.x);
        particle.setMotionZ(windForce.z);
        particle.setFacePlayer(false);
        particle.isTransparent = true;
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(360);
        particle.setLifetime(40);
        particle.setGravity(0.09f);
        particle.setAlpha(0.0f);
        float brightnessMulti = 1.0f - this.rand.nextFloat() * 0.5f;
        particle.setColor(0.65f * brightnessMulti, 0.6f * brightnessMulti, 0.3f * brightnessMulti);
        particle.setScale(6.0f);
        particle.aboveGroundHeight = 0.2;
        particle.setKillOnCollide(true);
        particle.killWhenFarFromCameraAtLeast = 15;
        particle.setTicksFadeInMax(5.0f);
        particle.setTicksFadeOutMax(5.0f);
        particle.setTicksFadeOutMaxOnDeath(5.0f);
        particle.windWeight = 1.0f;
    }

    public void initParticleSandstormTumbleweed(EntityRotFX particle) {
        Vec3 windForce = ClientTickHandler.getClientWeather().getWindManager().getWindForce(null);
        particle.setMotionX(windForce.x);
        particle.setMotionZ(windForce.z);
        particle.setFacePlayer(false);
        particle.facePlayerYaw = false;
        particle.spinTowardsMotionDirection = true;
        particle.isTransparent = true;
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(360);
        particle.setLifetime(80);
        particle.setGravity(0.3f);
        particle.setAlpha(0.0f);
        float brightnessMulti = 1.0f - this.rand.nextFloat() * 0.2f;
        particle.setColor(1.0f * brightnessMulti, 1.0f * brightnessMulti, 1.0f * brightnessMulti);
        particle.setScale(1.2f);
        particle.aboveGroundHeight = 0.5;
        particle.collisionSpeedDampen = false;
        particle.bounceSpeed = 0.03;
        particle.bounceSpeedAhead = 0.03;
        particle.setKillOnCollide(false);
        particle.killWhenFarFromCameraAtLeast = 30;
        particle.setTicksFadeInMax(5.0f);
        particle.setTicksFadeOutMax(5.0f);
        particle.setTicksFadeOutMaxOnDeath(5.0f);
        particle.windWeight = 1.0f;
    }

    public void initParticleSandstormDebris(EntityRotFX particle) {
        Vec3 windForce = ClientTickHandler.getClientWeather().getWindManager().getWindForce(null);
        particle.setMotionX(windForce.x);
        particle.setMotionZ(windForce.z);
        particle.setFacePlayer(false);
        particle.spinFast = true;
        particle.spinFastRate = 2.0f;
        particle.isTransparent = true;
        particle.rotationYaw = this.rand.nextInt(360);
        particle.rotationPitch = this.rand.nextInt(360);
        particle.setLifetime(80);
        particle.setGravity(0.3f);
        particle.setAlpha(0.0f);
        float brightnessMulti = 1.0f - this.rand.nextFloat() * 0.5f;
        particle.setColor(1.0f * brightnessMulti, 1.0f * brightnessMulti, 1.0f * brightnessMulti);
        particle.setScale(1.2f);
        particle.aboveGroundHeight = 0.5;
        particle.collisionSpeedDampen = false;
        particle.bounceSpeed = 0.03;
        particle.bounceSpeedAhead = 0.03;
        particle.setKillOnCollide(false);
        particle.killWhenFarFromCameraAtLeast = 30;
        particle.setTicksFadeInMax(5.0f);
        particle.setTicksFadeOutMax(5.0f);
        particle.setTicksFadeOutMaxOnDeath(5.0f);
        particle.windWeight = 1.0f;
    }

    public static EntityRotFX setParticleRandoms(EntityRotFX particle, boolean yaw, boolean pitch) {
        Random rand = new Random();
        if (yaw) {
            particle.rotationYaw = rand.nextInt(360);
        }
        if (pitch) {
            particle.rotationPitch = rand.nextInt(360);
        }
        return particle;
    }

    public static EntityRotFX setParticleFire(EntityRotFX particle) {
        Random rand = new Random();
        particle.setColor(0.6f + rand.nextFloat() * 0.4f, 0.2f + rand.nextFloat() * 0.2f, 0.0f);
        particle.setScale(0.25f + 0.2f * rand.nextFloat());
        particle.brightness = 1.0f;
        particle.setSize(0.1f, 0.1f);
        particle.setAlpha(0.6f);
        return particle;
    }

    public static EntityRotFX setParticleCloud(EntityRotFX particle, float freezeY) {
        particle.spawnY = freezeY;
        particle.rotationPitch = 90.0f;
        particle.setCanCollide(false);
        particle.setSize(0.25f, 0.25f);
        particle.setScale(500.0f);
        particle.callUpdateSuper = false;
        particle.callUpdatePB = false;
        particle.setLifetime(500);
        particle.setColor(1.0f, 1.0f, 1.0f);
        particle.brightness = 0.3f;
        particle.renderRange = 999.0f;
        particle.setAlpha(0.0f);
        return particle;
    }

    public void cleanup() {
    }
}

