/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import extendedrenderer.particle.entity.EntityRotFX;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDescription;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ParticleManagerExtended
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter PARTICLE_LISTER = FileToIdConverter.json((String)"particles");
    private static final ResourceLocation PARTICLES_ATLAS_INFO = ResourceLocation.withDefaultNamespace((String)"particles");
    private static final int MAX_PARTICLES_PER_LAYER = 16384;
    private static final List<ParticleRenderType> RENDER_ORDER = ImmutableList.of((Object)ParticleRenderType.TERRAIN_SHEET, (Object)ParticleRenderType.PARTICLE_SHEET_OPAQUE, (Object)ParticleRenderType.PARTICLE_SHEET_LIT, (Object)ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT, (Object)ParticleRenderType.CUSTOM, (Object)ParticleRenderType.CUSTOM, (Object)EntityRotFX.SORTED_OPAQUE_BLOCK, (Object)EntityRotFX.SORTED_TRANSLUCENT);
    protected ClientLevel level;
    public final Map<ParticleRenderType, Queue<Particle>> particles = Maps.newTreeMap((Comparator)ClientHooks.makeParticleRenderTypeComparator(RENDER_ORDER));
    private final Queue<TrackingEmitter> trackingEmitters = Queues.newArrayDeque();
    private final TextureManager textureManager;
    private final RandomSource random = RandomSource.create();
    private final Map<ResourceLocation, ParticleProvider<?>> providers = new HashMap();
    private final Queue<Particle> particlesToAdd = Queues.newArrayDeque();
    private final Map<ResourceLocation, MutableSpriteSet> spriteSets = Maps.newHashMap();
    private final TextureAtlas textureAtlas;
    private final Object2IntOpenHashMap<ParticleGroup> trackedParticleCounts = new Object2IntOpenHashMap();

    public ParticleManagerExtended(ClientLevel p_107299_, TextureManager p_107300_) {
        this.textureAtlas = new TextureAtlas(TextureAtlas.LOCATION_PARTICLES);
        this.level = p_107299_;
        this.textureManager = p_107300_;
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_107305_, ResourceManager p_107306_, ProfilerFiller p_107307_, ProfilerFiller p_107308_, Executor p_107309_, Executor p_107310_) {
        CompletionStage completablefuture = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.listMatchingResources(p_107306_), p_107309_).thenCompose(p_247914_ -> {
            ArrayList list = new ArrayList(p_247914_.size());
            p_247914_.forEach((p_247903_, p_247904_) -> {
                ResourceLocation resourcelocation = PARTICLE_LISTER.fileToId(p_247903_);
                list.add(CompletableFuture.supplyAsync(() -> {
                    @OnlyIn(value=Dist.CLIENT)
                    record ParticleDefinition(ResourceLocation id, Optional<List<ResourceLocation>> sprites) {
                    }
                    return new ParticleDefinition(resourcelocation, this.loadParticleDescription(resourcelocation, (Resource)p_247904_));
                }, p_107309_));
            });
            return Util.sequence(list);
        });
        CompletionStage completablefuture1 = SpriteLoader.create((TextureAtlas)this.textureAtlas).loadAndStitch(p_107306_, PARTICLES_ATLAS_INFO, 0, p_107309_).thenCompose(SpriteLoader.Preparations::waitForUpload);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{completablefuture1, completablefuture}).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)p_107305_).wait(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$5(p_107308_, (CompletableFuture)completablefuture1, (CompletableFuture)completablefuture, arg_0), p_107310_);
    }

    public void close() {
        this.textureAtlas.clearTextureData();
    }

    private Optional<List<ResourceLocation>> loadParticleDescription(ResourceLocation p_250648_, Resource p_248793_) {
        Optional<List<ResourceLocation>> optional;
        block9: {
            if (!this.spriteSets.containsKey(p_250648_)) {
                LOGGER.debug("Redundant texture list for particle: {}", (Object)p_250648_);
                return Optional.empty();
            }
            BufferedReader reader = p_248793_.openAsReader();
            try {
                ParticleDescription particledescription = ParticleDescription.fromJson((JsonObject)GsonHelper.parse((Reader)reader));
                optional = Optional.of(particledescription.getTextures());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load description for particle " + String.valueOf(p_250648_), ioexception);
                }
            }
            ((Reader)reader).close();
        }
        return optional;
    }

    @Nullable
    private <T extends ParticleOptions> Particle makeParticle(T p_107396_, double p_107397_, double p_107398_, double p_107399_, double p_107400_, double p_107401_, double p_107402_) {
        ParticleProvider<?> particleprovider = this.providers.get(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)p_107396_.getType()));
        return particleprovider == null ? null : particleprovider.createParticle(p_107396_, this.level, p_107397_, p_107398_, p_107399_, p_107400_, p_107401_, p_107402_);
    }

    public void add(Particle p_107345_) {
        Optional optional = p_107345_.getParticleGroup();
        if (optional.isPresent()) {
            if (this.hasSpaceInParticleLimit((ParticleGroup)optional.get())) {
                this.particlesToAdd.add(p_107345_);
                this.updateCount((ParticleGroup)optional.get(), 1);
            }
        } else {
            this.particlesToAdd.add(p_107345_);
        }
    }

    public void tick() {
        this.level.getProfiler().push("weather2_particle_tick");
        this.particles.forEach((p_288249_, p_288250_) -> {
            this.level.getProfiler().push("weather2_particle_tick_" + p_288249_.toString());
            this.tickParticleList((Collection<Particle>)p_288250_);
            this.level.getProfiler().pop();
        });
        if (!this.trackingEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (TrackingEmitter trackingemitter : this.trackingEmitters) {
                trackingemitter.tick();
                if (trackingemitter.isAlive()) continue;
                list.add(trackingemitter);
            }
            this.trackingEmitters.removeAll(list);
        }
        if (!this.particlesToAdd.isEmpty()) {
            Particle particle;
            while ((particle = this.particlesToAdd.poll()) != null) {
                this.particles.computeIfAbsent(particle.getRenderType(), p_107347_ -> EvictingQueue.create((int)32768)).add(particle);
            }
        }
        this.level.getProfiler().pop();
    }

    private void tickParticleList(Collection<Particle> p_107385_) {
        if (!p_107385_.isEmpty()) {
            Iterator<Particle> iterator = p_107385_.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                this.tickParticle(particle);
                if (particle.isAlive()) continue;
                particle.getParticleGroup().ifPresent(p_172289_ -> this.updateCount((ParticleGroup)p_172289_, -1));
                iterator.remove();
            }
        }
    }

    private void updateCount(ParticleGroup p_172282_, int p_172283_) {
        this.trackedParticleCounts.addTo((Object)p_172282_, p_172283_);
    }

    private void tickParticle(Particle p_107394_) {
        try {
            p_107394_.tick();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Particle being ticked");
            crashreportcategory.setDetail("Particle", () -> ((Particle)p_107394_).toString());
            crashreportcategory.setDetail("Particle Type", () -> ((ParticleRenderType)p_107394_.getRenderType()).toString());
            throw new ReportedException(crashreport);
        }
    }

    @Deprecated
    public void render(PoseStack p_107337_, MultiBufferSource.BufferSource p_107338_, LightTexture p_107339_, Camera p_107340_, float p_107341_) {
        this.render(p_107337_, p_107338_, p_107339_, p_107340_, p_107341_, null);
    }

    public void render(PoseStack p_107337_, MultiBufferSource.BufferSource p_107338_, LightTexture p_107339_, Camera p_107340_, float p_107341_, @Nullable Frustum clippingHelper) {
        this.level.getProfiler().push("weather2_particle_render");
        float fogStart = RenderSystem.getShaderFogStart();
        float fogEnd = RenderSystem.getShaderFogEnd();
        RenderSystem.setShaderFogStart((float)(fogStart * 4.0f));
        RenderSystem.setShaderFogEnd((float)(fogEnd * 4.0f));
        p_107339_.turnOnLightLayer();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.mul((Matrix4fc)p_107337_.last().pose());
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableCull();
        boolean particleCount = false;
        for (ParticleRenderType particlerendertype : this.particles.keySet()) {
            this.level.getProfiler().push(particlerendertype.toString());
            if (particlerendertype == ParticleRenderType.NO_RENDER) continue;
            Iterable iterable = this.particles.get(particlerendertype);
            if (iterable != null) {
                RenderSystem.setShader(GameRenderer::getParticleShader);
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = particlerendertype.begin(tesselator, this.textureManager);
                for (Particle particle : iterable) {
                    if (particle instanceof EntityRotFX ? clippingHelper != null && !clippingHelper.isVisible(((EntityRotFX)particle).getBoundingBoxForRender(p_107341_)) : clippingHelper != null && !clippingHelper.isVisible(particle.getBoundingBox())) continue;
                    try {
                        particle.render((VertexConsumer)bufferbuilder, p_107340_, p_107341_);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering Particle");
                        CrashReportCategory crashreportcategory = crashreport.addCategory("Particle being rendered");
                        crashreportcategory.setDetail("Particle", () -> ((Particle)particle).toString());
                        crashreportcategory.setDetail("Particle Type", () -> ((ParticleRenderType)particlerendertype).toString());
                        throw new ReportedException(crashreport);
                    }
                }
                MeshData meshdata = bufferbuilder.build();
                if (meshdata != null) {
                    BufferUploader.drawWithShader((MeshData)meshdata);
                }
            }
            this.level.getProfiler().pop();
        }
        matrix4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        p_107339_.turnOffLightLayer();
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)fogEnd);
        this.level.getProfiler().pop();
    }

    public void setLevel(@Nullable ClientLevel p_107343_) {
        this.level = p_107343_;
        this.clearParticles();
        this.trackingEmitters.clear();
    }

    public String countParticles() {
        return String.valueOf(this.particles.values().stream().mapToInt(Collection::size).sum());
    }

    private boolean hasSpaceInParticleLimit(ParticleGroup p_172280_) {
        return this.trackedParticleCounts.getInt((Object)p_172280_) < p_172280_.getLimit();
    }

    public void clearParticles() {
        this.particles.clear();
        this.particlesToAdd.clear();
        this.trackingEmitters.clear();
        this.trackedParticleCounts.clear();
    }

    public Map<ParticleRenderType, Queue<Particle>> getParticles() {
        return this.particles;
    }

    private /* synthetic */ void lambda$reload$5(ProfilerFiller p_107308_, CompletableFuture completablefuture1, CompletableFuture completablefuture, Void p_247900_) {
        this.clearParticles();
        p_107308_.startTick();
        p_107308_.push("upload");
        SpriteLoader.Preparations spriteloader$preparations = (SpriteLoader.Preparations)completablefuture1.join();
        this.textureAtlas.upload(spriteloader$preparations);
        p_107308_.popPush("bindSpriteSets");
        HashSet set = new HashSet();
        TextureAtlasSprite textureatlassprite = spriteloader$preparations.missing();
        ((List)completablefuture.join()).forEach(p_247911_ -> {
            Optional<List<ResourceLocation>> optional = p_247911_.sprites();
            if (!optional.isEmpty()) {
                ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
                for (ResourceLocation resourcelocation : optional.get()) {
                    TextureAtlasSprite textureatlassprite1 = (TextureAtlasSprite)spriteloader$preparations.regions().get(resourcelocation);
                    if (textureatlassprite1 == null) {
                        set.add(resourcelocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(textureatlassprite1);
                }
                if (list.isEmpty()) {
                    list.add(textureatlassprite);
                }
                this.spriteSets.get(p_247911_.id()).rebind(list);
            }
        });
        if (!set.isEmpty()) {
            LOGGER.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(ResourceLocation::toString).collect(Collectors.joining(",")));
        }
        p_107308_.pop();
        p_107308_.endTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class MutableSpriteSet
    implements SpriteSet {
        private List<TextureAtlasSprite> sprites;

        MutableSpriteSet() {
        }

        public TextureAtlasSprite get(int p_107413_, int p_107414_) {
            return this.sprites.get(p_107413_ * (this.sprites.size() - 1) / p_107414_);
        }

        public TextureAtlasSprite get(RandomSource p_233889_) {
            return this.sprites.get(p_233889_.nextInt(this.sprites.size()));
        }

        public void rebind(List<TextureAtlasSprite> p_107416_) {
            this.sprites = ImmutableList.copyOf(p_107416_);
        }
    }
}

