/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.entity;

import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import owmii.powah.entity.Entities;
import owmii.powah.item.Itms;

public class ChargedSnowballEntity
extends ThrowableItemProjectile {
    public ChargedSnowballEntity(Level worldIn, LivingEntity livingEntityIn) {
        super(Entities.CHARGED_SNOWBALL.get(), livingEntityIn, worldIn);
    }

    public ChargedSnowballEntity(EntityType<ChargedSnowballEntity> type, Level world) {
        super(type, world);
    }

    protected Item getDefaultItem() {
        return (Item)Itms.CHARGED_SNOWBALL.get();
    }

    protected void onHit(HitResult result) {
        LightningBolt lightningboltentity;
        if (result.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).getEntity();
            int i = entity instanceof Blaze ? 3 : 0;
            entity.hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), (float)i);
        }
        if (this.level() instanceof ServerLevel && (lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level())) != null) {
            ServerPlayer sp;
            lightningboltentity.moveTo(Vec3.atBottomCenterOf((Vec3i)this.blockPosition()));
            Entity entity = this.getOwner();
            lightningboltentity.setCause(entity instanceof ServerPlayer ? (sp = (ServerPlayer)entity) : null);
            this.level().addFreshEntity((Entity)lightningboltentity);
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }
}

