/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.MM_Blastoff;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;

public class MM_Webber
extends MobModifier {
    private static final long coolDown = 15000L;
    private static Class<?>[] modBans = new Class[]{MM_Gravity.class, MM_Blastoff.class};
    private static String[] suffix = new String[]{"ofTraps", "theMutated", "theSpider"};
    private static String[] prefix = new String[]{"ensnaring", "webbing"};
    private long lastAbilityUse = 0L;

    public MM_Webber() {
    }

    public MM_Webber(MobModifier next) {
        super(next);
    }

    @Override
    public String getModName() {
        return "Webber";
    }

    @Override
    public boolean onUpdate(LivingEntity mob) {
        if (this.hasSteadyTarget() && this.getMobTarget() instanceof Player) {
            this.tryAbility(mob, this.getMobTarget());
        }
        return super.onUpdate(mob);
    }

    @Override
    public float onHurt(LivingEntity mob, DamageSource source, float damage) {
        if (source.getDirectEntity() != null && source.getDirectEntity() instanceof LivingEntity) {
            this.tryAbility(mob, (LivingEntity)source.getDirectEntity());
        }
        return super.onHurt(mob, source, damage);
    }

    private void tryAbility(LivingEntity mob, LivingEntity target) {
        if (target == null || !this.canMobSeeTarget(mob, target)) {
            return;
        }
        int x = Mth.floor((double)target.getX());
        int y = Mth.floor((double)target.getY());
        int z = Mth.floor((double)target.getZ());
        long time = System.currentTimeMillis();
        if (time > this.lastAbilityUse + 15000L) {
            int offset;
            if (target.level().getBlockState(new BlockPos(x, y - 1, z)).getBlock() == Blocks.AIR) {
                offset = -1;
            } else if (target.level().getBlockState(new BlockPos(x, y, z)).getBlock() == Blocks.AIR) {
                offset = 0;
            } else {
                return;
            }
            this.lastAbilityUse = time;
            target.level().setBlockAndUpdate(new BlockPos(x, y + offset, z), Blocks.COBWEB.defaultBlockState());
            mob.level().playSound(null, mob.blockPosition(), SoundEvents.SPIDER_AMBIENT, SoundSource.HOSTILE, 1.0f + mob.getRandom().nextFloat(), mob.getRandom().nextFloat() * 0.7f + 0.3f);
        }
    }

    @Override
    public Class<?>[] getModsNotToMixWith() {
        return modBans;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

