/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.MM_Sticky;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MM_Storm
extends MobModifier {
    private static final long coolDown = 25000L;
    private static Class<?>[] modBans = new Class[]{MM_Sticky.class};
    private static final float MIN_DISTANCE = 3.0f;
    private static String[] suffix = new String[]{"ofLightning", "theRaiden"};
    private static String[] prefix = new String[]{"striking", "thundering", "electrified"};
    private long nextAbilityUse = 0L;

    public MM_Storm() {
    }

    public MM_Storm(MobModifier next) {
        super(next);
    }

    @Override
    public String getModName() {
        return "Storm";
    }

    @Override
    public boolean onUpdate(LivingEntity mob) {
        if (this.hasSteadyTarget() && this.getMobTarget() instanceof Player) {
            this.tryAbility(mob, this.getMobTarget());
        }
        return super.onUpdate(mob);
    }

    private void tryAbility(LivingEntity mob, LivingEntity target) {
        if (target == null || target.getVehicle() != null || !this.canMobSeeTarget(mob, target)) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time > this.nextAbilityUse && mob.distanceTo((Entity)target) > 3.0f && target.level().canSeeSkyFromBelowWater(new BlockPos(Mth.floor((double)target.getX()), Mth.floor((double)target.getY()), Mth.floor((double)target.getZ())))) {
            this.nextAbilityUse = time + 25000L;
            LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(mob.level());
            lightningboltentity.moveTo(target.getX(), target.getY(), target.getZ());
            lightningboltentity.setVisualOnly(false);
            mob.level().addFreshEntity((Entity)lightningboltentity);
        }
    }

    @Override
    public Class<?>[] getModsNotToMixWith() {
        return modBans;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

