/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;

public class MM_Alchemist
extends MobModifier {
    private static final long coolDown = 6000L;
    private static final float MIN_DISTANCE = 2.0f;
    private static String[] suffix = new String[]{"theWitchkin", "theBrewmaster", "theSinged"};
    private static String[] prefix = new String[]{"witchkin", "brewing", "singed"};
    private long nextAbilityUse = 0L;

    public MM_Alchemist() {
    }

    public MM_Alchemist(MobModifier next) {
        super(next);
    }

    @Override
    public String getModName() {
        return "Alchemist";
    }

    @Override
    public boolean onUpdate(LivingEntity mob) {
        long time;
        if (this.hasSteadyTarget() && (time = System.currentTimeMillis()) > this.nextAbilityUse) {
            this.nextAbilityUse = time + 6000L;
            this.tryAbility(mob, (LivingEntity)mob.level().getNearestPlayer((Entity)mob, 12.0));
        }
        return super.onUpdate(mob);
    }

    private void tryAbility(LivingEntity mob, LivingEntity target) {
        if (target == null || !this.canMobSeeTarget(mob, target)) {
            return;
        }
        if (mob.distanceToSqr((Entity)target) > 2.0) {
            float diffX = (float)(target.getX() + target.getDeltaMovement().x - mob.getX());
            float diffY = (float)(target.getY() + (double)target.getEyeHeight() - (double)1.1f - mob.getY());
            float diffZ = (float)(target.getZ() + target.getDeltaMovement().z - mob.getZ());
            float distance = Mth.sqrt((float)(diffX * diffX + diffZ * diffZ));
            Holder potiontype = Potions.HARMING;
            if (distance >= 8.0f && !target.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                potiontype = Potions.SLOWNESS;
            } else if (target.getHealth() >= 8.0f && !target.hasEffect(MobEffects.POISON)) {
                potiontype = Potions.POISON;
            } else if (distance <= 3.0f && !target.hasEffect(MobEffects.WEAKNESS) && mob.getRandom().nextFloat() < 0.25f) {
                potiontype = Potions.WEAKNESS;
            }
            ThrownPotion potionentity = new ThrownPotion(mob.level(), mob);
            potionentity.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potiontype));
            potionentity.setXRot(potionentity.getXRot() + 20.0f);
            potionentity.shoot((double)diffX, (double)diffY + (double)(distance * 0.2f), (double)diffZ, 0.75f, 8.0f);
            mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.WITCH_THROW, mob.getSoundSource(), 1.0f, 0.8f + mob.level().random.nextFloat() * 0.4f);
            mob.level().addFreshEntity((Entity)potionentity);
        }
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

