/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.GsonConfig;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class EntityEventHandler {
    private final HashMap<Tuple<Integer, Integer>, Float> damageMap = new HashMap();
    private long nextMapEvaluation = System.currentTimeMillis();

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof LivingEntity && event.getEntity() instanceof Enemy) {
            String savedMods = event.getEntity().getPersistentData().getString(InfernalMobsCore.instance().getNBTTag());
            if (!savedMods.isEmpty() && !savedMods.equals(InfernalMobsCore.instance().getNBTMarkerForNonInfernalEntities())) {
                InfernalMobsCore.instance().addEntityModifiersByString((LivingEntity)event.getEntity(), savedMods);
            } else {
                InfernalMobsCore.instance().processEntitySpawn((LivingEntity)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        MobModifier mod;
        if (!event.getEntity().level().isClientSide && (mod = InfernalMobsCore.getMobModifiers(event.getEntity())) != null && mod.onDeath()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityLivingSetAttackTarget(LivingChangeTargetEvent event) {
        MobModifier mod;
        if (!event.getEntity().level().isClientSide && (mod = InfernalMobsCore.getMobModifiers(event.getEntity())) != null) {
            mod.onSetAttackTarget(event.getNewAboutToBeSetTarget());
        }
    }

    @SubscribeEvent
    public void onEntityLivingHurt(LivingDamageEvent.Pre event) {
        if (event.getSource().getDirectEntity() != event.getEntity()) {
            Entity attacker;
            MobModifier mod = InfernalMobsCore.getMobModifiers(event.getEntity());
            if (mod != null) {
                event.setNewDamage(mod.onHurt(event.getEntity(), event.getSource(), event.getNewDamage()));
            }
            if ((attacker = event.getSource().getDirectEntity()) == null) {
                return;
            }
            if (attacker instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers((LivingEntity)attacker)) != null) {
                event.setNewDamage(mod.onAttack(event.getEntity(), event.getSource(), event.getNewDamage()));
            }
            if (InfernalMobsCore.instance().config.isAntiMobFarm() && (event.getSource() == attacker.damageSources().cactus() || event.getSource() == attacker.damageSources().drown() || event.getSource() == attacker.damageSources().fall() || event.getSource() == attacker.damageSources().inWall() || event.getSource() == attacker.damageSources().lava() || event.getSource().getDirectEntity() instanceof Player)) {
                Tuple cpair = new Tuple((Object)((int)event.getEntity().getX()), (Object)((int)event.getEntity().getZ()));
                Float value = this.damageMap.get(cpair);
                if (value == null) {
                    for (Map.Entry<Tuple<Integer, Integer>, Float> e : this.damageMap.entrySet()) {
                        if (Math.abs((Integer)e.getKey().getA() - (Integer)cpair.getA()) >= 3 || Math.abs((Integer)e.getKey().getB() - (Integer)cpair.getB()) >= 3) continue;
                        e.setValue(Float.valueOf(e.getValue().floatValue() + event.getNewDamage()));
                        break;
                    }
                } else {
                    this.damageMap.put((Tuple<Integer, Integer>)cpair, Float.valueOf(value.floatValue() + event.getNewDamage()));
                    GsonConfig.saveConfig(InfernalMobsCore.instance().config, InfernalMobsCore.instance().configFile);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingKnockback(LivingKnockBackEvent event) {
        MobModifier mod = InfernalMobsCore.getMobModifiers(event.getEntity());
        if (mod != null) {
            mod.onKnockBack(event);
        }
    }

    @SubscribeEvent
    public void onEntityLivingFall(LivingFallEvent event) {
        MobModifier mod;
        if (!event.getEntity().level().isClientSide && (mod = InfernalMobsCore.getMobModifiers(event.getEntity())) != null) {
            event.setCanceled(mod.onFall(event.getDistance()));
        }
    }

    @SubscribeEvent
    public void onEntityLivingJump(LivingEvent.LivingJumpEvent event) {
        MobModifier mod;
        if (!event.getEntity().level().isClientSide && (mod = InfernalMobsCore.getMobModifiers(event.getEntity())) != null) {
            mod.onJump(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(EntityTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide() && event.getEntity() instanceof LivingEntity) {
            MobModifier mod;
            String savedMods;
            LivingEntity livingEntity = (LivingEntity)event.getEntity();
            if (event.getEntity().tickCount == 1 && !(savedMods = event.getEntity().getPersistentData().getString(InfernalMobsCore.instance().getNBTTag())).isEmpty() && !savedMods.equals(InfernalMobsCore.instance().getNBTMarkerForNonInfernalEntities())) {
                InfernalMobsCore.instance().addEntityModifiersByString(livingEntity, savedMods);
            }
            if ((mod = InfernalMobsCore.getMobModifiers(livingEntity)) != null) {
                mod.onUpdate(livingEntity);
            }
            if (InfernalMobsCore.instance().config.isAntiMobFarm() && System.currentTimeMillis() > this.nextMapEvaluation) {
                if (!this.damageMap.isEmpty()) {
                    float maxDamage = 0.0f;
                    Tuple<Integer, Integer> maxC = null;
                    for (Map.Entry<Tuple<Integer, Integer>, Float> e : this.damageMap.entrySet()) {
                        float val = e.getValue().floatValue();
                        if (!(val > maxDamage)) continue;
                        maxC = e.getKey();
                        maxDamage = val;
                    }
                    if (maxC != null) {
                        System.out.println("Infernal Mobs AntiMobFarm damage check, max detected chunk damage value " + maxDamage + " near coords " + String.valueOf(maxC.getA()) + ", " + String.valueOf(maxC.getB()));
                        if (maxDamage > InfernalMobsCore.instance().config.getMobFarmDamageTrigger()) {
                            NeoForge.EVENT_BUS.post((Event)new MobFarmDetectedEvent(event.getEntity().level().getChunk(((Integer)maxC.getA()).intValue(), ((Integer)maxC.getB()).intValue()), InfernalMobsCore.instance().config.getMobFarmCheckIntervals(), maxDamage));
                        }
                    }
                    this.damageMap.clear();
                }
                this.nextMapEvaluation = System.currentTimeMillis() + InfernalMobsCore.instance().config.getMobFarmCheckIntervals();
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDrops(LivingDropsEvent event) {
        MobModifier mod;
        if (!event.getEntity().level().isClientSide && (mod = InfernalMobsCore.getMobModifiers(event.getEntity())) != null) {
            mod.onDropItems(event.getEntity(), event.getSource(), event.getDrops(), event.isRecentlyHit());
            InfernalMobsCore.removeEntFromElites(event.getEntity());
        }
    }

    public static class MobFarmDetectedEvent
    extends ChunkEvent {
        public final long triggeringInterval;
        public final float triggeringDamage;

        public MobFarmDetectedEvent(LevelChunk chunk, long ti, float td) {
            super((ChunkAccess)chunk);
            this.triggeringInterval = ti;
            this.triggeringDamage = td;
        }
    }
}

