/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.common.network.AirPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="infernalmobs")
public class OverlayChoking {
    protected static final ResourceLocation GUI_ICONS_LOCATION = ResourceLocation.parse((String)"textures/gui/icons.png");
    private static Minecraft mc;
    private static int airOverrideValue;
    private static long airDisplayTimeout;

    public static void handleAirPacket(AirPacket airPacket, IPayloadContext context) {
        airOverrideValue = airPacket.air();
        airDisplayTimeout = System.currentTimeMillis() + 3000L;
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)ModLoadingContext.get().getActiveNamespace(), (String)"infernalmobs_choking"), (LayeredDraw.Layer)new InfernalMobsChokingGuiOverlay());
        mc = Minecraft.getInstance();
    }

    private static int getVehicleMaxHearts(LivingEntity livingEntity) {
        if (livingEntity != null && livingEntity.showVehicleHealth()) {
            float maxHealth = livingEntity.getMaxHealth();
            int roundedHalf = (int)(maxHealth + 0.5f) / 2;
            if (roundedHalf > 30) {
                roundedHalf = 30;
            }
            return roundedHalf;
        }
        return 0;
    }

    private static int getVisibleVehicleHeartRows(int heartCount) {
        return (int)Math.ceil((double)heartCount / 10.0);
    }

    static {
        airOverrideValue = -999;
    }

    public static class InfernalMobsChokingGuiOverlay
    implements LayeredDraw.Layer {
        public void render(@NotNull GuiGraphics guiGraphics, DeltaTracker partialTick) {
            if (System.currentTimeMillis() > airDisplayTimeout) {
                airOverrideValue = -999;
            }
            if (!OverlayChoking.mc.player.isEyeInFluid(FluidTags.WATER) && airOverrideValue != -999) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS_LOCATION);
                int leftScreenCoordinate = mc.getWindow().getGuiScaledWidth() / 2 + 91;
                int topScreenCoordinate = mc.getWindow().getGuiScaledHeight() - 59;
                int maxHearts = OverlayChoking.getVehicleMaxHearts((LivingEntity)OverlayChoking.mc.player);
                int maxAir = OverlayChoking.mc.player.getMaxAirSupply();
                int currentAir = Math.min(airOverrideValue, maxAir);
                int rowCount = OverlayChoking.getVisibleVehicleHeartRows(maxHearts) - 1;
                topScreenCoordinate -= rowCount * 10;
                int fullBubbles = Mth.ceil((double)((double)(currentAir - 2) * 10.0 / (double)maxAir));
                int partialBubbles = Mth.ceil((double)((double)currentAir * 10.0 / (double)maxAir)) - fullBubbles;
                for (int j5 = 0; j5 < fullBubbles + partialBubbles; ++j5) {
                    if (j5 < fullBubbles) {
                        guiGraphics.blit(GUI_ICONS_LOCATION, leftScreenCoordinate - j5 * 8 - 9, topScreenCoordinate, 16, 18, 9, 9);
                        continue;
                    }
                    guiGraphics.blit(GUI_ICONS_LOCATION, leftScreenCoordinate - j5 * 8 - 9, topScreenCoordinate, 25, 18, 9, 9);
                }
            }
        }
    }
}

