/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="infernalmobs")
public class OverlayBossBar {
    private static final double NAME_VISION_DISTANCE = 32.0;
    private static Minecraft mc;
    private static long healthBarRetainTime;
    private static LivingEntity retainedTarget;
    private static long nextPacketTime;
    private static LinkedHashMap<UUID, LerpingBossEvent> vanillaBossEventsMap;

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)ModLoadingContext.get().getActiveNamespace(), (String)"infernalmobs_bossbar"), (LayeredDraw.Layer)new InfernalMobsHealthBarGuiOverlay());
        mc = Minecraft.getInstance();
        healthBarRetainTime = 0L;
        retainedTarget = null;
        nextPacketTime = 0L;
    }

    private static void drawModifiersUnderHealthBar(GuiGraphics guiGraphics, MobModifier mod) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int screenwidth = mc.getWindow().getGuiScaledWidth();
        Font fontR = OverlayBossBar.mc.font;
        int yCoord = 10;
        String[] display = mod.getDisplayNames();
        for (int i = 0; i < display.length && display[i] != null; ++i) {
            guiGraphics.drawString(OverlayBossBar.mc.font, display[i], screenwidth / 2 - fontR.width(display[i]) / 2, yCoord += 10, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
    }

    private static LivingEntity getEntityCrosshairOver(float partialTicks, Minecraft mc) {
        Entity entity = mc.getCameraEntity();
        if (entity != null && mc.level != null) {
            AABB axisalignedbb;
            double distance = 32.0;
            HitResult result = entity.pick(distance, partialTicks, false);
            Vec3 vec3d = entity.getEyePosition(partialTicks);
            double distanceToHit = result.getLocation().distanceToSqr(vec3d);
            Vec3 vec3d1 = entity.getViewVector(1.0f);
            Vec3 vec3d2 = vec3d.add(vec3d1.x * distance, vec3d1.y * distance, vec3d1.z * distance);
            EntityHitResult entityraytraceresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)vec3d, (Vec3)vec3d2, (AABB)(axisalignedbb = entity.getBoundingBox().expandTowards(vec3d1.scale(distance)).inflate(1.0, 1.0, 1.0)), p_lambda$getMouseOver$0_0_ -> !p_lambda$getMouseOver$0_0_.isSpectator() && p_lambda$getMouseOver$0_0_.isPickable(), (double)distanceToHit);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.getEntity();
                Vec3 vec3d3 = entityraytraceresult.getLocation();
                double d2 = vec3d.distanceToSqr(vec3d3);
                if (d2 < distanceToHit && entity1 instanceof LivingEntity) {
                    return (LivingEntity)entity1;
                }
            }
        }
        return null;
    }

    private static void askServerMods(Entity ent) {
        if (System.currentTimeMillis() > nextPacketTime && (ent instanceof Mob || ent instanceof LivingEntity && ent instanceof Enemy)) {
            MobModsPacket mobModsPacket = new MobModsPacket(OverlayBossBar.mc.player.getName().getString(), ent.getId(), 0);
            PacketDistributor.sendToServer((CustomPacketPayload)mobModsPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            InfernalMobsCore.LOGGER.debug("askServerMods {}, ent-id {} querying modifiers from server", (Object)ent, (Object)ent.getId());
            nextPacketTime = System.currentTimeMillis() + 250L;
        }
    }

    private static void askServerHealth(Entity ent) {
        if (System.currentTimeMillis() > nextPacketTime) {
            HealthPacket healthPacket = new HealthPacket(OverlayBossBar.mc.player.getName().getString(), ent.getId(), 0.0f, 0.0f);
            PacketDistributor.sendToServer((CustomPacketPayload)healthPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            nextPacketTime = System.currentTimeMillis() + 250L;
        }
    }

    static {
        vanillaBossEventsMap = null;
    }

    public static class InfernalMobsHealthBarGuiOverlay
    implements LayeredDraw.Layer {
        public void render(@NotNull GuiGraphics guiGraphics, DeltaTracker partialTick) {
            if (InfernalMobsCore.instance().getIsHealthBarDisabled() || OverlayBossBar.mc.gui.getBossOverlay().shouldPlayMusic()) {
                return;
            }
            LivingEntity ent = OverlayBossBar.getEntityCrosshairOver(partialTick.getRealtimeDeltaTicks(), mc);
            boolean retained = false;
            if (ent == null && System.currentTimeMillis() < healthBarRetainTime) {
                ent = retainedTarget;
                retained = true;
            } else if (retainedTarget != null) {
                vanillaBossEventsMap.remove(retainedTarget.getUUID());
                retainedTarget = null;
            }
            if (vanillaBossEventsMap == null) {
                boolean hackSuccess = false;
                for (Field declaredField : BossHealthOverlay.class.getDeclaredFields()) {
                    if (declaredField.getType() != Map.class) continue;
                    declaredField.setAccessible(true);
                    try {
                        vanillaBossEventsMap = (LinkedHashMap)declaredField.get(OverlayBossBar.mc.gui.getBossOverlay());
                        hackSuccess = true;
                    }
                    catch (IllegalAccessException e) {
                        hackSuccess = false;
                    }
                }
                if (!hackSuccess) {
                    vanillaBossEventsMap = new LinkedHashMap();
                }
            }
            if (ent != null) {
                MobModifier mod = InfernalMobsCore.getMobModifiers(ent);
                if (mod != null) {
                    BossEvent.BossBarColor color;
                    int modStr;
                    OverlayBossBar.askServerHealth((Entity)ent);
                    UUID uuid = ent.getUUID();
                    MutableComponent name = Component.literal((String)mod.getEntityDisplayName(ent));
                    float progress = mod.getActualHealth(ent) / mod.getActualMaxHealth(ent);
                    if (ent.isDeadOrDying()) {
                        progress = 0.01f;
                    }
                    BossEvent.BossBarColor bossBarColor = (modStr = mod.getModSize()) <= 5 ? BossEvent.BossBarColor.GREEN : (color = modStr <= 10 ? BossEvent.BossBarColor.YELLOW : BossEvent.BossBarColor.RED);
                    if (!vanillaBossEventsMap.containsKey(uuid)) {
                        vanillaBossEventsMap.put(uuid, new LerpingBossEvent(uuid, (Component)name, progress, color, BossEvent.BossBarOverlay.PROGRESS, false, false, false));
                    } else {
                        LerpingBossEvent bossEvent = vanillaBossEventsMap.get(uuid);
                        bossEvent.setProgress(progress);
                    }
                    if (vanillaBossEventsMap.size() == 1) {
                        OverlayBossBar.drawModifiersUnderHealthBar(guiGraphics, mod);
                    }
                    if (!retained) {
                        retainedTarget = ent;
                        healthBarRetainTime = System.currentTimeMillis() + 3000L;
                    }
                } else {
                    OverlayBossBar.askServerMods((Entity)ent);
                }
            }
        }
    }
}

