/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.herbsandharvest.data;

import com.google.common.collect.Sets;
import com.mamailes.herbsandharvest.data.MHHBlockLootTables;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class MHHLootTables
extends LootTableProvider {
    public MHHLootTables(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(MHHBlockLootTables::new, LootContextParamSets.BLOCK)), pRegistries);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        Set modLootTablesId = BuiltInLootTables.all().stream().filter(id -> id.registry().getNamespace().equals("herbsandharvest")).collect(Collectors.toSet());
        for (ResourceKey id2 : Sets.difference(modLootTablesId, (Set)writableregistry.keySet())) {
            validationcontext.reportProblem("Missing built-in table: " + String.valueOf(id2));
        }
        writableregistry.forEach(lootTable -> lootTable.validate(validationcontext));
    }
}

