/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.herbsandharvest;

import com.mamailes.herbsandharvest.config.Config;
import com.mamailes.herbsandharvest.init.MHHBlocks;
import com.mamailes.herbsandharvest.init.MHHCreativeTabs;
import com.mamailes.herbsandharvest.init.MHHItems;
import com.mamailes.herbsandharvest.init.MHHLootModifiers;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="herbsandharvest")
public class HerbsAndHarvest {
    public static final String MODID = "herbsandharvest";
    private static final String MODEL_DIR = "textures/entity/";
    private static final Logger LOGGER = LogUtils.getLogger();

    public HerbsAndHarvest(IEventBus modEventBus, ModContainer modContainer) {
        IEventBus neoForgeBus = NeoForge.EVENT_BUS;
        modEventBus.addListener(this::commonSetup);
        MHHBlocks.register(modEventBus);
        MHHItems.register(modEventBus);
        MHHCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        MHHLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.BASIL_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_BASIL);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.BAY_LEAF_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_BAY_LEAF);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.CHIVE_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_CHIVE);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.CILANTRO_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_CILANTRO);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.DILL_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_DILL);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.LEMONGRASS_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_LEMONGRASS);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.MINT_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_MINT);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.MUSTARD_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_MUSTARD);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.OREGANO_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_OREGANO);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.PARSLEY_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_PARSLEY);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.PEPPERCORN_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_PEPPERCORN);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.ROSEMARY_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_ROSEMARY);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.SAGE_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_SAGE);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.THYME_PLACEABLE_HERB.getId(), MHHBlocks.POTTED_THYME);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.AVOCADO_FRUIT_SAPLING.getId(), MHHBlocks.POTTED_AVOCADO_FRUIT_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.CHERRY_FRUIT_SAPLING.getId(), MHHBlocks.POTTED_CHERRY_FRUIT_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.LEMON_FRUIT_SAPLING.getId(), MHHBlocks.POTTED_LEMON_FRUIT_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.LIME_FRUIT_SAPLING.getId(), MHHBlocks.POTTED_LIME_FRUIT_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.ORANGE_FRUIT_SAPLING.getId(), MHHBlocks.POTTED_ORANGE_FRUIT_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.PEACH_FRUIT_SAPLING.getId(), MHHBlocks.POTTED_PEACH_FRUIT_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.PEAR_FRUIT_SAPLING.getId(), MHHBlocks.POTTED_PEAR_FRUIT_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(MHHBlocks.PLUM_FRUIT_SAPLING.getId(), MHHBlocks.POTTED_PLUM_FRUIT_SAPLING);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static ResourceLocation getModelTexture(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)(MODEL_DIR + name));
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }

    @EventBusSubscriber(modid="herbsandharvest", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        }
    }
}

