/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.registry;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.registry.registries.options.DefaultIdRegistrarOption;
import dev.architectury.registry.registries.options.RegistrarOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.power.GemPower;
import net.sweenus.simplyswords.power.PowerType;
import net.sweenus.simplyswords.power.powers.ActiveDefencePower;
import net.sweenus.simplyswords.power.powers.BerserkPower;
import net.sweenus.simplyswords.power.powers.EchoPower;
import net.sweenus.simplyswords.power.powers.FloatPower;
import net.sweenus.simplyswords.power.powers.FreezePower;
import net.sweenus.simplyswords.power.powers.FrostWardPower;
import net.sweenus.simplyswords.power.powers.ImbuedPower;
import net.sweenus.simplyswords.power.powers.ImmolationPower;
import net.sweenus.simplyswords.power.powers.MomentumPower;
import net.sweenus.simplyswords.power.powers.NullificationPower;
import net.sweenus.simplyswords.power.powers.OnslaughtPower;
import net.sweenus.simplyswords.power.powers.PincushionPower;
import net.sweenus.simplyswords.power.powers.RadiancePower;
import net.sweenus.simplyswords.power.powers.ShieldingPower;
import net.sweenus.simplyswords.power.powers.SlowPower;
import net.sweenus.simplyswords.power.powers.StoneskinPower;
import net.sweenus.simplyswords.power.powers.SwiftnessPower;
import net.sweenus.simplyswords.power.powers.ThrowingPower;
import net.sweenus.simplyswords.power.powers.TrailblazePower;
import net.sweenus.simplyswords.power.powers.UnstablePower;
import net.sweenus.simplyswords.power.powers.WardPower;
import net.sweenus.simplyswords.power.powers.WeakenPower;
import net.sweenus.simplyswords.power.powers.WildfirePower;
import net.sweenus.simplyswords.power.powers.ZephyrPower;
import net.sweenus.simplyswords.util.HelperMethods;

public class GemPowerRegistry {
    public static Registrar<GemPower> REGISTRY = RegistrarManager.get((String)"simplyswords").builder(ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)"gem_power"), (Object[])new GemPower[0]).option((RegistrarOption)new DefaultIdRegistrarOption(ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)"empty_power"))).syncToClients().build();
    public static RegistrySupplier<GemPower> EMPTY = GemPowerRegistry.register("empty_power", () -> GemPower.EMPTY);
    public static RegistrySupplier<GemPower> ACTIVE_DEFENCE = GemPowerRegistry.register("active_defence", ActiveDefencePower::new);
    public static RegistrySupplier<GemPower> FLOAT = GemPowerRegistry.register("float", () -> new FloatPower(false));
    public static RegistrySupplier<GemPower> GREATER_FLOAT = GemPowerRegistry.register("greater_float", () -> new FloatPower(true));
    public static RegistrySupplier<GemPower> FREEZE = GemPowerRegistry.register("freeze", FreezePower::new);
    public static RegistrySupplier<GemPower> SHIELDING = GemPowerRegistry.register("shielding", () -> new ShieldingPower(false));
    public static RegistrySupplier<GemPower> GREATER_SHIELDING = GemPowerRegistry.register("greater_shielding", () -> new ShieldingPower(true));
    public static RegistrySupplier<GemPower> SLOW = GemPowerRegistry.register("slow", () -> new SlowPower(false));
    public static RegistrySupplier<GemPower> GREATER_SLOW = GemPowerRegistry.register("greater_slow", () -> new SlowPower(true));
    public static RegistrySupplier<GemPower> STONESKIN = GemPowerRegistry.register("stoneskin", () -> new StoneskinPower(false));
    public static RegistrySupplier<GemPower> GREATER_STONESKIN = GemPowerRegistry.register("greater_stoneskin", () -> new StoneskinPower(true));
    public static RegistrySupplier<GemPower> SWIFTNESS = GemPowerRegistry.register("swiftness", () -> new SwiftnessPower(false));
    public static RegistrySupplier<GemPower> GREATER_SWIFTNESS = GemPowerRegistry.register("greater_swiftness", () -> new SwiftnessPower(true));
    public static RegistrySupplier<GemPower> TRAILBLAZE = GemPowerRegistry.register("trailblaze", () -> new TrailblazePower(false));
    public static RegistrySupplier<GemPower> GREATER_TRAILBLAZE = GemPowerRegistry.register("greater_trailblaze", () -> new TrailblazePower(true));
    public static RegistrySupplier<GemPower> WEAKEN = GemPowerRegistry.register("weaken", () -> new WeakenPower(false));
    public static RegistrySupplier<GemPower> GREATER_WEAKEN = GemPowerRegistry.register("greater_weaken", () -> new WeakenPower(true));
    public static RegistrySupplier<GemPower> ZEPHYR = GemPowerRegistry.register("zephyr", () -> new ZephyrPower(false));
    public static RegistrySupplier<GemPower> GREATER_ZEPHYR = GemPowerRegistry.register("greater_zephyr", () -> new ZephyrPower(true));
    public static RegistrySupplier<GemPower> FROST_WARD = GemPowerRegistry.register("frost_ward", FrostWardPower::new);
    public static RegistrySupplier<GemPower> WILDFIRE = GemPowerRegistry.register("wildfire", WildfirePower::new);
    public static RegistrySupplier<GemPower> UNSTABLE = GemPowerRegistry.register("unstable", UnstablePower::new);
    public static RegistrySupplier<GemPower> IMBUED = GemPowerRegistry.register("imbued", () -> new ImbuedPower(false));
    public static RegistrySupplier<GemPower> GREATER_IMBUED = GemPowerRegistry.register("greater_imbued", () -> new ImbuedPower(true));
    public static RegistrySupplier<GemPower> PINCUSHION = GemPowerRegistry.register("pincushion", () -> new PincushionPower(false));
    public static RegistrySupplier<GemPower> GREATER_PINCUSHION = GemPowerRegistry.register("greater_pincushion", () -> new PincushionPower(true));
    public static RegistrySupplier<GemPower> MOMENTUM = GemPowerRegistry.register("momentum", () -> new MomentumPower(false));
    public static RegistrySupplier<GemPower> GREATER_MOMENTUM = GemPowerRegistry.register("greater_momentum", () -> new MomentumPower(true));
    public static RegistrySupplier<GemPower> WARD = GemPowerRegistry.register("ward", WardPower::new);
    public static RegistrySupplier<GemPower> IMMOLATION = GemPowerRegistry.register("immolation", ImmolationPower::new);
    public static RegistrySupplier<GemPower> THROWING = GemPowerRegistry.register("throwing", ThrowingPower::new);
    public static RegistrySupplier<GemPower> ECHO = GemPowerRegistry.register("echo", EchoPower::new);
    public static RegistrySupplier<GemPower> BERSERK = GemPowerRegistry.register("berserk", BerserkPower::new);
    public static RegistrySupplier<GemPower> RADIANCE = GemPowerRegistry.register("radiance", RadiancePower::new);
    public static RegistrySupplier<GemPower> ONSLAUGHT = GemPowerRegistry.register("onslaught", OnslaughtPower::new);
    public static RegistrySupplier<GemPower> NULLIFICATION = GemPowerRegistry.register("nullification", NullificationPower::new);

    public static void register() {
    }

    private static RegistrySupplier<GemPower> register(String path, Supplier<GemPower> power) {
        return REGISTRY.register(ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)path), power);
    }

    public static List<? extends Holder<GemPower>> getPowers(PowerType powerType) {
        return powerType.getEntries().stream().filter(entry -> !Config.gemPowers.disabledPowers.contains((Object)entry.getId())).toList();
    }

    public static Holder<GemPower> gemRandomPower(PowerType powerType) {
        return GemPowerRegistry.gemRandomPower(powerType, null);
    }

    public static Holder<GemPower> gemRandomPower(PowerType powerType, String[] blacklist) {
        List<? extends Holder<GemPower>> powers = GemPowerRegistry.getPowers(powerType);
        if (powers.isEmpty()) {
            return EMPTY;
        }
        if (blacklist != null) {
            HashSet<String> blacklistSet = new HashSet<String>(Arrays.asList(blacklist));
            if ((powers = powers.stream().filter(power -> !blacklistSet.contains(power.toString())).toList()).isEmpty()) {
                return EMPTY;
            }
        }
        return powers.get(HelperMethods.random().nextInt(powers.size()));
    }
}

