/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class StarsEdgeSwordItem
extends UniqueSwordItem {
    public StarsEdgeSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            float skillDamageModifier = Config.uniqueEffects.stars_edge.damageModifier;
            float skillLifestealModifier = Config.uniqueEffects.stars_edge.lifestealModifier;
            ServerLevel world = (ServerLevel)attacker.level();
            DamageSource damageSource = world.damageSources().generic();
            float abilityDamage = (float)HelperMethods.getEntityAttackDamage(attacker);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                damageSource = attacker.damageSources().playerAttack(player);
            }
            HelperMethods.playHitSounds(attacker, target);
            if (world.isDay()) {
                target.invulnerableTime = 0;
                target.hurt(damageSource, abilityDamage * skillDamageModifier);
            } else if (world.isNight()) {
                attacker.heal(abilityDamage * skillLifestealModifier);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        int skillCooldown = Config.uniqueEffects.stars_edge.cooldown;
        int skillDuration = Config.uniqueEffects.stars_edge.duration;
        int skillStacks = Config.uniqueEffects.stars_edge.stacks;
        if (!user.hasEffect(MobEffects.MOVEMENT_SPEED)) {
            user.swing(hand);
            world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_02.get(), user.getSoundSource(), 0.3f, 1.0f);
            user.setDeltaMovement(user.getLookAngle().reverse().scale(1.5));
            user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
            user.hurtMarked = true;
            HelperMethods.incrementStatusEffect((LivingEntity)user, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, skillDuration, 1, 2);
        } else {
            MobEffectInstance speedEffect = user.getEffect(MobEffects.MOVEMENT_SPEED);
            if (speedEffect != null && speedEffect.getDuration() < skillDuration - 10) {
                world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_01.get(), user.getSoundSource(), 0.5f, 1.3f);
                user.setDeltaMovement(user.getLookAngle().scale(1.7));
                user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
                user.hurtMarked = true;
                user.removeEffect(MobEffects.MOVEMENT_SPEED);
                HelperMethods.incrementStatusEffect((LivingEntity)user, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, skillDuration / 2, 2, 3);
                HelperMethods.incrementStatusEffect((LivingEntity)user, (Holder<MobEffect>)MobEffects.DIG_SPEED, skillDuration / 2, skillStacks, 7);
                user.getCooldowns().addCooldown((Item)this, skillCooldown);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.FALLING_OBSIDIAN_TEAR, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        float skillDamageModifier = Config.uniqueEffects.stars_edge.damageModifier;
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.starsedgesworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.starsedgesworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.starsedgesworditem.tooltip3", (Object[])new Object[]{Float.valueOf(skillDamageModifier)}).setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.starsedgesworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.starsedgesworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.starsedgesworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.starsedgesworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.starsedgesworditem.tooltip8").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damageModifier;
        @ValidatedFloat.Restrict(min=0.0f)
        public float lifestealModifier;
        @ValidatedInt.Restrict(min=1)
        public int stacks;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.STARS_EDGE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 120;
            this.duration = 120;
            this.damageModifier = 0.4f;
            this.lifestealModifier = 0.1f;
            this.stacks = 6;
        }
    }
}

