/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class PlagueSwordItem
extends UniqueSwordItem {
    public PlagueSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int hitChance = Config.uniqueEffects.toxic_longsword.chance;
        HelperMethods.playHitSounds(attacker, target);
        if (attacker.getRandom().nextInt(100) <= hitChance) {
            int statamp;
            int statdur;
            if (target.hasEffect(MobEffects.DIG_SPEED)) {
                statdur = target.getEffect(MobEffects.DIG_SPEED).getDuration();
                statamp = target.getEffect(MobEffects.DIG_SPEED).getAmplifier();
                target.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, statdur, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.DIG_SPEED);
            }
            if (target.hasEffect(MobEffects.REGENERATION)) {
                statdur = target.getEffect(MobEffects.REGENERATION).getDuration();
                statamp = target.getEffect(MobEffects.REGENERATION).getAmplifier();
                target.addEffect(new MobEffectInstance(MobEffects.WITHER, statdur, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.REGENERATION);
            }
            if (target.hasEffect(MobEffects.DAMAGE_BOOST)) {
                statdur = target.getEffect(MobEffects.DAMAGE_BOOST).getDuration();
                statamp = target.getEffect(MobEffects.DAMAGE_BOOST).getAmplifier();
                target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, statdur, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.DAMAGE_BOOST);
            }
            if (target.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                statdur = target.getEffect(MobEffects.MOVEMENT_SPEED).getDuration();
                statamp = target.getEffect(MobEffects.MOVEMENT_SPEED).getAmplifier();
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, statdur, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.MOVEMENT_SPEED);
            }
            if (target.hasEffect(MobEffects.INVISIBILITY)) {
                statdur = target.getEffect(MobEffects.INVISIBILITY).getDuration();
                statamp = target.getEffect(MobEffects.INVISIBILITY).getAmplifier();
                target.addEffect(new MobEffectInstance(MobEffects.GLOWING, statdur, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.INVISIBILITY);
            }
            if (target.hasEffect(MobEffects.DAMAGE_RESISTANCE)) {
                statdur = target.getEffect(MobEffects.DAMAGE_RESISTANCE).getDuration();
                statamp = target.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier();
                target.addEffect(new MobEffectInstance(MobEffects.CONFUSION, statdur, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.DAMAGE_RESISTANCE);
            }
            if (target.hasEffect(MobEffects.SATURATION)) {
                statdur = target.getEffect(MobEffects.SATURATION).getDuration();
                statamp = target.getEffect(MobEffects.SATURATION).getAmplifier();
                target.addEffect(new MobEffectInstance(MobEffects.HUNGER, statdur, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.SATURATION);
            }
            if (target.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                statdur = target.getEffect(MobEffects.FIRE_RESISTANCE).getDuration();
                statamp = target.getEffect(MobEffects.FIRE_RESISTANCE).getAmplifier();
                target.addEffect(new MobEffectInstance(MobEffects.POISON, statdur, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.FIRE_RESISTANCE);
            }
            if (target.hasEffect(MobEffects.ABSORPTION)) {
                statdur = target.getEffect(MobEffects.ABSORPTION).getDuration();
                statamp = target.getEffect(MobEffects.ABSORPTION).getAmplifier() / 2;
                target.addEffect(new MobEffectInstance(MobEffects.HARM, 0, statamp), (Entity)attacker);
                target.removeEffect(MobEffects.ABSORPTION);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, (ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, (ParticleOptions)ParticleTypes.FALLING_SPORE_BLOSSOM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.plaguesworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.plaguesworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.plaguesworditem.tooltip3").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.TOXIC_LONGSWORD.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 55;
        }
    }
}

