/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class FlamewindSwordItem
extends UniqueSwordItem {
    public FlamewindSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            ServerLevel serverWorld = (ServerLevel)attacker.level();
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!user.level().isClientSide() && world instanceof ServerLevel) {
            LivingEntity ee;
            ServerLevel serverWorld = (ServerLevel)world;
            int flameSeedDuration = 101;
            int flameSeedSpreadCap = Config.uniqueEffects.flamewind.spreadCap;
            int skillCooldown = Config.uniqueEffects.flamewind.cooldown;
            AABB box = HelperMethods.createBox((Entity)user, 10.0);
            Entity closestEntity = world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE).stream().min(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)user))).orElse(null);
            if (closestEntity != null && closestEntity instanceof LivingEntity && HelperMethods.checkFriendlyFire(ee = (LivingEntity)closestEntity, (LivingEntity)user) && !ee.hasEffect(EffectRegistry.getReference(EffectRegistry.FLAMESEED))) {
                SoundEvent soundSelect = (SoundEvent)SoundRegistry.SPELL_FIRE.get();
                int particleCount = 20;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (ParticleOptions)ParticleTypes.LAVA, (Entity)user, (Entity)ee, particleCount);
                world.playSound(null, user.blockPosition(), soundSelect, user.getSoundSource(), 0.3f, 1.3f);
                SimplySwordsStatusEffectInstance flamSeedEffect = new SimplySwordsStatusEffectInstance(EffectRegistry.getReference(EffectRegistry.FLAMESEED), flameSeedDuration, 0, false, false, true);
                flamSeedEffect.setSourceEntity((LivingEntity)user);
                flamSeedEffect.setAdditionalData(flameSeedSpreadCap);
                ee.addEffect((MobEffectInstance)flamSeedEffect);
                user.getCooldowns().addCooldown((Item)this, skillCooldown);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.FLAME, (ParticleOptions)ParticleTypes.FLAME, (ParticleOptions)ParticleTypes.ASH, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip9").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip10").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.flamewindsworditem.tooltip11", (Object[])new Object[]{Config.uniqueEffects.flamewind.spreadCap}).setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "fire");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;
        @ValidatedFloat.Restrict(min=0.0f)
        public float detonationDamage;
        @ValidatedInt.Restrict(min=0)
        public int maxHaste;
        @ValidatedInt.Restrict(min=1)
        public int spreadCap;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.FLAMEWIND.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 980;
            this.damage = 5.0f;
            this.spellScaling = 0.4f;
            this.detonationDamage = 15.0f;
            this.maxHaste = 10;
            this.spreadCap = 6;
        }
    }
}

